/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Platform;
import com.sun.media.sound.PortMixer;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;

public final class PortMixerProvider
extends MixerProvider {
    private static PortMixerInfo[] infos;
    private static PortMixer[] devices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortMixerProvider() {
        Class<PortMixerProvider> clazz = PortMixerProvider.class;
        synchronized (PortMixerProvider.class) {
            if (Platform.isPortsEnabled()) {
                PortMixerProvider.init();
            } else {
                infos = new PortMixerInfo[0];
                devices = new PortMixer[0];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void init() {
        int numDevices = PortMixerProvider.nGetNumDevices();
        if (infos == null || infos.length != numDevices) {
            infos = new PortMixerInfo[numDevices];
            devices = new PortMixer[numDevices];
            for (int i = 0; i < infos.length; ++i) {
                PortMixerProvider.infos[i] = PortMixerProvider.nNewPortMixerInfo(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer.Info[] getMixerInfo() {
        Class<PortMixerProvider> clazz = PortMixerProvider.class;
        synchronized (PortMixerProvider.class) {
            Mixer.Info[] localArray = new Mixer.Info[infos.length];
            System.arraycopy(infos, 0, localArray, 0, infos.length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer getMixer(Mixer.Info info) {
        Class<PortMixerProvider> clazz = PortMixerProvider.class;
        synchronized (PortMixerProvider.class) {
            for (int i = 0; i < infos.length; ++i) {
                if (!infos[i].equals(info)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return PortMixerProvider.getDevice(infos[i]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            throw new IllegalArgumentException("Mixer " + info.toString() + " not supported by this provider.");
        }
    }

    private static Mixer getDevice(PortMixerInfo info) {
        int index = info.getIndex();
        if (devices[index] == null) {
            PortMixerProvider.devices[index] = new PortMixer(info);
        }
        return devices[index];
    }

    private static native int nGetNumDevices();

    private static native PortMixerInfo nNewPortMixerInfo(int var0);

    static {
        Platform.initialize();
    }

    static final class PortMixerInfo
    extends Mixer.Info {
        private final int index;

        private PortMixerInfo(int index, String name, String vendor, String description, String version) {
            super("Port " + name, vendor, description, version);
            this.index = index;
        }

        int getIndex() {
            return this.index;
        }
    }
}

