/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GraphicAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import sun.font.BidiUtils;
import sun.font.CoreMetrics;
import sun.font.Decoration;
import sun.font.TextLineComponent;

public final class GraphicComponent
implements TextLineComponent,
Decoration.Label {
    public static final float GRAPHIC_LEADING = 2.0f;
    private GraphicAttribute graphic;
    private int graphicCount;
    private int[] charsLtoV;
    private byte[] levels;
    private Rectangle2D visualBounds = null;
    private float graphicAdvance;
    private AffineTransform baseTx;
    private CoreMetrics cm;
    private Decoration decorator;

    public GraphicComponent(GraphicAttribute graphic, Decoration decorator, int[] charsLtoV, byte[] levels, int start, int limit, AffineTransform baseTx) {
        if (limit <= start) {
            throw new IllegalArgumentException("0 or negative length in GraphicComponent");
        }
        this.graphic = graphic;
        this.graphicAdvance = graphic.getAdvance();
        this.decorator = decorator;
        this.cm = GraphicComponent.createCoreMetrics(graphic);
        this.baseTx = baseTx;
        this.initLocalOrdering(charsLtoV, levels, start, limit);
    }

    private GraphicComponent(GraphicComponent parent, int start, int limit, int dir) {
        this.graphic = parent.graphic;
        this.graphicAdvance = parent.graphicAdvance;
        this.decorator = parent.decorator;
        this.cm = parent.cm;
        this.baseTx = parent.baseTx;
        int[] charsLtoV = null;
        byte[] levels = null;
        if (dir == 2) {
            charsLtoV = parent.charsLtoV;
            levels = parent.levels;
        } else if (dir == 0 || dir == 1) {
            limit -= start;
            start = 0;
            if (dir == 1) {
                charsLtoV = new int[limit];
                levels = new byte[limit];
                for (int i = 0; i < limit; ++i) {
                    charsLtoV[i] = limit - i - 1;
                    levels[i] = 1;
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid direction flag");
        }
        this.initLocalOrdering(charsLtoV, levels, start, limit);
    }

    private void initLocalOrdering(int[] charsLtoV, byte[] levels, int start, int limit) {
        this.graphicCount = limit - start;
        this.charsLtoV = charsLtoV == null || charsLtoV.length == this.graphicCount ? charsLtoV : BidiUtils.createNormalizedMap(charsLtoV, levels, start, limit);
        if (levels == null || levels.length == this.graphicCount) {
            this.levels = levels;
        } else {
            this.levels = new byte[this.graphicCount];
            System.arraycopy(levels, start, this.levels, 0, this.graphicCount);
        }
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public Rectangle getPixelBounds(FontRenderContext frc, float x, float y) {
        throw new InternalError("do not call if isSimple returns false");
    }

    @Override
    public Rectangle2D handleGetVisualBounds() {
        Rectangle2D bounds = this.graphic.getBounds();
        float width = (float)bounds.getWidth() + this.graphicAdvance * (float)(this.graphicCount - 1);
        return new Rectangle2D.Float((float)bounds.getX(), (float)bounds.getY(), width, (float)bounds.getHeight());
    }

    @Override
    public CoreMetrics getCoreMetrics() {
        return this.cm;
    }

    public static CoreMetrics createCoreMetrics(GraphicAttribute graphic) {
        return new CoreMetrics(graphic.getAscent(), graphic.getDescent(), 2.0f, graphic.getAscent() + graphic.getDescent() + 2.0f, graphic.getAlignment(), new float[]{0.0f, -graphic.getAscent() / 2.0f, -graphic.getAscent()}, -graphic.getAscent() / 2.0f, graphic.getAscent() / 12.0f, graphic.getDescent() / 3.0f, graphic.getAscent() / 12.0f, 0.0f, 0.0f);
    }

    public float getItalicAngle() {
        return 0.0f;
    }

    @Override
    public Rectangle2D getVisualBounds() {
        if (this.visualBounds == null) {
            this.visualBounds = this.decorator.getVisualBounds(this);
        }
        Rectangle2D.Float bounds = new Rectangle2D.Float();
        bounds.setRect(this.visualBounds);
        return bounds;
    }

    @Override
    public Shape handleGetOutline(float x, float y) {
        double[] matrix = new double[]{1.0, 0.0, 0.0, 1.0, x, y};
        if (this.graphicCount == 1) {
            AffineTransform tx = new AffineTransform(matrix);
            return this.graphic.getOutline(tx);
        }
        GeneralPath gp = new GeneralPath();
        for (int i = 0; i < this.graphicCount; ++i) {
            AffineTransform tx = new AffineTransform(matrix);
            gp.append(this.graphic.getOutline(tx), false);
            matrix[4] = matrix[4] + (double)this.graphicAdvance;
        }
        return gp;
    }

    @Override
    public AffineTransform getBaselineTransform() {
        return this.baseTx;
    }

    @Override
    public Shape getOutline(float x, float y) {
        return this.decorator.getOutline(this, x, y);
    }

    @Override
    public void handleDraw(Graphics2D g2d, float x, float y) {
        for (int i = 0; i < this.graphicCount; ++i) {
            this.graphic.draw(g2d, x, y);
            x += this.graphicAdvance;
        }
    }

    @Override
    public void draw(Graphics2D g2d, float x, float y) {
        this.decorator.drawTextAndDecorations(this, g2d, x, y);
    }

    @Override
    public Rectangle2D getCharVisualBounds(int index) {
        return this.decorator.getCharVisualBounds(this, index);
    }

    @Override
    public int getNumCharacters() {
        return this.graphicCount;
    }

    @Override
    public float getCharX(int index) {
        int visIndex = this.charsLtoV == null ? index : this.charsLtoV[index];
        return this.graphicAdvance * (float)visIndex;
    }

    @Override
    public float getCharY(int index) {
        return 0.0f;
    }

    @Override
    public float getCharAdvance(int index) {
        return this.graphicAdvance;
    }

    @Override
    public boolean caretAtOffsetIsValid(int index) {
        return true;
    }

    @Override
    public Rectangle2D handleGetCharVisualBounds(int index) {
        Rectangle2D bounds = this.graphic.getBounds();
        Rectangle2D.Float charBounds = new Rectangle2D.Float();
        charBounds.setRect(bounds);
        charBounds.x += this.graphicAdvance * (float)index;
        return charBounds;
    }

    @Override
    public int getLineBreakIndex(int start, float width) {
        int index = (int)(width / this.graphicAdvance);
        if (index > this.graphicCount - start) {
            index = this.graphicCount - start;
        }
        return index;
    }

    @Override
    public float getAdvanceBetween(int start, int limit) {
        return this.graphicAdvance * (float)(limit - start);
    }

    @Override
    public Rectangle2D getLogicalBounds() {
        float left = 0.0f;
        float top = -this.cm.ascent;
        float width = this.graphicAdvance * (float)this.graphicCount;
        float height = this.cm.descent - top;
        return new Rectangle2D.Float(left, top, width, height);
    }

    @Override
    public float getAdvance() {
        return this.graphicAdvance * (float)this.graphicCount;
    }

    @Override
    public Rectangle2D getItalicBounds() {
        return this.getLogicalBounds();
    }

    @Override
    public TextLineComponent getSubset(int start, int limit, int dir) {
        if (start < 0 || limit > this.graphicCount || start >= limit) {
            throw new IllegalArgumentException("Invalid range.  start=" + start + "; limit=" + limit);
        }
        if (start == 0 && limit == this.graphicCount && dir == 2) {
            return this;
        }
        return new GraphicComponent(this, start, limit, dir);
    }

    public String toString() {
        return "[graphic=" + this.graphic + ":count=" + this.getNumCharacters() + "]";
    }

    @Override
    public int getNumJustificationInfos() {
        return 0;
    }

    @Override
    public void getJustificationInfos(GlyphJustificationInfo[] infos, int infoStart, int charStart, int charLimit) {
    }

    @Override
    public TextLineComponent applyJustificationDeltas(float[] deltas, int deltaStart, boolean[] flags) {
        return this;
    }
}

