/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management;

import java.lang.management.MemoryUsage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataView;
import javax.management.openmbean.CompositeType;
import sun.management.GcInfoBuilder;
import sun.management.GcInfoCompositeData;

public class GcInfo
implements CompositeData,
CompositeDataView {
    private final long index;
    private final long startTime;
    private final long endTime;
    private final Map<String, MemoryUsage> usageBeforeGc;
    private final Map<String, MemoryUsage> usageAfterGc;
    private final Object[] extAttributes;
    private final CompositeData cdata;
    private final GcInfoBuilder builder;

    private GcInfo(GcInfoBuilder builder, long index, long startTime, long endTime, MemoryUsage[] muBeforeGc, MemoryUsage[] muAfterGc, Object[] extAttributes) {
        this.builder = builder;
        this.index = index;
        this.startTime = startTime;
        this.endTime = endTime;
        String[] poolNames = builder.getPoolNames();
        this.usageBeforeGc = new HashMap<String, MemoryUsage>(poolNames.length);
        this.usageAfterGc = new HashMap<String, MemoryUsage>(poolNames.length);
        for (int i = 0; i < poolNames.length; ++i) {
            this.usageBeforeGc.put(poolNames[i], muBeforeGc[i]);
            this.usageAfterGc.put(poolNames[i], muAfterGc[i]);
        }
        this.extAttributes = extAttributes;
        this.cdata = new GcInfoCompositeData(this, builder, extAttributes);
    }

    private GcInfo(CompositeData cd) {
        GcInfoCompositeData.validateCompositeData(cd);
        this.index = GcInfoCompositeData.getId(cd);
        this.startTime = GcInfoCompositeData.getStartTime(cd);
        this.endTime = GcInfoCompositeData.getEndTime(cd);
        this.usageBeforeGc = GcInfoCompositeData.getMemoryUsageBeforeGc(cd);
        this.usageAfterGc = GcInfoCompositeData.getMemoryUsageAfterGc(cd);
        this.extAttributes = null;
        this.builder = null;
        this.cdata = cd;
    }

    public long getId() {
        return this.index;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.endTime - this.startTime;
    }

    public Map<String, MemoryUsage> getMemoryUsageBeforeGc() {
        return Collections.unmodifiableMap(this.usageBeforeGc);
    }

    public Map<String, MemoryUsage> getMemoryUsageAfterGc() {
        return Collections.unmodifiableMap(this.usageAfterGc);
    }

    public static GcInfo from(CompositeData cd) {
        if (cd == null) {
            return null;
        }
        if (cd instanceof GcInfoCompositeData) {
            return ((GcInfoCompositeData)cd).getGcInfo();
        }
        return new GcInfo(cd);
    }

    @Override
    public boolean containsKey(String key) {
        return this.cdata.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.cdata.containsValue(value);
    }

    @Override
    public boolean equals(Object obj) {
        return this.cdata.equals(obj);
    }

    @Override
    public Object get(String key) {
        return this.cdata.get(key);
    }

    @Override
    public Object[] getAll(String[] keys) {
        return this.cdata.getAll(keys);
    }

    @Override
    public CompositeType getCompositeType() {
        return this.cdata.getCompositeType();
    }

    @Override
    public int hashCode() {
        return this.cdata.hashCode();
    }

    @Override
    public String toString() {
        return this.cdata.toString();
    }

    public Collection values() {
        return this.cdata.values();
    }

    @Override
    public CompositeData toCompositeData(CompositeType ct) {
        return this.cdata;
    }
}

