/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.util.List;
import javax.swing.SortOrder;
import javax.swing.event.EventListenerList;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;

public abstract class RowSorter<M> {
    private EventListenerList listenerList = new EventListenerList();

    public abstract M getModel();

    public abstract void toggleSortOrder(int var1);

    public abstract int convertRowIndexToModel(int var1);

    public abstract int convertRowIndexToView(int var1);

    public abstract void setSortKeys(List<? extends SortKey> var1);

    public abstract List<? extends SortKey> getSortKeys();

    public abstract int getViewRowCount();

    public abstract int getModelRowCount();

    public abstract void modelStructureChanged();

    public abstract void allRowsChanged();

    public abstract void rowsInserted(int var1, int var2);

    public abstract void rowsDeleted(int var1, int var2);

    public abstract void rowsUpdated(int var1, int var2);

    public abstract void rowsUpdated(int var1, int var2, int var3);

    public void addRowSorterListener(RowSorterListener l) {
        this.listenerList.add(RowSorterListener.class, l);
    }

    public void removeRowSorterListener(RowSorterListener l) {
        this.listenerList.remove(RowSorterListener.class, l);
    }

    protected void fireSortOrderChanged() {
        this.fireRowSorterChanged(new RowSorterEvent(this));
    }

    protected void fireRowSorterChanged(int[] lastRowIndexToModel) {
        this.fireRowSorterChanged(new RowSorterEvent(this, RowSorterEvent.Type.SORTED, lastRowIndexToModel));
    }

    void fireRowSorterChanged(RowSorterEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != RowSorterListener.class) continue;
            ((RowSorterListener)listeners[i + 1]).sorterChanged(event);
        }
    }

    public static class SortKey {
        private int column;
        private SortOrder sortOrder;

        public SortKey(int column, SortOrder sortOrder) {
            if (sortOrder == null) {
                throw new IllegalArgumentException("sort order must be non-null");
            }
            this.column = column;
            this.sortOrder = sortOrder;
        }

        public final int getColumn() {
            return this.column;
        }

        public final SortOrder getSortOrder() {
            return this.sortOrder;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.column;
            result = 37 * result + this.sortOrder.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof SortKey) {
                return ((SortKey)o).column == this.column && ((SortKey)o).sortOrder == this.sortOrder;
            }
            return false;
        }
    }
}

