/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.Action;
import javax.swing.JComponent;

abstract class ActionPropertyChangeListener<T extends JComponent>
implements PropertyChangeListener,
Serializable {
    private static ReferenceQueue<JComponent> queue;
    private transient OwnedWeakReference<T> target;
    private Action action;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReferenceQueue<JComponent> getQueue() {
        Class<ActionPropertyChangeListener> clazz = ActionPropertyChangeListener.class;
        synchronized (ActionPropertyChangeListener.class) {
            if (queue == null) {
                queue = new ReferenceQueue();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return queue;
        }
    }

    public ActionPropertyChangeListener(T c, Action a) {
        this.setTarget(c);
        this.action = a;
    }

    @Override
    public final void propertyChange(PropertyChangeEvent e) {
        T target = this.getTarget();
        if (target == null) {
            this.getAction().removePropertyChangeListener(this);
        } else {
            this.actionPropertyChanged(target, this.getAction(), e);
        }
    }

    protected abstract void actionPropertyChanged(T var1, Action var2, PropertyChangeEvent var3);

    private void setTarget(T c) {
        OwnedWeakReference r;
        ReferenceQueue<JComponent> queue = ActionPropertyChangeListener.getQueue();
        while ((r = (OwnedWeakReference)queue.poll()) != null) {
            ActionPropertyChangeListener oldPCL = r.getOwner();
            Action oldAction = oldPCL.getAction();
            if (oldAction == null) continue;
            oldAction.removePropertyChangeListener(oldPCL);
        }
        this.target = new OwnedWeakReference<JComponent>((JComponent)c, queue, this);
    }

    public T getTarget() {
        if (this.target == null) {
            return null;
        }
        return (T)((JComponent)this.target.get());
    }

    public Action getAction() {
        return this.action;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.getTarget());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        JComponent target = (JComponent)s.readObject();
        if (target != null) {
            this.setTarget(target);
        }
    }

    private static class OwnedWeakReference<U extends JComponent>
    extends WeakReference<U> {
        private ActionPropertyChangeListener owner;

        OwnedWeakReference(U target, ReferenceQueue<? super U> queue, ActionPropertyChangeListener owner) {
            super(target, queue);
            this.owner = owner;
        }

        public ActionPropertyChangeListener getOwner() {
            return this.owner;
        }
    }
}

