/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XKeymapEvent
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 72;
    }

    @Override
    public int getDataSize() {
        return XKeymapEvent.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XKeymapEvent(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XKeymapEvent() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XKeymapEvent.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_type() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_type(int v) {
        log.finest("");
        Native.putInt(this.pData + 0L, v);
    }

    public long get_serial() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_serial(long v) {
        log.finest("");
        Native.putLong(this.pData + 8L, v);
    }

    public boolean get_send_event() {
        log.finest("");
        return Native.getBool(this.pData + 16L);
    }

    public void set_send_event(boolean v) {
        log.finest("");
        Native.putBool(this.pData + 16L, v);
    }

    public long get_display() {
        log.finest("");
        return Native.getLong(this.pData + 24L);
    }

    public void set_display(long v) {
        log.finest("");
        Native.putLong(this.pData + 24L, v);
    }

    public long get_window() {
        log.finest("");
        return Native.getLong(this.pData + 32L);
    }

    public void set_window(long v) {
        log.finest("");
        Native.putLong(this.pData + 32L, v);
    }

    public byte get_key_vector(int index) {
        log.finest("");
        return Native.getByte(this.pData + 40L + (long)(index * 1));
    }

    public void set_key_vector(int index, byte v) {
        log.finest("");
        Native.putByte(this.pData + 40L + (long)(index * 1), v);
    }

    public long get_key_vector() {
        log.finest("");
        return this.pData + 40L;
    }

    @Override
    String getName() {
        return "XKeymapEvent";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(240);
        ret.append("type = ").append(XlibWrapper.eventToString[this.get_type()]).append(", ");
        ret.append("serial = ").append(this.get_serial()).append(", ");
        ret.append("send_event = ").append(this.get_send_event()).append(", ");
        ret.append("display = ").append(this.get_display()).append(", ");
        ret.append("window = ").append(this.getWindow(this.get_window())).append(", ");
        ret.append("{").append(this.get_key_vector(0)).append(" ").append(this.get_key_vector(1)).append(" ").append(this.get_key_vector(2)).append(" ").append(this.get_key_vector(3)).append(" ").append(this.get_key_vector(4)).append(" ").append(this.get_key_vector(5)).append(" ").append(this.get_key_vector(6)).append(" ").append(this.get_key_vector(7)).append(" ").append(this.get_key_vector(8)).append(" ").append(this.get_key_vector(9)).append(" ").append(this.get_key_vector(10)).append(" ").append(this.get_key_vector(11)).append(" ").append(this.get_key_vector(12)).append(" ").append(this.get_key_vector(13)).append(" ").append(this.get_key_vector(14)).append(" ").append(this.get_key_vector(15)).append(" ").append(this.get_key_vector(16)).append(" ").append(this.get_key_vector(17)).append(" ").append(this.get_key_vector(18)).append(" ").append(this.get_key_vector(19)).append(" ").append(this.get_key_vector(20)).append(" ").append(this.get_key_vector(21)).append(" ").append(this.get_key_vector(22)).append(" ").append(this.get_key_vector(23)).append(" ").append(this.get_key_vector(24)).append(" ").append(this.get_key_vector(25)).append(" ").append(this.get_key_vector(26)).append(" ").append(this.get_key_vector(27)).append(" ").append(this.get_key_vector(28)).append(" ").append(this.get_key_vector(29)).append(" ").append(this.get_key_vector(30)).append(" ").append(this.get_key_vector(31)).append(" ").append("}");
        return ret.toString();
    }
}

