/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.reflectiveObjects;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.reflectiveObjects.LazyReflectiveObjectGenerator;
import sun.reflect.generics.tree.FieldTypeSignature;
import sun.reflect.generics.visitor.Reifier;
import sun.reflect.misc.ReflectUtil;

public class TypeVariableImpl<D extends GenericDeclaration>
extends LazyReflectiveObjectGenerator
implements TypeVariable<D> {
    D genericDeclaration;
    private String name;
    private Type[] bounds;
    private FieldTypeSignature[] boundASTs;

    private TypeVariableImpl(D decl, String n, FieldTypeSignature[] bs, GenericsFactory f) {
        super(f);
        this.genericDeclaration = decl;
        this.name = n;
        this.boundASTs = bs;
    }

    private FieldTypeSignature[] getBoundASTs() {
        assert (this.bounds == null);
        return this.boundASTs;
    }

    public static <T extends GenericDeclaration> TypeVariableImpl<T> make(T decl, String name, FieldTypeSignature[] bs, GenericsFactory f) {
        if (!(decl instanceof Class || decl instanceof Method || decl instanceof Constructor)) {
            throw new AssertionError((Object)("Unexpected kind of GenericDeclaration" + decl.getClass().toString()));
        }
        return new TypeVariableImpl<T>(decl, name, bs, f);
    }

    @Override
    public Type[] getBounds() {
        if (this.bounds == null) {
            FieldTypeSignature[] fts = this.getBoundASTs();
            Type[] ts = new Type[fts.length];
            for (int j = 0; j < fts.length; ++j) {
                Reifier r = this.getReifier();
                fts[j].accept(r);
                ts[j] = r.getResult();
            }
            this.bounds = ts;
        }
        return (Type[])this.bounds.clone();
    }

    @Override
    public D getGenericDeclaration() {
        if (this.genericDeclaration instanceof Class) {
            ReflectUtil.checkPackageAccess((Class)this.genericDeclaration);
        } else if (this.genericDeclaration instanceof Method || this.genericDeclaration instanceof Constructor) {
            ReflectUtil.conservativeCheckMemberAccess((Member)this.genericDeclaration);
        } else {
            throw new AssertionError((Object)"Unexpected kind of GenericDeclaration");
        }
        return this.genericDeclaration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o instanceof TypeVariable && o.getClass() == TypeVariableImpl.class) {
            TypeVariable that = (TypeVariable)o;
            Object thatDecl = that.getGenericDeclaration();
            String thatName = that.getName();
            return (this.genericDeclaration == null ? thatDecl == null : this.genericDeclaration.equals(thatDecl)) && (this.name == null ? thatName == null : this.name.equals(thatName));
        }
        return false;
    }

    public int hashCode() {
        return this.genericDeclaration.hashCode() ^ this.name.hashCode();
    }
}

