/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.util.Arrays;

final class Helpers {
    private Helpers() {
        throw new Error("This is a non instantiable class");
    }

    static boolean within(float x, float y, float err) {
        float d = y - x;
        return d <= err && d >= -err;
    }

    static boolean within(double x, double y, double err) {
        double d = y - x;
        return d <= err && d >= -err;
    }

    static int quadraticRoots(float a, float b, float c, float[] zeroes, int off) {
        int ret = off;
        if (a != 0.0f) {
            float dis = b * b - 4.0f * a * c;
            if (dis > 0.0f) {
                float sqrtDis = (float)Math.sqrt(dis);
                if (b >= 0.0f) {
                    zeroes[ret++] = 2.0f * c / (-b - sqrtDis);
                    zeroes[ret++] = (-b - sqrtDis) / (2.0f * a);
                } else {
                    zeroes[ret++] = (-b + sqrtDis) / (2.0f * a);
                    zeroes[ret++] = 2.0f * c / (-b + sqrtDis);
                }
            } else if (dis == 0.0f) {
                float t = -b / (2.0f * a);
                zeroes[ret++] = t;
            }
        } else if (b != 0.0f) {
            float t = -c / b;
            zeroes[ret++] = t;
        }
        return ret - off;
    }

    static int cubicRootsInAB(float d, float a, float b, float c, float[] pts, int off, float A, float B) {
        int num;
        double p;
        double cb_p;
        double sq_A;
        double q;
        double D;
        if (d == 0.0f) {
            int num2 = Helpers.quadraticRoots(a, b, c, pts, off);
            return Helpers.filterOutNotInAB(pts, off, num2, A, B) - off;
        }
        if ((D = (q = 0.5 * (0.07407407407407407 * (double)(a /= d) * (sq_A = (double)(a * a)) - 0.3333333333333333 * (double)a * (double)(b /= d) + (double)(c /= d))) * q + (cb_p = (p = 0.3333333333333333 * (-0.3333333333333333 * sq_A + (double)b)) * p * p)) < 0.0) {
            double phi = 0.3333333333333333 * Math.acos(-q / Math.sqrt(-cb_p));
            double t = 2.0 * Math.sqrt(-p);
            pts[off + 0] = (float)(t * Math.cos(phi));
            pts[off + 1] = (float)(-t * Math.cos(phi + 1.0471975511965976));
            pts[off + 2] = (float)(-t * Math.cos(phi - 1.0471975511965976));
            num = 3;
        } else {
            double sqrt_D = Math.sqrt(D);
            double u = Math.cbrt(sqrt_D - q);
            double v = -Math.cbrt(sqrt_D + q);
            pts[off] = (float)(u + v);
            num = 1;
            if (Helpers.within(D, 0.0, 1.0E-8)) {
                pts[off + 1] = -(pts[off] / 2.0f);
                num = 2;
            }
        }
        float sub = 0.33333334f * a;
        for (int i = 0; i < num; ++i) {
            int n = off + i;
            pts[n] = pts[n] - sub;
        }
        return Helpers.filterOutNotInAB(pts, off, num, A, B) - off;
    }

    static float[] widenArray(float[] in, int cursize, int numToAdd) {
        if (in.length >= cursize + numToAdd) {
            return in;
        }
        return Arrays.copyOf(in, 2 * (cursize + numToAdd));
    }

    static int[] widenArray(int[] in, int cursize, int numToAdd) {
        if (in.length >= cursize + numToAdd) {
            return in;
        }
        return Arrays.copyOf(in, 2 * (cursize + numToAdd));
    }

    static float evalCubic(float a, float b, float c, float d, float t) {
        return t * (t * (t * a + b) + c) + d;
    }

    static float evalQuad(float a, float b, float c, float t) {
        return t * (t * a + b) + c;
    }

    static int filterOutNotInAB(float[] nums, int off, int len, float a, float b) {
        int ret = off;
        for (int i = off; i < off + len; ++i) {
            if (!(nums[i] >= a) || !(nums[i] < b)) continue;
            nums[ret++] = nums[i];
        }
        return ret;
    }

    static float polyLineLength(float[] poly, int off, int nCoords) {
        assert (nCoords % 2 == 0 && poly.length >= off + nCoords) : "";
        float acc = 0.0f;
        for (int i = off + 2; i < off + nCoords; i += 2) {
            acc += Helpers.linelen(poly[i], poly[i + 1], poly[i - 2], poly[i - 1]);
        }
        return acc;
    }

    static float linelen(float x1, float y1, float x2, float y2) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    static void subdivide(float[] src, int srcoff, float[] left, int leftoff, float[] right, int rightoff, int type) {
        switch (type) {
            case 6: {
                Helpers.subdivideQuad(src, srcoff, left, leftoff, right, rightoff);
                break;
            }
            case 8: {
                Helpers.subdivideCubic(src, srcoff, left, leftoff, right, rightoff);
                break;
            }
            default: {
                throw new InternalError("Unsupported curve type");
            }
        }
    }

    static void isort(float[] a, int off, int len) {
        for (int i = off + 1; i < off + len; ++i) {
            float ai = a[i];
            for (int j = i - 1; j >= off && a[j] > ai; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = ai;
        }
    }

    static void subdivideCubic(float[] src, int srcoff, float[] left, int leftoff, float[] right, int rightoff) {
        float x1 = src[srcoff + 0];
        float y1 = src[srcoff + 1];
        float ctrlx1 = src[srcoff + 2];
        float ctrly1 = src[srcoff + 3];
        float ctrlx2 = src[srcoff + 4];
        float ctrly2 = src[srcoff + 5];
        float x2 = src[srcoff + 6];
        float y2 = src[srcoff + 7];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 6] = x2;
            right[rightoff + 7] = y2;
        }
        x1 = (x1 + ctrlx1) / 2.0f;
        y1 = (y1 + ctrly1) / 2.0f;
        x2 = (x2 + ctrlx2) / 2.0f;
        y2 = (y2 + ctrly2) / 2.0f;
        float centerx = (ctrlx1 + ctrlx2) / 2.0f;
        float centery = (ctrly1 + ctrly2) / 2.0f;
        ctrlx1 = (x1 + centerx) / 2.0f;
        ctrly1 = (y1 + centery) / 2.0f;
        ctrlx2 = (x2 + centerx) / 2.0f;
        ctrly2 = (y2 + centery) / 2.0f;
        centerx = (ctrlx1 + ctrlx2) / 2.0f;
        centery = (ctrly1 + ctrly2) / 2.0f;
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx1;
            left[leftoff + 5] = ctrly1;
            left[leftoff + 6] = centerx;
            left[leftoff + 7] = centery;
        }
        if (right != null) {
            right[rightoff + 0] = centerx;
            right[rightoff + 1] = centery;
            right[rightoff + 2] = ctrlx2;
            right[rightoff + 3] = ctrly2;
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
    }

    static void subdivideCubicAt(float t, float[] src, int srcoff, float[] left, int leftoff, float[] right, int rightoff) {
        float x1 = src[srcoff + 0];
        float y1 = src[srcoff + 1];
        float ctrlx1 = src[srcoff + 2];
        float ctrly1 = src[srcoff + 3];
        float ctrlx2 = src[srcoff + 4];
        float ctrly2 = src[srcoff + 5];
        float x2 = src[srcoff + 6];
        float y2 = src[srcoff + 7];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 6] = x2;
            right[rightoff + 7] = y2;
        }
        x1 += t * (ctrlx1 - x1);
        y1 += t * (ctrly1 - y1);
        x2 = ctrlx2 + t * (x2 - ctrlx2);
        y2 = ctrly2 + t * (y2 - ctrly2);
        float centerx = ctrlx1 + t * (ctrlx2 - ctrlx1);
        float centery = ctrly1 + t * (ctrly2 - ctrly1);
        ctrlx1 = x1 + t * (centerx - x1);
        ctrly1 = y1 + t * (centery - y1);
        ctrlx2 = centerx + t * (x2 - centerx);
        ctrly2 = centery + t * (y2 - centery);
        centerx = ctrlx1 + t * (ctrlx2 - ctrlx1);
        centery = ctrly1 + t * (ctrly2 - ctrly1);
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx1;
            left[leftoff + 5] = ctrly1;
            left[leftoff + 6] = centerx;
            left[leftoff + 7] = centery;
        }
        if (right != null) {
            right[rightoff + 0] = centerx;
            right[rightoff + 1] = centery;
            right[rightoff + 2] = ctrlx2;
            right[rightoff + 3] = ctrly2;
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
    }

    static void subdivideQuad(float[] src, int srcoff, float[] left, int leftoff, float[] right, int rightoff) {
        float x1 = src[srcoff + 0];
        float y1 = src[srcoff + 1];
        float ctrlx = src[srcoff + 2];
        float ctrly = src[srcoff + 3];
        float x2 = src[srcoff + 4];
        float y2 = src[srcoff + 5];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
        x1 = (x1 + ctrlx) / 2.0f;
        y1 = (y1 + ctrly) / 2.0f;
        x2 = (x2 + ctrlx) / 2.0f;
        y2 = (y2 + ctrly) / 2.0f;
        ctrlx = (x1 + x2) / 2.0f;
        ctrly = (y1 + y2) / 2.0f;
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx;
            left[leftoff + 5] = ctrly;
        }
        if (right != null) {
            right[rightoff + 0] = ctrlx;
            right[rightoff + 1] = ctrly;
            right[rightoff + 2] = x2;
            right[rightoff + 3] = y2;
        }
    }

    static void subdivideQuadAt(float t, float[] src, int srcoff, float[] left, int leftoff, float[] right, int rightoff) {
        float x1 = src[srcoff + 0];
        float y1 = src[srcoff + 1];
        float ctrlx = src[srcoff + 2];
        float ctrly = src[srcoff + 3];
        float x2 = src[srcoff + 4];
        float y2 = src[srcoff + 5];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
        x1 += t * (ctrlx - x1);
        y1 += t * (ctrly - y1);
        x2 = ctrlx + t * (x2 - ctrlx);
        y2 = ctrly + t * (y2 - ctrly);
        ctrlx = x1 + t * (x2 - x1);
        ctrly = y1 + t * (y2 - y1);
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx;
            left[leftoff + 5] = ctrly;
        }
        if (right != null) {
            right[rightoff + 0] = ctrlx;
            right[rightoff + 1] = ctrly;
            right[rightoff + 2] = x2;
            right[rightoff + 3] = y2;
        }
    }

    static void subdivideAt(float t, float[] src, int srcoff, float[] left, int leftoff, float[] right, int rightoff, int size) {
        switch (size) {
            case 8: {
                Helpers.subdivideCubicAt(t, src, srcoff, left, leftoff, right, rightoff);
                break;
            }
            case 6: {
                Helpers.subdivideQuadAt(t, src, srcoff, left, leftoff, right, rightoff);
            }
        }
    }
}

