/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jmxremote;

import com.sun.jmx.remote.internal.RMIExporter;
import com.sun.jmx.remote.security.JMXPluggableAuthenticator;
import com.sun.jmx.remote.util.ClassLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.security.KeyStore;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import javax.security.auth.Subject;
import sun.management.Agent;
import sun.management.AgentConfigurationError;
import sun.management.ConnectorAddressLink;
import sun.management.FileSystem;
import sun.management.jmxremote.LocalRMIServerSocketFactory;
import sun.management.jmxremote.SingleEntryRegistry;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;

public final class ConnectorBootstrap {
    private static Registry registry = null;
    private static final ClassLogger log = new ClassLogger(ConnectorBootstrap.class.getPackage().getName(), "ConnectorBootstrap");

    public static void unexportRegistry() {
        try {
            if (registry != null) {
                UnicastRemoteObject.unexportObject(registry, true);
                registry = null;
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public static synchronized JMXConnectorServer initialize() {
        Properties props = Agent.loadManagementProperties();
        if (props == null) {
            return null;
        }
        String portStr = props.getProperty("com.sun.management.jmxremote.port");
        return ConnectorBootstrap.startRemoteConnectorServer(portStr, props);
    }

    public static synchronized JMXConnectorServer initialize(String portStr, Properties props) {
        return ConnectorBootstrap.startRemoteConnectorServer(portStr, props);
    }

    public static synchronized JMXConnectorServer startRemoteConnectorServer(String portStr, Properties props) {
        int port;
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException x) {
            throw new AgentConfigurationError("agent.err.invalid.jmxremote.port", (Throwable)x, portStr);
        }
        if (port < 0) {
            throw new AgentConfigurationError("agent.err.invalid.jmxremote.port", portStr);
        }
        int rmiPort = 0;
        String rmiPortStr = props.getProperty("com.sun.management.jmxremote.rmi.port");
        try {
            if (rmiPortStr != null) {
                rmiPort = Integer.parseInt(rmiPortStr);
            }
        }
        catch (NumberFormatException x) {
            throw new AgentConfigurationError("agent.err.invalid.jmxremote.rmi.port", (Throwable)x, rmiPortStr);
        }
        if (rmiPort < 0) {
            throw new AgentConfigurationError("agent.err.invalid.jmxremote.rmi.port", rmiPortStr);
        }
        String useAuthenticationStr = props.getProperty("com.sun.management.jmxremote.authenticate", "true");
        boolean useAuthentication = Boolean.valueOf(useAuthenticationStr);
        String useSslStr = props.getProperty("com.sun.management.jmxremote.ssl", "true");
        boolean useSsl = Boolean.valueOf(useSslStr);
        String useRegistrySslStr = props.getProperty("com.sun.management.jmxremote.registry.ssl", "false");
        boolean useRegistrySsl = Boolean.valueOf(useRegistrySslStr);
        String enabledCipherSuites = props.getProperty("com.sun.management.jmxremote.ssl.enabled.cipher.suites");
        String[] enabledCipherSuitesList = null;
        if (enabledCipherSuites != null) {
            StringTokenizer st = new StringTokenizer(enabledCipherSuites, ",");
            int tokens = st.countTokens();
            enabledCipherSuitesList = new String[tokens];
            for (int i = 0; i < tokens; ++i) {
                enabledCipherSuitesList[i] = st.nextToken();
            }
        }
        String enabledProtocols = props.getProperty("com.sun.management.jmxremote.ssl.enabled.protocols");
        String[] enabledProtocolsList = null;
        if (enabledProtocols != null) {
            StringTokenizer st = new StringTokenizer(enabledProtocols, ",");
            int tokens = st.countTokens();
            enabledProtocolsList = new String[tokens];
            for (int i = 0; i < tokens; ++i) {
                enabledProtocolsList[i] = st.nextToken();
            }
        }
        String sslNeedClientAuthStr = props.getProperty("com.sun.management.jmxremote.ssl.need.client.auth", "false");
        boolean sslNeedClientAuth = Boolean.valueOf(sslNeedClientAuthStr);
        String sslConfigFileName = props.getProperty("com.sun.management.jmxremote.ssl.config.file");
        String loginConfigName = null;
        String passwordFileName = null;
        String accessFileName = null;
        if (useAuthentication) {
            loginConfigName = props.getProperty("com.sun.management.jmxremote.login.config");
            if (loginConfigName == null) {
                passwordFileName = props.getProperty("com.sun.management.jmxremote.password.file", ConnectorBootstrap.getDefaultFileName("jmxremote.password"));
                ConnectorBootstrap.checkPasswordFile(passwordFileName);
            }
            accessFileName = props.getProperty("com.sun.management.jmxremote.access.file", ConnectorBootstrap.getDefaultFileName("jmxremote.access"));
            ConnectorBootstrap.checkAccessFile(accessFileName);
        }
        String bindAddress = props.getProperty("com.sun.management.jmxremote.host");
        if (log.debugOn()) {
            log.debug("startRemoteConnectorServer", Agent.getText("jmxremote.ConnectorBootstrap.starting") + "\n\t" + "com.sun.management.jmxremote.port" + "=" + port + (bindAddress == null ? "" : "\n\tcom.sun.management.jmxremote.host=" + bindAddress) + "\n\t" + "com.sun.management.jmxremote.rmi.port" + "=" + rmiPort + "\n\t" + "com.sun.management.jmxremote.ssl" + "=" + useSsl + "\n\t" + "com.sun.management.jmxremote.registry.ssl" + "=" + useRegistrySsl + "\n\t" + "com.sun.management.jmxremote.ssl.config.file" + "=" + sslConfigFileName + "\n\t" + "com.sun.management.jmxremote.ssl.enabled.cipher.suites" + "=" + enabledCipherSuites + "\n\t" + "com.sun.management.jmxremote.ssl.enabled.protocols" + "=" + enabledProtocols + "\n\t" + "com.sun.management.jmxremote.ssl.need.client.auth" + "=" + sslNeedClientAuth + "\n\t" + "com.sun.management.jmxremote.authenticate" + "=" + useAuthentication + (useAuthentication ? (loginConfigName == null ? "\n\tcom.sun.management.jmxremote.password.file=" + passwordFileName : "\n\tcom.sun.management.jmxremote.login.config=" + loginConfigName) : "\n\t" + Agent.getText("jmxremote.ConnectorBootstrap.noAuthentication")) + (useAuthentication ? "\n\tcom.sun.management.jmxremote.access.file=" + accessFileName : "") + "");
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        JMXConnectorServer cs = null;
        JMXServiceURL url = null;
        try {
            JMXConnectorServerData data = ConnectorBootstrap.exportMBeanServer(mbs, port, rmiPort, useSsl, useRegistrySsl, sslConfigFileName, enabledCipherSuitesList, enabledProtocolsList, sslNeedClientAuth, useAuthentication, loginConfigName, passwordFileName, accessFileName, bindAddress);
            cs = data.jmxConnectorServer;
            url = data.jmxRemoteURL;
            log.config("startRemoteConnectorServer", Agent.getText("jmxremote.ConnectorBootstrap.ready", url.toString()));
        }
        catch (Exception e) {
            throw new AgentConfigurationError("agent.err.exception", (Throwable)e, e.toString());
        }
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("remoteAddress", url.toString());
            properties.put("authenticate", useAuthenticationStr);
            properties.put("ssl", useSslStr);
            properties.put("sslRegistry", useRegistrySslStr);
            properties.put("sslNeedClientAuth", sslNeedClientAuthStr);
            ConnectorAddressLink.exportRemote(properties);
        }
        catch (Exception e) {
            log.debug("startRemoteConnectorServer", e);
        }
        return cs;
    }

    public static JMXConnectorServer startLocalConnectorServer() {
        System.setProperty("java.rmi.server.randomIDs", "true");
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("com.sun.jmx.remote.rmi.exporter", new PermanentExporter());
        env.put("jmx.remote.rmi.server.credential.types", new String[]{String[].class.getName(), String.class.getName()});
        String localhost = "localhost";
        InetAddress lh = null;
        try {
            lh = InetAddress.getByName(localhost);
            localhost = lh.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (lh == null || !lh.isLoopbackAddress()) {
            localhost = "127.0.0.1";
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            String useLocalOnlyStr;
            boolean useLocalOnly;
            JMXServiceURL url = new JMXServiceURL("rmi", localhost, 0);
            Properties props = Agent.getManagementProperties();
            if (props == null) {
                props = new Properties();
            }
            if (useLocalOnly = Boolean.valueOf(useLocalOnlyStr = props.getProperty("com.sun.management.jmxremote.local.only", "true")).booleanValue()) {
                env.put("jmx.remote.rmi.server.socket.factory", new LocalRMIServerSocketFactory());
            }
            JMXConnectorServer server = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
            server.start();
            return server;
        }
        catch (Exception e) {
            throw new AgentConfigurationError("agent.err.exception", (Throwable)e, e.toString());
        }
    }

    private static void checkPasswordFile(String passwordFileName) {
        if (passwordFileName == null || passwordFileName.length() == 0) {
            throw new AgentConfigurationError("agent.err.password.file.notset");
        }
        File file = new File(passwordFileName);
        if (!file.exists()) {
            throw new AgentConfigurationError("agent.err.password.file.notfound", passwordFileName);
        }
        if (!file.canRead()) {
            throw new AgentConfigurationError("agent.err.password.file.not.readable", passwordFileName);
        }
        FileSystem fs = FileSystem.open();
        try {
            if (fs.supportsFileSecurity(file) && !fs.isAccessUserOnly(file)) {
                String msg = Agent.getText("jmxremote.ConnectorBootstrap.password.readonly", passwordFileName);
                log.config("startRemoteConnectorServer", msg);
                throw new AgentConfigurationError("agent.err.password.file.access.notrestricted", passwordFileName);
            }
        }
        catch (IOException e) {
            throw new AgentConfigurationError("agent.err.password.file.read.failed", (Throwable)e, passwordFileName);
        }
    }

    private static void checkAccessFile(String accessFileName) {
        if (accessFileName == null || accessFileName.length() == 0) {
            throw new AgentConfigurationError("agent.err.access.file.notset");
        }
        File file = new File(accessFileName);
        if (!file.exists()) {
            throw new AgentConfigurationError("agent.err.access.file.notfound", accessFileName);
        }
        if (!file.canRead()) {
            throw new AgentConfigurationError("agent.err.access.file.not.readable", accessFileName);
        }
    }

    private static void checkRestrictedFile(String restrictedFileName) {
        if (restrictedFileName == null || restrictedFileName.length() == 0) {
            throw new AgentConfigurationError("agent.err.file.not.set");
        }
        File file = new File(restrictedFileName);
        if (!file.exists()) {
            throw new AgentConfigurationError("agent.err.file.not.found", restrictedFileName);
        }
        if (!file.canRead()) {
            throw new AgentConfigurationError("agent.err.file.not.readable", restrictedFileName);
        }
        FileSystem fs = FileSystem.open();
        try {
            if (fs.supportsFileSecurity(file) && !fs.isAccessUserOnly(file)) {
                String msg = Agent.getText("jmxremote.ConnectorBootstrap.file.readonly", restrictedFileName);
                log.config("startRemoteConnectorServer", msg);
                throw new AgentConfigurationError("agent.err.file.access.not.restricted", restrictedFileName);
            }
        }
        catch (IOException e) {
            throw new AgentConfigurationError("agent.err.file.read.failed", (Throwable)e, restrictedFileName);
        }
    }

    private static String getDefaultFileName(String basename) {
        String fileSeparator = File.separator;
        return System.getProperty("java.home") + fileSeparator + "lib" + fileSeparator + "management" + fileSeparator + basename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SslRMIServerSocketFactory createSslRMIServerSocketFactory(String sslConfigFileName, String[] enabledCipherSuites, String[] enabledProtocols, boolean sslNeedClientAuth, String bindAddress) {
        if (sslConfigFileName == null) {
            return new HostAwareSslSocketFactory(enabledCipherSuites, enabledProtocols, sslNeedClientAuth, bindAddress);
        }
        ConnectorBootstrap.checkRestrictedFile(sslConfigFileName);
        try {
            Properties p = new Properties();
            try (FileInputStream in = new FileInputStream(sslConfigFileName);){
                BufferedInputStream bin = new BufferedInputStream(in);
                p.load(bin);
            }
            String keyStore = p.getProperty("javax.net.ssl.keyStore");
            String keyStorePassword = p.getProperty("javax.net.ssl.keyStorePassword", "");
            String trustStore = p.getProperty("javax.net.ssl.trustStore");
            String trustStorePassword = p.getProperty("javax.net.ssl.trustStorePassword", "");
            char[] keyStorePasswd = null;
            if (keyStorePassword.length() != 0) {
                keyStorePasswd = keyStorePassword.toCharArray();
            }
            char[] trustStorePasswd = null;
            if (trustStorePassword.length() != 0) {
                trustStorePasswd = trustStorePassword.toCharArray();
            }
            KeyStore ks = null;
            if (keyStore != null) {
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                try (FileInputStream ksfis = new FileInputStream(keyStore);){
                    ks.load(ksfis, keyStorePasswd);
                }
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keyStorePasswd);
            KeyStore ts = null;
            if (trustStore != null) {
                ts = KeyStore.getInstance(KeyStore.getDefaultType());
                try (FileInputStream tsfis = new FileInputStream(trustStore);){
                    ts.load(tsfis, trustStorePasswd);
                }
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return new HostAwareSslSocketFactory(ctx, enabledCipherSuites, enabledProtocols, sslNeedClientAuth, bindAddress);
        }
        catch (Exception e) {
            throw new AgentConfigurationError("agent.err.exception", (Throwable)e, e.toString());
        }
    }

    private static JMXConnectorServerData exportMBeanServer(MBeanServer mbs, int port, int rmiPort, boolean useSsl, boolean useRegistrySsl, String sslConfigFileName, String[] enabledCipherSuites, String[] enabledProtocols, boolean sslNeedClientAuth, boolean useAuthentication, String loginConfigName, String passwordFileName, String accessFileName, String bindAddress) throws IOException, MalformedURLException {
        boolean useSocketFactory;
        System.setProperty("java.rmi.server.randomIDs", "true");
        JMXServiceURL url = new JMXServiceURL("rmi", bindAddress, rmiPort);
        HashMap<String, Object> env = new HashMap<String, Object>();
        PermanentExporter exporter = new PermanentExporter();
        env.put("com.sun.jmx.remote.rmi.exporter", exporter);
        env.put("jmx.remote.rmi.server.credential.types", new String[]{String[].class.getName(), String.class.getName()});
        boolean bl = useSocketFactory = bindAddress != null && !useSsl;
        if (useAuthentication) {
            if (loginConfigName != null) {
                env.put("jmx.remote.x.login.config", loginConfigName);
            }
            if (passwordFileName != null) {
                env.put("jmx.remote.x.password.file", passwordFileName);
            }
            env.put("jmx.remote.x.access.file", accessFileName);
            if (env.get("jmx.remote.x.password.file") != null || env.get("jmx.remote.x.login.config") != null) {
                env.put("jmx.remote.authenticator", new AccessFileCheckerAuthenticator(env));
            }
        }
        SslRMIClientSocketFactory csf = null;
        RMIServerSocketFactory ssf = null;
        if (useSsl || useRegistrySsl) {
            csf = new SslRMIClientSocketFactory();
            ssf = ConnectorBootstrap.createSslRMIServerSocketFactory(sslConfigFileName, enabledCipherSuites, enabledProtocols, sslNeedClientAuth, bindAddress);
        }
        if (useSsl) {
            env.put("jmx.remote.rmi.client.socket.factory", csf);
            env.put("jmx.remote.rmi.server.socket.factory", ssf);
        }
        if (useSocketFactory) {
            ssf = new HostAwareSocketFactory(bindAddress);
            env.put("jmx.remote.rmi.server.socket.factory", ssf);
        }
        JMXConnectorServer connServer = null;
        try {
            connServer = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
            connServer.start();
        }
        catch (IOException e) {
            if (connServer == null || connServer.getAddress() == null) {
                throw new AgentConfigurationError("agent.err.connector.server.io.error", (Throwable)e, url.toString());
            }
            throw new AgentConfigurationError("agent.err.connector.server.io.error", (Throwable)e, connServer.getAddress().toString());
        }
        registry = useRegistrySsl ? new SingleEntryRegistry(port, csf, ssf, "jmxrmi", exporter.firstExported) : (useSocketFactory ? new SingleEntryRegistry(port, csf, ssf, "jmxrmi", exporter.firstExported) : new SingleEntryRegistry(port, "jmxrmi", exporter.firstExported));
        int registryPort = ((UnicastRef)((RemoteObject)((Object)registry)).getRef()).getLiveRef().getPort();
        String jmxUrlStr = String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", url.getHost(), registryPort);
        JMXServiceURL remoteURL = new JMXServiceURL(jmxUrlStr);
        return new JMXConnectorServerData(connServer, remoteURL);
    }

    private ConnectorBootstrap() {
    }

    private static class SslServerSocket
    extends ServerSocket {
        private static SSLSocketFactory defaultSSLSocketFactory;
        private final String[] enabledCipherSuites;
        private final String[] enabledProtocols;
        private final boolean needClientAuth;
        private final SSLContext context;

        private SslServerSocket(int port, SSLContext ctx, String[] enabledCipherSuites, String[] enabledProtocols, boolean needClientAuth) throws IOException {
            super(port);
            this.enabledProtocols = enabledProtocols;
            this.enabledCipherSuites = enabledCipherSuites;
            this.needClientAuth = needClientAuth;
            this.context = ctx;
        }

        private SslServerSocket(int port, int backlog, InetAddress bindAddr, SSLContext ctx, String[] enabledCipherSuites, String[] enabledProtocols, boolean needClientAuth) throws IOException {
            super(port, backlog, bindAddr);
            this.enabledProtocols = enabledProtocols;
            this.enabledCipherSuites = enabledCipherSuites;
            this.needClientAuth = needClientAuth;
            this.context = ctx;
        }

        @Override
        public Socket accept() throws IOException {
            SSLSocketFactory sslSocketFactory = this.context == null ? SslServerSocket.getDefaultSSLSocketFactory() : this.context.getSocketFactory();
            Socket socket = super.accept();
            SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
            sslSocket.setUseClientMode(false);
            if (this.enabledCipherSuites != null) {
                sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            if (this.enabledProtocols != null) {
                sslSocket.setEnabledProtocols(this.enabledProtocols);
            }
            sslSocket.setNeedClientAuth(this.needClientAuth);
            return sslSocket;
        }

        private static synchronized SSLSocketFactory getDefaultSSLSocketFactory() {
            if (defaultSSLSocketFactory == null) {
                defaultSSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                return defaultSSLSocketFactory;
            }
            return defaultSSLSocketFactory;
        }
    }

    private static class HostAwareSslSocketFactory
    extends SslRMIServerSocketFactory {
        private final String bindAddress;
        private final String[] enabledCipherSuites;
        private final String[] enabledProtocols;
        private final boolean needClientAuth;
        private final SSLContext context;

        private HostAwareSslSocketFactory(String[] enabledCipherSuites, String[] enabledProtocols, boolean sslNeedClientAuth, String bindAddress) throws IllegalArgumentException {
            this(null, enabledCipherSuites, enabledProtocols, sslNeedClientAuth, bindAddress);
        }

        private HostAwareSslSocketFactory(SSLContext ctx, String[] enabledCipherSuites, String[] enabledProtocols, boolean sslNeedClientAuth, String bindAddress) throws IllegalArgumentException {
            this.context = ctx;
            this.bindAddress = bindAddress;
            this.enabledProtocols = enabledProtocols;
            this.enabledCipherSuites = enabledCipherSuites;
            this.needClientAuth = sslNeedClientAuth;
            HostAwareSslSocketFactory.checkValues(ctx, enabledCipherSuites, enabledProtocols);
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            if (this.bindAddress != null) {
                try {
                    InetAddress addr = InetAddress.getByName(this.bindAddress);
                    return new SslServerSocket(port, 0, addr, this.context, this.enabledCipherSuites, this.enabledProtocols, this.needClientAuth);
                }
                catch (UnknownHostException e) {
                    return new SslServerSocket(port, this.context, this.enabledCipherSuites, this.enabledProtocols, this.needClientAuth);
                }
            }
            return new SslServerSocket(port, this.context, this.enabledCipherSuites, this.enabledProtocols, this.needClientAuth);
        }

        private static void checkValues(SSLContext context, String[] enabledCipherSuites, String[] enabledProtocols) throws IllegalArgumentException {
            SSLSocketFactory sslSocketFactory = context == null ? (SSLSocketFactory)SSLSocketFactory.getDefault() : context.getSocketFactory();
            SSLSocket sslSocket = null;
            if (enabledCipherSuites != null || enabledProtocols != null) {
                try {
                    sslSocket = (SSLSocket)sslSocketFactory.createSocket();
                }
                catch (Exception e) {
                    String msg = "Unable to check if the cipher suites and protocols to enable are supported";
                    throw (IllegalArgumentException)new IllegalArgumentException("Unable to check if the cipher suites and protocols to enable are supported").initCause(e);
                }
            }
            if (enabledCipherSuites != null) {
                sslSocket.setEnabledCipherSuites(enabledCipherSuites);
            }
            if (enabledProtocols != null) {
                sslSocket.setEnabledProtocols(enabledProtocols);
            }
        }
    }

    private static class HostAwareSocketFactory
    implements RMIServerSocketFactory {
        private final String bindAddress;

        private HostAwareSocketFactory(String bindAddress) {
            this.bindAddress = bindAddress;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            if (this.bindAddress == null) {
                return new ServerSocket(port);
            }
            try {
                InetAddress addr = InetAddress.getByName(this.bindAddress);
                return new ServerSocket(port, 0, addr);
            }
            catch (UnknownHostException e) {
                return new ServerSocket(port);
            }
        }
    }

    private static class AccessFileCheckerAuthenticator
    implements JMXAuthenticator {
        private final Map<String, Object> environment;
        private final Properties properties;
        private final String accessFile;

        public AccessFileCheckerAuthenticator(Map<String, Object> env) throws IOException {
            this.environment = env;
            this.accessFile = (String)env.get("jmx.remote.x.access.file");
            this.properties = AccessFileCheckerAuthenticator.propertiesFromFile(this.accessFile);
        }

        @Override
        public Subject authenticate(Object credentials) {
            JMXPluggableAuthenticator authenticator = new JMXPluggableAuthenticator(this.environment);
            Subject subject = authenticator.authenticate(credentials);
            this.checkAccessFileEntries(subject);
            return subject;
        }

        private void checkAccessFileEntries(Subject subject) {
            if (subject == null) {
                throw new SecurityException("Access denied! No matching entries found in the access file [" + this.accessFile + "] as the " + "authenticated Subject is null");
            }
            Set<Principal> principals = subject.getPrincipals();
            for (Principal p : principals) {
                if (!this.properties.containsKey(p.getName())) continue;
                return;
            }
            HashSet<String> principalsStr = new HashSet<String>();
            for (Principal p : principals) {
                principalsStr.add(p.getName());
            }
            throw new SecurityException("Access denied! No entries found in the access file [" + this.accessFile + "] for any of the authenticated identities " + principalsStr);
        }

        private static Properties propertiesFromFile(String fname) throws IOException {
            Properties p = new Properties();
            if (fname == null) {
                return p;
            }
            FileInputStream fin = new FileInputStream(fname);
            p.load(fin);
            fin.close();
            return p;
        }
    }

    private static class PermanentExporter
    implements RMIExporter {
        Remote firstExported;

        private PermanentExporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Remote exportObject(Remote obj, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
            PermanentExporter permanentExporter = this;
            synchronized (permanentExporter) {
                if (this.firstExported == null) {
                    this.firstExported = obj;
                }
            }
            UnicastServerRef ref = csf == null && ssf == null ? new UnicastServerRef(port) : new UnicastServerRef2(port, csf, ssf);
            return ref.exportObject(obj, null, true);
        }

        @Override
        public boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
            return UnicastRemoteObject.unexportObject(obj, force);
        }
    }

    private static class JMXConnectorServerData {
        JMXConnectorServer jmxConnectorServer;
        JMXServiceURL jmxRemoteURL;

        public JMXConnectorServerData(JMXConnectorServer jmxConnectorServer, JMXServiceURL jmxRemoteURL) {
            this.jmxConnectorServer = jmxConnectorServer;
            this.jmxRemoteURL = jmxRemoteURL;
        }
    }

    public static interface PropertyNames {
        public static final String PORT = "com.sun.management.jmxremote.port";
        public static final String HOST = "com.sun.management.jmxremote.host";
        public static final String RMI_PORT = "com.sun.management.jmxremote.rmi.port";
        public static final String CONFIG_FILE_NAME = "com.sun.management.config.file";
        public static final String USE_LOCAL_ONLY = "com.sun.management.jmxremote.local.only";
        public static final String USE_SSL = "com.sun.management.jmxremote.ssl";
        public static final String USE_REGISTRY_SSL = "com.sun.management.jmxremote.registry.ssl";
        public static final String USE_AUTHENTICATION = "com.sun.management.jmxremote.authenticate";
        public static final String PASSWORD_FILE_NAME = "com.sun.management.jmxremote.password.file";
        public static final String ACCESS_FILE_NAME = "com.sun.management.jmxremote.access.file";
        public static final String LOGIN_CONFIG_NAME = "com.sun.management.jmxremote.login.config";
        public static final String SSL_ENABLED_CIPHER_SUITES = "com.sun.management.jmxremote.ssl.enabled.cipher.suites";
        public static final String SSL_ENABLED_PROTOCOLS = "com.sun.management.jmxremote.ssl.enabled.protocols";
        public static final String SSL_NEED_CLIENT_AUTH = "com.sun.management.jmxremote.ssl.need.client.auth";
        public static final String SSL_CONFIG_FILE_NAME = "com.sun.management.jmxremote.ssl.config.file";
    }

    public static interface DefaultValues {
        public static final String PORT = "0";
        public static final String CONFIG_FILE_NAME = "management.properties";
        public static final String USE_SSL = "true";
        public static final String USE_LOCAL_ONLY = "true";
        public static final String USE_REGISTRY_SSL = "false";
        public static final String USE_AUTHENTICATION = "true";
        public static final String PASSWORD_FILE_NAME = "jmxremote.password";
        public static final String ACCESS_FILE_NAME = "jmxremote.access";
        public static final String SSL_NEED_CLIENT_AUTH = "false";
    }
}

