/*
 * Decompiled with CFR 0.152.
 */
package sun.security.spec;

import java.security.spec.AlgorithmParameterSpec;

public final class DSAGenParameterSpec
implements AlgorithmParameterSpec {
    private final int pLen;
    private final int qLen;
    private final int seedLen;

    public DSAGenParameterSpec(int primePLen, int subprimeQLen) {
        this(primePLen, subprimeQLen, subprimeQLen);
    }

    public DSAGenParameterSpec(int primePLen, int subprimeQLen, int seedLen) {
        switch (primePLen) {
            case 1024: {
                if (subprimeQLen == 160) break;
                throw new IllegalArgumentException("subprimeQLen must be 160 when primePLen=1024");
            }
            case 2048: {
                if (subprimeQLen == 224 || subprimeQLen == 256) break;
                throw new IllegalArgumentException("subprimeQLen must be 224 or 256 when primePLen=2048");
            }
            case 3072: {
                if (subprimeQLen == 256) break;
                throw new IllegalArgumentException("subprimeQLen must be 256 when primePLen=3072");
            }
            default: {
                throw new IllegalArgumentException("primePLen must be 1024, 2048, or 3072");
            }
        }
        if (seedLen < subprimeQLen) {
            throw new IllegalArgumentException("seedLen must be equal to or greater than subprimeQLen");
        }
        this.pLen = primePLen;
        this.qLen = subprimeQLen;
        this.seedLen = seedLen;
    }

    public int getPrimePLength() {
        return this.pLen;
    }

    public int getSubprimeQLength() {
        return this.qLen;
    }

    public int getSeedLength() {
        return this.seedLen;
    }
}

