/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.anon;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import sun.invoke.anon.ConstantPoolParser;
import sun.invoke.anon.ConstantPoolPatch;
import sun.invoke.anon.InvalidConstantPoolFormatException;
import sun.misc.IOUtils;
import sun.misc.Unsafe;

public class AnonymousClassLoader {
    final Class<?> hostClass;
    private static int fakeNameCounter = 99999;
    private static Unsafe unsafe = Unsafe.getUnsafe();
    private static final Method defineAnonymousClass;

    private AnonymousClassLoader(Class<?> hostClass) {
        this.hostClass = hostClass;
    }

    public static AnonymousClassLoader make(Unsafe unsafe, Class<?> hostClass) {
        if (unsafe == null) {
            throw new NullPointerException();
        }
        return new AnonymousClassLoader(hostClass);
    }

    public Class<?> loadClass(byte[] classFile) {
        if (defineAnonymousClass == null) {
            try {
                return this.fakeLoadClass(new ConstantPoolParser(classFile).createPatch());
            }
            catch (InvalidConstantPoolFormatException ee) {
                throw new IllegalArgumentException(ee);
            }
        }
        return this.loadClass(classFile, null);
    }

    public Class<?> loadClass(ConstantPoolPatch classPatch) {
        if (defineAnonymousClass == null) {
            return this.fakeLoadClass(classPatch);
        }
        Object[] patches = classPatch.patchArray;
        block3: for (int i = 0; i < patches.length; ++i) {
            Object value = patches[i];
            if (value == null) continue;
            byte tag = classPatch.getTag(i);
            switch (tag) {
                case 7: {
                    if (!(value instanceof String)) continue block3;
                    if (patches == classPatch.patchArray) {
                        patches = (Object[])patches.clone();
                    }
                    patches[i] = ((String)value).replace('.', '/');
                    continue block3;
                }
            }
        }
        return this.loadClass(classPatch.outer.classFile, classPatch.patchArray);
    }

    private Class<?> loadClass(byte[] classFile, Object[] patchArray) {
        try {
            return (Class)defineAnonymousClass.invoke(unsafe, this.hostClass, classFile, patchArray);
        }
        catch (Exception ex) {
            AnonymousClassLoader.throwReflectedException(ex);
            throw new RuntimeException("error loading into " + this.hostClass, ex);
        }
    }

    private static void throwReflectedException(Exception ex) {
        if (ex instanceof InvocationTargetException) {
            Throwable tex = ((InvocationTargetException)ex).getTargetException();
            if (tex instanceof Error) {
                throw (Error)tex;
            }
            ex = (Exception)tex;
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
    }

    private Class<?> fakeLoadClass(ConstantPoolPatch classPatch) {
        throw new UnsupportedOperationException("NYI");
    }

    private static void noJVMSupport() {
        throw new UnsupportedOperationException("no JVM support for anonymous classes");
    }

    private static native Class<?> loadClassInternal(Class<?> var0, byte[] var1, Object[] var2);

    public static byte[] readClassFile(Class<?> templateClass) throws IOException {
        int lastDot;
        String templateName = templateClass.getName();
        URL url = templateClass.getResource(templateName.substring((lastDot = templateName.lastIndexOf(46)) + 1) + ".class");
        URLConnection connection = url.openConnection();
        int contentLength = connection.getContentLength();
        if (contentLength < 0) {
            throw new IOException("invalid content length " + contentLength);
        }
        return IOUtils.readFully(connection.getInputStream(), contentLength, true);
    }

    static {
        Method dac = null;
        Class<?> unsafeClass = unsafe.getClass();
        try {
            dac = unsafeClass.getMethod("defineAnonymousClass", Class.class, byte[].class, Object[].class);
        }
        catch (Exception ee) {
            dac = null;
        }
        defineAnonymousClass = dac;
    }
}

