/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import sun.misc.InnocuousThread;
import sun.security.action.GetPropertyAction;

public class ThreadPool {
    private static final String DEFAULT_THREAD_POOL_THREAD_FACTORY = "java.nio.channels.DefaultThreadPool.threadFactory";
    private static final String DEFAULT_THREAD_POOL_INITIAL_SIZE = "java.nio.channels.DefaultThreadPool.initialSize";
    private final ExecutorService executor;
    private final boolean isFixed;
    private final int poolSize;

    private ThreadPool(ExecutorService executor, boolean isFixed, int poolSize) {
        this.executor = executor;
        this.isFixed = isFixed;
        this.poolSize = poolSize;
    }

    ExecutorService executor() {
        return this.executor;
    }

    boolean isFixedThreadPool() {
        return this.isFixed;
    }

    int poolSize() {
        return this.poolSize;
    }

    static ThreadFactory defaultThreadFactory() {
        if (System.getSecurityManager() == null) {
            return new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setDaemon(true);
                    return t;
                }
            };
        }
        return new ThreadFactory(){

            @Override
            public Thread newThread(final Runnable r) {
                return (Thread)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        InnocuousThread t = new InnocuousThread(r);
                        t.setDaemon(true);
                        return t;
                    }
                });
            }
        };
    }

    static ThreadPool getDefault() {
        return DefaultThreadPoolHolder.defaultThreadPool;
    }

    static ThreadPool createDefault() {
        ThreadFactory threadFactory;
        int initialSize = ThreadPool.getDefaultThreadPoolInitialSize();
        if (initialSize < 0) {
            initialSize = Runtime.getRuntime().availableProcessors();
        }
        if ((threadFactory = ThreadPool.getDefaultThreadPoolThreadFactory()) == null) {
            threadFactory = ThreadPool.defaultThreadFactory();
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        return new ThreadPool(executor, false, initialSize);
    }

    static ThreadPool create(int nThreads, ThreadFactory factory) {
        if (nThreads <= 0) {
            throw new IllegalArgumentException("'nThreads' must be > 0");
        }
        ExecutorService executor = Executors.newFixedThreadPool(nThreads, factory);
        return new ThreadPool(executor, true, nThreads);
    }

    public static ThreadPool wrap(ExecutorService executor, int initialSize) {
        if (executor == null) {
            throw new NullPointerException("'executor' is null");
        }
        if (executor instanceof ThreadPoolExecutor) {
            int max = ((ThreadPoolExecutor)executor).getMaximumPoolSize();
            if (max == Integer.MAX_VALUE) {
                initialSize = initialSize < 0 ? Runtime.getRuntime().availableProcessors() : 0;
            }
        } else if (initialSize < 0) {
            initialSize = 0;
        }
        return new ThreadPool(executor, false, initialSize);
    }

    private static int getDefaultThreadPoolInitialSize() {
        String propValue = AccessController.doPrivileged(new GetPropertyAction(DEFAULT_THREAD_POOL_INITIAL_SIZE));
        if (propValue != null) {
            try {
                return Integer.parseInt(propValue);
            }
            catch (NumberFormatException x) {
                throw new Error("Value of property 'java.nio.channels.DefaultThreadPool.initialSize' is invalid: " + x);
            }
        }
        return -1;
    }

    private static ThreadFactory getDefaultThreadPoolThreadFactory() {
        String propValue = AccessController.doPrivileged(new GetPropertyAction(DEFAULT_THREAD_POOL_THREAD_FACTORY));
        if (propValue != null) {
            try {
                Class<?> c = Class.forName(propValue, true, ClassLoader.getSystemClassLoader());
                return (ThreadFactory)c.newInstance();
            }
            catch (ClassNotFoundException x) {
                throw new Error(x);
            }
            catch (InstantiationException x) {
                throw new Error(x);
            }
            catch (IllegalAccessException x) {
                throw new Error(x);
            }
        }
        return null;
    }

    private static class DefaultThreadPoolHolder {
        static final ThreadPool defaultThreadPool = ThreadPool.createDefault();

        private DefaultThreadPoolHolder() {
        }
    }
}

