/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;

public final class UID
implements Serializable {
    private static int hostUnique;
    private static boolean hostUniqueSet;
    private static final Object lock;
    private static long lastTime;
    private static short lastCount;
    private static final long serialVersionUID = 1086053664494604050L;
    private final int unique;
    private final long time;
    private final short count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UID() {
        Object object = lock;
        synchronized (object) {
            if (!hostUniqueSet) {
                hostUnique = new SecureRandom().nextInt();
                hostUniqueSet = true;
            }
            this.unique = hostUnique;
            if (lastCount == Short.MAX_VALUE) {
                boolean interrupted = Thread.interrupted();
                boolean done = false;
                while (!done) {
                    long now = System.currentTimeMillis();
                    if (now == lastTime) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                        continue;
                    }
                    lastTime = now < lastTime ? lastTime + 1L : now;
                    lastCount = Short.MIN_VALUE;
                    done = true;
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            this.time = lastTime;
            short s = lastCount;
            lastCount = (short)(s + 1);
            this.count = s;
        }
    }

    public UID(short num) {
        this.unique = 0;
        this.time = 0L;
        this.count = num;
    }

    private UID(int unique, long time, short count) {
        this.unique = unique;
        this.time = time;
        this.count = count;
    }

    public int hashCode() {
        return (int)this.time + this.count;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UID) {
            UID uid = (UID)obj;
            return this.unique == uid.unique && this.count == uid.count && this.time == uid.time;
        }
        return false;
    }

    public String toString() {
        return Integer.toString(this.unique, 16) + ":" + Long.toString(this.time, 16) + ":" + Integer.toString(this.count, 16);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.unique);
        out.writeLong(this.time);
        out.writeShort(this.count);
    }

    public static UID read(DataInput in) throws IOException {
        int unique = in.readInt();
        long time = in.readLong();
        short count = in.readShort();
        return new UID(unique, time, count);
    }

    static {
        hostUniqueSet = false;
        lock = new Object();
        lastTime = System.currentTimeMillis();
        lastCount = Short.MIN_VALUE;
    }
}

