/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.blockdevicelib.vmdk;

import com.amazon.aes.webservices.client.blockdevicelib.ImageVerificationException;
import com.amazon.aes.webservices.client.blockdevicelib.vmdk.VMDKConstants;
import java.util.Arrays;
import java.util.List;

public class VMDKDescriptor {
    private final List<String> parsedDescriptor;

    public VMDKDescriptor(byte[] buffer) throws ImageVerificationException {
        String descriptor = new String(buffer).trim();
        this.parsedDescriptor = Arrays.asList(descriptor.split(VMDKConstants.DESCRIPTOR_SEPARATOR));
    }

    private String getValue(String key) throws ImageVerificationException {
        int index = this.parsedDescriptor.indexOf(key);
        if (index == -1) {
            throw new ImageVerificationException("Descriptor does not contain key " + key);
        }
        try {
            return this.parsedDescriptor.get(index + 1).trim();
        }
        catch (IndexOutOfBoundsException e) {
            throw new ImageVerificationException("Descriptor does not contain value of " + key);
        }
    }

    public void validateDescriptor() throws ImageVerificationException {
        String parentCID = this.getValue(VMDKConstants.DESCRIPTOR_PARENTCID);
        String createType = this.getValue(VMDKConstants.DESCRIPTOR_CREATETYPE);
        if (parentCID.indexOf(VMDKConstants.DESCRIPTOR_NOPARENT) == -1) {
            throw new ImageVerificationException("This VMDK file is a child VMDK file, which is not supprted");
        }
        if (createType.indexOf(VMDKConstants.DESCRIPTOR_STREAM_OPTIMIZED) == -1) {
            throw new ImageVerificationException("The VMDK file is of the unsupported type: " + createType);
        }
    }
}

