/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.Callable;
import sun.awt.shell.DefaultShellFolder;
import sun.awt.shell.ShellFolder;

class ShellFolderManager {
    ShellFolderManager() {
    }

    public ShellFolder createShellFolder(File file) throws FileNotFoundException {
        return new DefaultShellFolder(null, file);
    }

    public Object get(String key) {
        if (key.equals("fileChooserDefaultFolder")) {
            File homeDir = new File(System.getProperty("user.home"));
            try {
                return this.createShellFolder(homeDir);
            }
            catch (FileNotFoundException e) {
                return homeDir;
            }
        }
        if (key.equals("roots")) {
            return File.listRoots();
        }
        if (key.equals("fileChooserComboBoxFolders")) {
            return this.get("roots");
        }
        if (key.equals("fileChooserShortcutPanelFolders")) {
            return new File[]{(File)this.get("fileChooserDefaultFolder")};
        }
        return null;
    }

    public boolean isComputerNode(File dir) {
        return false;
    }

    public boolean isFileSystemRoot(File dir) {
        if (dir instanceof ShellFolder && !((ShellFolder)dir).isFileSystem()) {
            return false;
        }
        return dir.getParentFile() == null;
    }

    protected ShellFolder.Invoker createInvoker() {
        return new DirectInvoker();
    }

    private static class DirectInvoker
    implements ShellFolder.Invoker {
        private DirectInvoker() {
        }

        @Override
        public <T> T invoke(Callable<T> task) throws Exception {
            return task.call();
        }
    }
}

