/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Date;
import sun.security.util.DerOutputStream;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.SerialNumber;

class AdaptableX509CertSelector
extends X509CertSelector {
    private Date startDate;
    private Date endDate;
    private boolean isSKIDSensitive = false;
    private boolean isSNSensitive = false;

    AdaptableX509CertSelector() {
    }

    void setValidityPeriod(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    void parseAuthorityKeyIdentifierExtension(AuthorityKeyIdentifierExtension akidext) throws IOException {
        if (akidext != null) {
            SerialNumber asn;
            KeyIdentifier akid = (KeyIdentifier)akidext.get("key_id");
            if (akid != null && (this.isSKIDSensitive || this.getSubjectKeyIdentifier() == null)) {
                DerOutputStream derout = new DerOutputStream();
                derout.putOctetString(akid.getIdentifier());
                super.setSubjectKeyIdentifier(derout.toByteArray());
                this.isSKIDSensitive = true;
            }
            if ((asn = (SerialNumber)akidext.get("serial_number")) != null && (this.isSNSensitive || this.getSerialNumber() == null)) {
                super.setSerialNumber(asn.getNumber());
                this.isSNSensitive = true;
            }
        }
    }

    @Override
    public boolean match(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            return false;
        }
        X509Certificate xcert = (X509Certificate)cert;
        int version = xcert.getVersion();
        if (version < 3) {
            if (this.startDate != null) {
                try {
                    xcert.checkValidity(this.startDate);
                }
                catch (CertificateException ce) {
                    return false;
                }
            }
            if (this.endDate != null) {
                try {
                    xcert.checkValidity(this.endDate);
                }
                catch (CertificateException ce) {
                    return false;
                }
            }
        }
        if (this.isSKIDSensitive && (version < 3 || xcert.getExtensionValue("2.5.29.14") == null)) {
            this.setSubjectKeyIdentifier(null);
        }
        if (this.isSNSensitive && version < 3) {
            this.setSerialNumber(null);
        }
        return super.match(cert);
    }

    @Override
    public Object clone() {
        AdaptableX509CertSelector copy = (AdaptableX509CertSelector)super.clone();
        if (this.startDate != null) {
            copy.startDate = (Date)this.startDate.clone();
        }
        if (this.endDate != null) {
            copy.endDate = (Date)this.endDate.clone();
        }
        return copy;
    }
}

