/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import sun.security.jca.ProviderConfig;
import sun.security.jca.ServiceId;
import sun.security.util.Debug;

public final class ProviderList {
    static final Debug debug = Debug.getInstance("jca", "ProviderList");
    private static final ProviderConfig[] PC0 = new ProviderConfig[0];
    private static final Provider[] P0 = new Provider[0];
    static final ProviderList EMPTY = new ProviderList(PC0, true);
    private static final Provider EMPTY_PROVIDER = new Provider("##Empty##", 1.0, "initialization in progress"){
        private static final long serialVersionUID = 1151354171352296389L;

        @Override
        public Provider.Service getService(String type, String algorithm) {
            return null;
        }
    };
    private final ProviderConfig[] configs;
    private volatile boolean allLoaded;
    private final List<Provider> userList = new AbstractList<Provider>(){

        @Override
        public int size() {
            return ProviderList.this.configs.length;
        }

        @Override
        public Provider get(int index) {
            return ProviderList.this.getProvider(index);
        }
    };

    static ProviderList fromSecurityProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<ProviderList>(){

            @Override
            public ProviderList run() {
                return new ProviderList();
            }
        });
    }

    public static ProviderList add(ProviderList providerList, Provider p) {
        return ProviderList.insertAt(providerList, p, -1);
    }

    public static ProviderList insertAt(ProviderList providerList, Provider p, int position) {
        if (providerList.getProvider(p.getName()) != null) {
            return providerList;
        }
        ArrayList<ProviderConfig> list = new ArrayList<ProviderConfig>(Arrays.asList(providerList.configs));
        int n = list.size();
        if (position < 0 || position > n) {
            position = n;
        }
        list.add(position, new ProviderConfig(p));
        return new ProviderList(list.toArray(PC0), true);
    }

    public static ProviderList remove(ProviderList providerList, String name) {
        if (providerList.getProvider(name) == null) {
            return providerList;
        }
        ProviderConfig[] configs = new ProviderConfig[providerList.size() - 1];
        int j = 0;
        for (ProviderConfig config : providerList.configs) {
            if (config.getProvider().getName().equals(name)) continue;
            configs[j++] = config;
        }
        return new ProviderList(configs, true);
    }

    public static ProviderList newList(Provider ... providers) {
        ProviderConfig[] configs = new ProviderConfig[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            configs[i] = new ProviderConfig(providers[i]);
        }
        return new ProviderList(configs, true);
    }

    private ProviderList(ProviderConfig[] configs, boolean allLoaded) {
        this.configs = configs;
        this.allLoaded = allLoaded;
    }

    private ProviderList() {
        String entry;
        ArrayList<ProviderConfig> configList = new ArrayList<ProviderConfig>();
        int i = 1;
        while ((entry = Security.getProperty("security.provider." + i)) != null) {
            ProviderConfig config;
            if ((entry = entry.trim()).length() == 0) {
                System.err.println("invalid entry for security.provider." + i);
                break;
            }
            int k = entry.indexOf(32);
            if (k == -1) {
                config = new ProviderConfig(entry);
            } else {
                String className = entry.substring(0, k);
                String argument = entry.substring(k + 1).trim();
                config = new ProviderConfig(className, argument);
            }
            if (!configList.contains(config)) {
                configList.add(config);
            }
            ++i;
        }
        this.configs = configList.toArray(PC0);
        if (debug != null) {
            debug.println("provider configuration: " + configList);
        }
    }

    ProviderList getJarList(String[] jarClassNames) {
        ArrayList<ProviderConfig> newConfigs = new ArrayList<ProviderConfig>();
        for (String className : jarClassNames) {
            ProviderConfig newConfig = new ProviderConfig(className);
            for (ProviderConfig config : this.configs) {
                if (!config.equals(newConfig)) continue;
                newConfig = config;
                break;
            }
            newConfigs.add(newConfig);
        }
        ProviderConfig[] configArray = newConfigs.toArray(PC0);
        return new ProviderList(configArray, false);
    }

    public int size() {
        return this.configs.length;
    }

    Provider getProvider(int index) {
        Provider p = this.configs[index].getProvider();
        return p != null ? p : EMPTY_PROVIDER;
    }

    public List<Provider> providers() {
        return this.userList;
    }

    private ProviderConfig getProviderConfig(String name) {
        int index = this.getIndex(name);
        return index != -1 ? this.configs[index] : null;
    }

    public Provider getProvider(String name) {
        ProviderConfig config = this.getProviderConfig(name);
        return config == null ? null : config.getProvider();
    }

    public int getIndex(String name) {
        for (int i = 0; i < this.configs.length; ++i) {
            Provider p = this.getProvider(i);
            if (!p.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private int loadAll() {
        if (this.allLoaded) {
            return this.configs.length;
        }
        if (debug != null) {
            debug.println("Loading all providers");
            new Exception("Call trace").printStackTrace();
        }
        int n = 0;
        for (int i = 0; i < this.configs.length; ++i) {
            Provider p = this.configs[i].getProvider();
            if (p == null) continue;
            ++n;
        }
        if (n == this.configs.length) {
            this.allLoaded = true;
        }
        return n;
    }

    ProviderList removeInvalid() {
        int n = this.loadAll();
        if (n == this.configs.length) {
            return this;
        }
        ProviderConfig[] newConfigs = new ProviderConfig[n];
        int j = 0;
        for (int i = 0; i < this.configs.length; ++i) {
            ProviderConfig config = this.configs[i];
            if (!config.isLoaded()) continue;
            newConfigs[j++] = config;
        }
        return new ProviderList(newConfigs, true);
    }

    public Provider[] toArray() {
        return this.providers().toArray(P0);
    }

    public String toString() {
        return Arrays.asList(this.configs).toString();
    }

    public Provider.Service getService(String type, String name) {
        for (int i = 0; i < this.configs.length; ++i) {
            Provider p = this.getProvider(i);
            Provider.Service s = p.getService(type, name);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public List<Provider.Service> getServices(String type, String algorithm) {
        return new ServiceList(type, algorithm);
    }

    @Deprecated
    public List<Provider.Service> getServices(String type, List<String> algorithms) {
        ArrayList<ServiceId> ids = new ArrayList<ServiceId>();
        for (String alg : algorithms) {
            ids.add(new ServiceId(type, alg));
        }
        return this.getServices(ids);
    }

    public List<Provider.Service> getServices(List<ServiceId> ids) {
        return new ServiceList(ids);
    }

    private final class ServiceList
    extends AbstractList<Provider.Service> {
        private final String type;
        private final String algorithm;
        private final List<ServiceId> ids;
        private Provider.Service firstService;
        private List<Provider.Service> services;
        private int providerIndex;

        ServiceList(String type, String algorithm) {
            this.type = type;
            this.algorithm = algorithm;
            this.ids = null;
        }

        ServiceList(List<ServiceId> ids) {
            this.type = null;
            this.algorithm = null;
            this.ids = ids;
        }

        private void addService(Provider.Service s) {
            if (this.firstService == null) {
                this.firstService = s;
            } else {
                if (this.services == null) {
                    this.services = new ArrayList<Provider.Service>(4);
                    this.services.add(this.firstService);
                }
                this.services.add(s);
            }
        }

        /*
         * Unable to fully structure code
         */
        private Provider.Service tryGet(int index) {
            block0: while (true) {
                if (index == 0 && this.firstService != null) {
                    return this.firstService;
                }
                if (this.services != null && this.services.size() > index) {
                    return this.services.get(index);
                }
                if (this.providerIndex >= ProviderList.access$100(ProviderList.this).length) {
                    return null;
                }
                p = ProviderList.this.getProvider(this.providerIndex++);
                if (this.type != null) {
                    s = p.getService(this.type, this.algorithm);
                    if (s == null) continue;
                    this.addService(s);
                    continue;
                }
                i$ = this.ids.iterator();
                while (true) {
                    if (i$.hasNext()) ** break;
                    continue block0;
                    id = i$.next();
                    s = p.getService(id.type, id.algorithm);
                    if (s == null) continue;
                    this.addService(s);
                }
                break;
            }
        }

        @Override
        public Provider.Service get(int index) {
            Provider.Service s = this.tryGet(index);
            if (s == null) {
                throw new IndexOutOfBoundsException();
            }
            return s;
        }

        @Override
        public int size() {
            int n;
            if (this.services != null) {
                n = this.services.size();
            } else {
                int n2 = n = this.firstService != null ? 1 : 0;
            }
            while (this.tryGet(n) != null) {
                ++n;
            }
            return n;
        }

        @Override
        public boolean isEmpty() {
            return this.tryGet(0) == null;
        }

        @Override
        public Iterator<Provider.Service> iterator() {
            return new Iterator<Provider.Service>(){
                int index;

                @Override
                public boolean hasNext() {
                    return ServiceList.this.tryGet(this.index) != null;
                }

                @Override
                public Provider.Service next() {
                    Provider.Service s = ServiceList.this.tryGet(this.index);
                    if (s == null) {
                        throw new NoSuchElementException();
                    }
                    ++this.index;
                    return s;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

