/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MouseInfo;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.BreakIterator;
import java.util.concurrent.ArrayBlockingQueue;
import sun.awt.SunToolkit;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XTrayIconPeer;
import sun.awt.X11.XWindow;

public abstract class InfoWindow
extends Window {
    private Container container;
    private Closer closer;

    protected InfoWindow(Frame parent, Color borderColor) {
        super(parent);
        this.setType(Window.Type.POPUP);
        this.container = new Container(){

            @Override
            public Insets getInsets() {
                return new Insets(1, 1, 1, 1);
            }
        };
        this.setLayout(new BorderLayout());
        this.setBackground(borderColor);
        this.add((Component)this.container, "Center");
        this.container.setLayout(new BorderLayout());
        this.closer = new Closer();
    }

    @Override
    public Component add(Component c) {
        this.container.add(c, "Center");
        return c;
    }

    protected void setCloser(Runnable action, int time) {
        this.closer.set(action, time);
    }

    protected void show(Point corner, int indent) {
        assert (SunToolkit.isDispatchThreadForAppContext(this));
        this.pack();
        Dimension size = this.getSize();
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (corner.x < scrSize.width / 2 && corner.y < scrSize.height / 2) {
            this.setLocation(corner.x + indent, corner.y + indent);
        } else if (corner.x >= scrSize.width / 2 && corner.y < scrSize.height / 2) {
            this.setLocation(corner.x - indent - size.width, corner.y + indent);
        } else if (corner.x < scrSize.width / 2 && corner.y >= scrSize.height / 2) {
            this.setLocation(corner.x + indent, corner.y - indent - size.height);
        } else if (corner.x >= scrSize.width / 2 && corner.y >= scrSize.height / 2) {
            this.setLocation(corner.x - indent - size.width, corner.y - indent - size.height);
        }
        super.show();
        this.closer.schedule();
    }

    @Override
    public void hide() {
        this.closer.close();
    }

    public static class Balloon
    extends InfoWindow {
        private final LiveArguments liveArguments;
        private final Object target;
        private static final int BALLOON_SHOW_TIME = 10000;
        private static final int BALLOON_TEXT_MAX_LENGTH = 256;
        private static final int BALLOON_WORD_LINE_MAX_LENGTH = 16;
        private static final int BALLOON_WORD_LINE_MAX_COUNT = 4;
        private static final int BALLOON_ICON_WIDTH = 32;
        private static final int BALLOON_ICON_HEIGHT = 32;
        private static final int BALLOON_TRAY_ICON_INDENT = 0;
        private static final Color BALLOON_CAPTION_BACKGROUND_COLOR = new Color(200, 200, 255);
        private static final Font BALLOON_CAPTION_FONT = new Font("Dialog", 1, 12);
        private Panel mainPanel = new Panel();
        private Panel captionPanel = new Panel();
        private Label captionLabel = new Label("");
        private Button closeButton = new Button("X");
        private Panel textPanel = new Panel();
        private XTrayIconPeer.IconCanvas iconCanvas = new XTrayIconPeer.IconCanvas(32, 32);
        private Label[] lineLabels = new Label[4];
        private ActionPerformer ap = new ActionPerformer();
        private Image iconImage;
        private Image errorImage;
        private Image warnImage;
        private Image infoImage;
        private boolean gtkImagesLoaded;
        private Displayer displayer = new Displayer();

        public Balloon(Frame parent, Object target, LiveArguments liveArguments) {
            super(parent, new Color(90, 80, 190));
            this.liveArguments = liveArguments;
            this.target = target;
            XTrayIconPeer.suppressWarningString(this);
            this.setCloser(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (Balloon.this.textPanel != null) {
                        Balloon.this.textPanel.removeAll();
                        Balloon.this.textPanel.setSize(0, 0);
                        Balloon.this.iconCanvas.setSize(0, 0);
                        XToolkit.awtLock();
                        try {
                            ((Balloon)Balloon.this).displayer.isDisplayed = false;
                            XToolkit.awtLockNotifyAll();
                        }
                        finally {
                            XToolkit.awtUnlock();
                        }
                    }
                }
            }, 10000);
            this.add(this.mainPanel);
            this.captionLabel.setFont(BALLOON_CAPTION_FONT);
            this.captionLabel.addMouseListener(this.ap);
            this.captionPanel.setLayout(new BorderLayout());
            this.captionPanel.add((Component)this.captionLabel, "West");
            this.captionPanel.add((Component)this.closeButton, "East");
            this.captionPanel.setBackground(BALLOON_CAPTION_BACKGROUND_COLOR);
            this.captionPanel.addMouseListener(this.ap);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Balloon.this.hide();
                }
            });
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setBackground(Color.white);
            this.mainPanel.add((Component)this.captionPanel, "North");
            this.mainPanel.add((Component)this.iconCanvas, "West");
            this.mainPanel.add((Component)this.textPanel, "Center");
            this.iconCanvas.addMouseListener(this.ap);
            for (int i = 0; i < 4; ++i) {
                this.lineLabels[i] = new Label();
                this.lineLabels[i].addMouseListener(this.ap);
                this.lineLabels[i].setBackground(Color.white);
            }
            this.displayer.start();
        }

        public void display(String caption, String text, String messageType) {
            if (!this.gtkImagesLoaded) {
                this.loadGtkImages();
            }
            this.displayer.display(caption, text, messageType);
        }

        private void _display(String caption, String text, String messageType) {
            this.captionLabel.setText(caption);
            BreakIterator iter = BreakIterator.getWordInstance();
            if (text != null) {
                int end;
                iter.setText(text);
                int start = iter.first();
                int nLines = 0;
                do {
                    if ((end = iter.next()) == -1 || text.substring(start, end).length() >= 50) {
                        this.lineLabels[nLines].setText(text.substring(start, end == -1 ? iter.last() : end));
                        this.textPanel.add(this.lineLabels[nLines++]);
                        start = end;
                    }
                    if (nLines != 4) continue;
                    if (end == -1) break;
                    this.lineLabels[nLines - 1].setText(new String(this.lineLabels[nLines - 1].getText() + " ..."));
                    break;
                } while (end != -1);
                this.textPanel.setLayout(new GridLayout(nLines, 1));
            }
            this.iconImage = "ERROR".equals(messageType) ? this.errorImage : ("WARNING".equals(messageType) ? this.warnImage : ("INFO".equals(messageType) ? this.infoImage : null));
            if (this.iconImage != null) {
                Dimension tpSize = this.textPanel.getSize();
                this.iconCanvas.setSize(32, 32 > tpSize.height ? 32 : tpSize.height);
                this.iconCanvas.validate();
            }
            SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

                @Override
                public void run() {
                    if (Balloon.this.liveArguments.isDisposed()) {
                        return;
                    }
                    Point parLoc = Balloon.this.getParent().getLocationOnScreen();
                    Dimension parSize = Balloon.this.getParent().getSize();
                    Balloon.this.show(new Point(parLoc.x + parSize.width / 2, parLoc.y + parSize.height / 2), 0);
                    if (Balloon.this.iconImage != null) {
                        Balloon.this.iconCanvas.updateImage(Balloon.this.iconImage);
                    }
                }
            });
        }

        @Override
        public void dispose() {
            this.displayer.interrupt();
            super.dispose();
        }

        private void loadGtkImages() {
            if (!this.gtkImagesLoaded) {
                this.errorImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-error.6.rtl");
                this.warnImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-warning.6.rtl");
                this.infoImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-info.6.rtl");
                this.gtkImagesLoaded = true;
            }
        }

        private static class Message {
            String caption;
            String text;
            String messageType;

            Message(String caption, String text, String messageType) {
                this.caption = caption;
                this.text = text;
                this.messageType = messageType;
            }
        }

        private class Displayer
        extends Thread {
            final int MAX_CONCURRENT_MSGS = 10;
            ArrayBlockingQueue<Message> messageQueue = new ArrayBlockingQueue(10);
            boolean isDisplayed;

            Displayer() {
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Message msg = null;
                    try {
                        msg = this.messageQueue.take();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    XToolkit.awtLock();
                    try {
                        while (this.isDisplayed) {
                            try {
                                XToolkit.awtLockWait();
                            }
                            catch (InterruptedException e) {
                                XToolkit.awtUnlock();
                                return;
                            }
                        }
                        this.isDisplayed = true;
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                    Balloon.this._display(msg.caption, msg.text, msg.messageType);
                }
            }

            void display(String caption, String text, String messageType) {
                this.messageQueue.offer(new Message(caption, text, messageType));
            }
        }

        private class ActionPerformer
        extends MouseAdapter {
            private ActionPerformer() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Balloon.this.hide();
                if (e.getButton() == 1) {
                    ActionEvent aev = new ActionEvent(Balloon.this.target, 1001, Balloon.this.liveArguments.getActionCommand(), e.getWhen(), e.getModifiers());
                    XToolkit.postEvent(XToolkit.targetToAppContext(aev.getSource()), aev);
                }
            }
        }

        public static interface LiveArguments
        extends sun.awt.X11.InfoWindow$LiveArguments {
            public String getActionCommand();
        }
    }

    public static class Tooltip
    extends InfoWindow {
        private final Object target;
        private final LiveArguments liveArguments;
        private final Label textLabel = new Label("");
        private final Runnable starter = new Runnable(){

            @Override
            public void run() {
                Tooltip.this.display();
            }
        };
        private static final int TOOLTIP_SHOW_TIME = 10000;
        private static final int TOOLTIP_START_DELAY_TIME = 1000;
        private static final int TOOLTIP_MAX_LENGTH = 64;
        private static final int TOOLTIP_MOUSE_CURSOR_INDENT = 5;
        private static final Color TOOLTIP_BACKGROUND_COLOR = new Color(255, 255, 220);
        private static final Font TOOLTIP_TEXT_FONT = XWindow.getDefaultFont();

        public Tooltip(Frame parent, Object target, LiveArguments liveArguments) {
            super(parent, Color.black);
            this.target = target;
            this.liveArguments = liveArguments;
            XTrayIconPeer.suppressWarningString(this);
            this.setCloser(null, 10000);
            this.textLabel.setBackground(TOOLTIP_BACKGROUND_COLOR);
            this.textLabel.setFont(TOOLTIP_TEXT_FONT);
            this.add(this.textLabel);
        }

        private void display() {
            SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

                @Override
                public void run() {
                    if (Tooltip.this.liveArguments.isDisposed()) {
                        return;
                    }
                    String tooltipString = Tooltip.this.liveArguments.getTooltipString();
                    if (tooltipString == null) {
                        return;
                    }
                    if (tooltipString.length() > 64) {
                        Tooltip.this.textLabel.setText(tooltipString.substring(0, 64));
                    } else {
                        Tooltip.this.textLabel.setText(tooltipString);
                    }
                    Point pointer = (Point)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            if (!Tooltip.this.isPointerOverTrayIcon(Tooltip.this.liveArguments.getBounds())) {
                                return null;
                            }
                            return MouseInfo.getPointerInfo().getLocation();
                        }
                    });
                    if (pointer == null) {
                        return;
                    }
                    Tooltip.this.show(new Point(pointer.x, pointer.y), 5);
                }
            });
        }

        public void enter() {
            XToolkit.schedule(this.starter, 1000L);
        }

        public void exit() {
            XToolkit.remove(this.starter);
            if (this.isVisible()) {
                this.hide();
            }
        }

        private boolean isPointerOverTrayIcon(Rectangle trayRect) {
            Point p = MouseInfo.getPointerInfo().getLocation();
            return p.x >= trayRect.x && p.x <= trayRect.x + trayRect.width && p.y >= trayRect.y && p.y <= trayRect.y + trayRect.height;
        }

        public static interface LiveArguments
        extends sun.awt.X11.InfoWindow$LiveArguments {
            public String getTooltipString();
        }
    }

    private static interface LiveArguments {
        public boolean isDisposed();

        public Rectangle getBounds();
    }

    private class Closer
    implements Runnable {
        Runnable action;
        int time;

        private Closer() {
        }

        @Override
        public void run() {
            this.doClose();
        }

        void set(Runnable action, int time) {
            this.action = action;
            this.time = time;
        }

        void schedule() {
            XToolkit.schedule(this, this.time);
        }

        void close() {
            XToolkit.remove(this);
            this.doClose();
        }

        private void doClose() {
            SunToolkit.executeOnEventHandlerThread(InfoWindow.this, new Runnable(){

                @Override
                public void run() {
                    InfoWindow.super.hide();
                    InfoWindow.this.invalidate();
                    if (Closer.this.action != null) {
                        Closer.this.action.run();
                    }
                }
            });
        }
    }
}

