/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.net.TelnetProtocolException;

public class TelnetInputStream
extends FilterInputStream {
    boolean stickyCRLF = false;
    boolean seenCR = false;
    public boolean binaryMode = false;

    public TelnetInputStream(InputStream fd, boolean binary) {
        super(fd);
        this.binaryMode = binary;
    }

    public void setStickyCRLF(boolean on) {
        this.stickyCRLF = on;
    }

    @Override
    public int read() throws IOException {
        if (this.binaryMode) {
            return super.read();
        }
        if (this.seenCR) {
            this.seenCR = false;
            return 10;
        }
        int c = super.read();
        if (c == 13) {
            c = super.read();
            switch (c) {
                default: {
                    throw new TelnetProtocolException("misplaced CR in input");
                }
                case 0: {
                    return 13;
                }
                case 10: 
            }
            if (this.stickyCRLF) {
                this.seenCR = true;
                return 13;
            }
            return 10;
        }
        return c;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int off, int length) throws IOException {
        int c;
        if (this.binaryMode) {
            return super.read(bytes, off, length);
        }
        int offStart = off;
        while (--length >= 0 && (c = this.read()) != -1) {
            bytes[off++] = (byte)c;
        }
        return off > offStart ? off - offStart : -1;
    }
}

