/*
 * Decompiled with CFR 0.152.
 */
package sun.management.counter.perf;

import java.io.ObjectStreamException;
import java.nio.LongBuffer;
import sun.management.counter.AbstractCounter;
import sun.management.counter.LongArrayCounter;
import sun.management.counter.Units;
import sun.management.counter.Variability;
import sun.management.counter.perf.LongArrayCounterSnapshot;

public class PerfLongArrayCounter
extends AbstractCounter
implements LongArrayCounter {
    LongBuffer lb;
    private static final long serialVersionUID = -2733617913045487126L;

    PerfLongArrayCounter(String name, Units u, Variability v, int flags, int vectorLength, LongBuffer lb) {
        super(name, u, v, flags, vectorLength);
        this.lb = lb;
    }

    @Override
    public Object getValue() {
        return this.longArrayValue();
    }

    @Override
    public long[] longArrayValue() {
        this.lb.position(0);
        long[] l = new long[this.lb.limit()];
        this.lb.get(l);
        return l;
    }

    @Override
    public long longAt(int index) {
        this.lb.position(index);
        return this.lb.get();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new LongArrayCounterSnapshot(this.getName(), this.getUnits(), this.getVariability(), this.getFlags(), this.getVectorLength(), this.longArrayValue());
    }
}

