/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

public final class TextHitInfo {
    private int charIndex;
    private boolean isLeadingEdge;

    private TextHitInfo(int charIndex, boolean isLeadingEdge) {
        this.charIndex = charIndex;
        this.isLeadingEdge = isLeadingEdge;
    }

    public int getCharIndex() {
        return this.charIndex;
    }

    public boolean isLeadingEdge() {
        return this.isLeadingEdge;
    }

    public int getInsertionIndex() {
        return this.isLeadingEdge ? this.charIndex : this.charIndex + 1;
    }

    public int hashCode() {
        return this.charIndex;
    }

    public boolean equals(Object obj) {
        return obj instanceof TextHitInfo && this.equals((TextHitInfo)obj);
    }

    public boolean equals(TextHitInfo hitInfo) {
        return hitInfo != null && this.charIndex == hitInfo.charIndex && this.isLeadingEdge == hitInfo.isLeadingEdge;
    }

    public String toString() {
        return "TextHitInfo[" + this.charIndex + (this.isLeadingEdge ? "L" : "T") + "]";
    }

    public static TextHitInfo leading(int charIndex) {
        return new TextHitInfo(charIndex, true);
    }

    public static TextHitInfo trailing(int charIndex) {
        return new TextHitInfo(charIndex, false);
    }

    public static TextHitInfo beforeOffset(int offset) {
        return new TextHitInfo(offset - 1, false);
    }

    public static TextHitInfo afterOffset(int offset) {
        return new TextHitInfo(offset, true);
    }

    public TextHitInfo getOtherHit() {
        if (this.isLeadingEdge) {
            return TextHitInfo.trailing(this.charIndex - 1);
        }
        return TextHitInfo.leading(this.charIndex + 1);
    }

    public TextHitInfo getOffsetHit(int delta) {
        return new TextHitInfo(this.charIndex + delta, this.isLeadingEdge);
    }
}

