/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import sun.awt.AppContext;
import sun.awt.EventQueueDelegate;
import sun.awt.SunToolkit;

public class SwingUtilities3 {
    private static final Object DELEGATE_REPAINT_MANAGER_KEY = new StringBuilder("DelegateRepaintManagerKey");
    private static final Map<Container, Boolean> vsyncedMap = Collections.synchronizedMap(new WeakHashMap());

    public static void setDelegateRepaintManager(JComponent component, RepaintManager repaintManager) {
        AppContext.getAppContext().put(DELEGATE_REPAINT_MANAGER_KEY, Boolean.TRUE);
        component.putClientProperty(DELEGATE_REPAINT_MANAGER_KEY, repaintManager);
    }

    public static void setVsyncRequested(Container rootContainer, boolean isRequested) {
        assert (rootContainer instanceof Applet || rootContainer instanceof Window);
        if (isRequested) {
            vsyncedMap.put(rootContainer, Boolean.TRUE);
        } else {
            vsyncedMap.remove(rootContainer);
        }
    }

    public static boolean isVsyncRequested(Container rootContainer) {
        assert (rootContainer instanceof Applet || rootContainer instanceof Window);
        return Boolean.TRUE == vsyncedMap.get(rootContainer);
    }

    public static RepaintManager getDelegateRepaintManager(Component component) {
        RepaintManager delegate = null;
        if (Boolean.TRUE == SunToolkit.targetToAppContext(component).get(DELEGATE_REPAINT_MANAGER_KEY)) {
            while (delegate == null && component != null) {
                while (component != null && !(component instanceof JComponent)) {
                    component = component.getParent();
                }
                if (component == null) continue;
                delegate = (RepaintManager)((JComponent)component).getClientProperty(DELEGATE_REPAINT_MANAGER_KEY);
                component = component.getParent();
            }
        }
        return delegate;
    }

    public static void setEventQueueDelegate(Map<String, Map<String, Object>> map) {
        EventQueueDelegate.setDelegate(new EventQueueDelegateFromMap(map));
    }

    private static class EventQueueDelegateFromMap
    implements EventQueueDelegate.Delegate {
        private final AWTEvent[] afterDispatchEventArgument;
        private final Object[] afterDispatchHandleArgument;
        private final Callable<Void> afterDispatchCallable;
        private final AWTEvent[] beforeDispatchEventArgument;
        private final Callable<Object> beforeDispatchCallable;
        private final EventQueue[] getNextEventEventQueueArgument;
        private final Callable<AWTEvent> getNextEventCallable;

        public EventQueueDelegateFromMap(Map<String, Map<String, Object>> objectMap) {
            Map<String, Object> methodMap = objectMap.get("afterDispatch");
            this.afterDispatchEventArgument = (AWTEvent[])methodMap.get("event");
            this.afterDispatchHandleArgument = (Object[])methodMap.get("handle");
            this.afterDispatchCallable = (Callable)methodMap.get("method");
            methodMap = objectMap.get("beforeDispatch");
            this.beforeDispatchEventArgument = (AWTEvent[])methodMap.get("event");
            this.beforeDispatchCallable = (Callable)methodMap.get("method");
            methodMap = objectMap.get("getNextEvent");
            this.getNextEventEventQueueArgument = (EventQueue[])methodMap.get("eventQueue");
            this.getNextEventCallable = (Callable)methodMap.get("method");
        }

        @Override
        public void afterDispatch(AWTEvent event, Object handle) throws InterruptedException {
            this.afterDispatchEventArgument[0] = event;
            this.afterDispatchHandleArgument[0] = handle;
            try {
                this.afterDispatchCallable.call();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object beforeDispatch(AWTEvent event) throws InterruptedException {
            this.beforeDispatchEventArgument[0] = event;
            try {
                return this.beforeDispatchCallable.call();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public AWTEvent getNextEvent(EventQueue eventQueue) throws InterruptedException {
            this.getNextEventEventQueueArgument[0] = eventQueue;
            try {
                return this.getNextEventCallable.call();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

