/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.httpbinding;

import amazon.fws.clicommando.Command;
import java.net.URL;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwsHttpBindingRequest {
    private final Command command;
    private final URL url;
    private final String method;
    private final SortedMap<String, String> headerParameters;
    private final SortedMap<String, String> queryParameters;
    private final String accessId;
    private final String secretKey;

    AwsHttpBindingRequest(Builder builder) {
        this.command = builder.command;
        this.url = builder.url;
        this.method = builder.method;
        this.headerParameters = new TreeMap<String, String>(builder.headerParameters);
        this.queryParameters = new TreeMap<String, String>(builder.queryParameters);
        this.accessId = builder.accessId;
        this.secretKey = builder.secretKey;
    }

    public Command getCommand() {
        return this.command;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public SortedMap<String, String> getHeaderParameters() {
        return new TreeMap<String, String>(this.headerParameters);
    }

    public SortedMap<String, String> getQueryParameters() {
        return new TreeMap<String, String>(this.queryParameters);
    }

    public String getAccessId() {
        return this.accessId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public static class Builder {
        private Command command;
        private URL url;
        private String method;
        private SortedMap<String, String> headerParameters = new TreeMap<String, String>();
        private SortedMap<String, String> queryParameters = new TreeMap<String, String>();
        private String accessId;
        private String secretKey;

        public Builder withCommand(Command command) {
            this.command = command;
            return this;
        }

        public Builder withUrl(URL url) {
            this.url = url;
            return this;
        }

        public Builder withMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder withHeaderParameter(String headerKey, String headerValue) {
            this.headerParameters.put(headerKey, headerValue);
            return this;
        }

        public Builder withQueryParameter(String queryKey, String queryValue) {
            this.queryParameters.put(queryKey, queryValue);
            return this;
        }

        public Builder withAccessId(String accessId) {
            this.accessId = accessId;
            return this;
        }

        public Builder withSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public AwsHttpBindingRequest build() {
            return new AwsHttpBindingRequest(this);
        }
    }
}

