/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.conn.ssl;

import com.amazonaws.http.conn.ssl.TLSProtocol;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;

@ThreadSafe
public class SdkTLSSocketFactory
extends SSLSocketFactory {
    private static final Log log = LogFactory.getLog(SdkTLSSocketFactory.class);

    public SdkTLSSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        super(sslContext, hostnameVerifier);
    }

    protected final void prepareSocket(SSLSocket socket) {
        Object[] supported = socket.getSupportedProtocols();
        Object[] enabled = socket.getEnabledProtocols();
        if (log.isDebugEnabled()) {
            log.debug((Object)("socket.getSupportedProtocols(): " + Arrays.toString(supported) + ", socket.getEnabledProtocols(): " + Arrays.toString(enabled)));
        }
        ArrayList<Object> target = new ArrayList<Object>();
        if (supported != null) {
            TLSProtocol[] values = TLSProtocol.values();
            for (int i = 0; i < values.length; ++i) {
                String pname = values[i].getProtocolName();
                if (!this.existsIn(pname, (String[])supported)) continue;
                target.add(pname);
            }
        }
        if (enabled != null) {
            for (Object pname : enabled) {
                if (target.contains(pname)) continue;
                target.add(pname);
            }
        }
        if (target.size() > 0) {
            Object[] enabling = target.toArray(new String[target.size()]);
            socket.setEnabledProtocols((String[])enabling);
            if (log.isDebugEnabled()) {
                log.debug((Object)("TLS protocol enabled for SSL handshake: " + Arrays.toString(enabling)));
            }
        }
    }

    private boolean existsIn(String element, String[] a) {
        for (String s : a) {
            if (!element.equals(s)) continue;
            return true;
        }
        return false;
    }
}

