/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.legacy.connection;

import com.sun.corba.se.impl.legacy.connection.EndPointInfoImpl;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.iiop.IIOPAddress;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.legacy.connection.GetEndPointInfoAgainException;
import com.sun.corba.se.spi.legacy.connection.ORBSocketFactory;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.SocketInfo;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class DefaultSocketFactory
implements ORBSocketFactory {
    private ORB orb;
    private static ORBUtilSystemException wrapper = ORBUtilSystemException.get("rpc.transport");

    public void setORB(ORB orb) {
        this.orb = orb;
    }

    @Override
    public ServerSocket createServerSocket(String type, int port) throws IOException {
        ServerSocket serverSocket;
        if (!type.equals("IIOP_CLEAR_TEXT")) {
            throw wrapper.defaultCreateServerSocketGivenNonIiopClearText(type);
        }
        if (this.orb.getORBData().acceptorSocketType().equals("SocketChannel")) {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocket = serverSocketChannel.socket();
        } else {
            serverSocket = new ServerSocket();
        }
        serverSocket.bind(new InetSocketAddress(port));
        return serverSocket;
    }

    @Override
    public SocketInfo getEndPointInfo(org.omg.CORBA.ORB orb, IOR ior, SocketInfo socketInfo) {
        IIOPProfileTemplate temp = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
        IIOPAddress primary = temp.getPrimaryAddress();
        return new EndPointInfoImpl("IIOP_CLEAR_TEXT", primary.getPort(), primary.getHost().toLowerCase());
    }

    @Override
    public Socket createSocket(SocketInfo socketInfo) throws IOException, GetEndPointInfoAgainException {
        Socket socket;
        if (this.orb.getORBData().acceptorSocketType().equals("SocketChannel")) {
            InetSocketAddress address = new InetSocketAddress(socketInfo.getHost(), socketInfo.getPort());
            SocketChannel socketChannel = SocketChannel.open(address);
            socket = socketChannel.socket();
        } else {
            socket = new Socket(socketInfo.getHost(), socketInfo.getPort());
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return socket;
    }
}

