/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import sun.rmi.server.Util;
import sun.rmi.transport.ObjectTable;

public abstract class RemoteObject
implements Remote,
Serializable {
    protected transient RemoteRef ref;
    private static final long serialVersionUID = -3215090123894869218L;

    protected RemoteObject() {
        this.ref = null;
    }

    protected RemoteObject(RemoteRef newref) {
        this.ref = newref;
    }

    public RemoteRef getRef() {
        return this.ref;
    }

    public static Remote toStub(Remote obj) throws NoSuchObjectException {
        if (obj instanceof RemoteStub || obj != null && Proxy.isProxyClass(obj.getClass()) && Proxy.getInvocationHandler(obj) instanceof RemoteObjectInvocationHandler) {
            return obj;
        }
        return ObjectTable.getStub(obj);
    }

    public int hashCode() {
        return this.ref == null ? super.hashCode() : this.ref.remoteHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteObject) {
            if (this.ref == null) {
                return obj == this;
            }
            return this.ref.remoteEquals(((RemoteObject)obj).ref);
        }
        if (obj != null) {
            return obj.equals(this);
        }
        return false;
    }

    public String toString() {
        String classname = Util.getUnqualifiedName(this.getClass());
        return this.ref == null ? classname : classname + "[" + this.ref.remoteToString() + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        if (this.ref == null) {
            throw new MarshalException("Invalid remote object");
        }
        String refClassName = this.ref.getRefClass(out);
        if (refClassName == null || refClassName.length() == 0) {
            out.writeUTF("");
            out.writeObject(this.ref);
        } else {
            out.writeUTF(refClassName);
            this.ref.writeExternal(out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String refClassName = in.readUTF();
        if (refClassName == null || refClassName.length() == 0) {
            this.ref = (RemoteRef)in.readObject();
        } else {
            String internalRefClassName = "sun.rmi.server." + refClassName;
            Class<?> refClass = Class.forName(internalRefClassName);
            try {
                this.ref = (RemoteRef)refClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ClassNotFoundException(internalRefClassName, e);
            }
            catch (IllegalAccessException e) {
                throw new ClassNotFoundException(internalRefClassName, e);
            }
            catch (ClassCastException e) {
                throw new ClassNotFoundException(internalRefClassName, e);
            }
            this.ref.readExternal(in);
        }
    }
}

