/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class XSettings {
    private long serial = -1L;

    public Map update(byte[] data) {
        return new Update(data).update();
    }

    class Update {
        private static final int LITTLE_ENDIAN = 0;
        private static final int BIG_ENDIAN = 1;
        private static final int TYPE_INTEGER = 0;
        private static final int TYPE_STRING = 1;
        private static final int TYPE_COLOR = 2;
        private byte[] data;
        private int dlen;
        private int idx;
        private boolean isLittle;
        private long serial = -1L;
        private int nsettings = 0;
        private boolean isValid;
        private HashMap updatedSettings;

        Update(byte[] data) {
            this.data = data;
            this.dlen = data.length;
            if (this.dlen < 12) {
                return;
            }
            this.idx = 0;
            this.isLittle = this.getCARD8() == 0;
            this.idx = 4;
            this.serial = this.getCARD32();
            this.idx = 8;
            this.nsettings = this.getINT32();
            this.updatedSettings = new HashMap();
            this.isValid = true;
        }

        private void needBytes(int n) throws IndexOutOfBoundsException {
            if (this.idx + n <= this.dlen) {
                return;
            }
            throw new IndexOutOfBoundsException("at " + this.idx + " need " + n + " length " + this.dlen);
        }

        private int getCARD8() throws IndexOutOfBoundsException {
            this.needBytes(1);
            int val = this.data[this.idx] & 0xFF;
            ++this.idx;
            return val;
        }

        private int getCARD16() throws IndexOutOfBoundsException {
            this.needBytes(2);
            int val = this.isLittle ? this.data[this.idx + 0] & 0xFF | (this.data[this.idx + 1] & 0xFF) << 8 : (this.data[this.idx + 0] & 0xFF) << 8 | this.data[this.idx + 1] & 0xFF;
            this.idx += 2;
            return val;
        }

        private int getINT32() throws IndexOutOfBoundsException {
            this.needBytes(4);
            int val = this.isLittle ? this.data[this.idx + 0] & 0xFF | (this.data[this.idx + 1] & 0xFF) << 8 | (this.data[this.idx + 2] & 0xFF) << 16 | (this.data[this.idx + 3] & 0xFF) << 24 : (this.data[this.idx + 0] & 0xFF) << 24 | (this.data[this.idx + 1] & 0xFF) << 16 | (this.data[this.idx + 2] & 0xFF) << 8 | (this.data[this.idx + 3] & 0xFF) << 0;
            this.idx += 4;
            return val;
        }

        private long getCARD32() throws IndexOutOfBoundsException {
            return (long)this.getINT32() & 0xFFFFFFFFL;
        }

        private String getString(int len) throws IndexOutOfBoundsException {
            this.needBytes(len);
            String str = null;
            try {
                str = new String(this.data, this.idx, len, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.idx = this.idx + len + 3 & 0xFFFFFFFC;
            return str;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map update() {
            if (!this.isValid) {
                return null;
            }
            XSettings xSettings = XSettings.this;
            synchronized (xSettings) {
                long currentSerial = XSettings.this.serial;
                if (this.serial <= currentSerial) {
                    return null;
                }
                for (int i = 0; i < this.nsettings && this.idx < this.dlen; ++i) {
                    this.updateOne(currentSerial);
                }
                XSettings.this.serial = this.serial;
            }
            return this.updatedSettings;
        }

        private void updateOne(long currentSerial) throws IndexOutOfBoundsException, IllegalArgumentException {
            int type = this.getCARD8();
            ++this.idx;
            int nameLen = this.getCARD16();
            int nameIdx = this.idx;
            this.idx = this.idx + nameLen + 3 & 0xFFFFFFFC;
            long lastChanged = this.getCARD32();
            if (lastChanged <= currentSerial) {
                if (type == 0) {
                    this.idx += 4;
                } else if (type == 1) {
                    int len = this.getINT32();
                    this.idx = this.idx + len + 3 & 0xFFFFFFFC;
                } else if (type == 2) {
                    this.idx += 8;
                } else {
                    throw new IllegalArgumentException("Unknown type: " + type);
                }
                return;
            }
            this.idx = nameIdx;
            String name = this.getString(nameLen);
            this.idx += 4;
            Object value = null;
            if (type == 0) {
                value = this.getINT32();
            } else if (type == 1) {
                value = this.getString(this.getINT32());
            } else if (type == 2) {
                int r = this.getCARD16();
                int g = this.getCARD16();
                int b = this.getCARD16();
                int a = this.getCARD16();
                value = new Color((float)r / 65535.0f, (float)g / 65535.0f, (float)b / 65535.0f, (float)a / 65535.0f);
            } else {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
            if (name == null) {
                return;
            }
            this.updatedSettings.put(name, value);
        }
    }
}

