/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.FinalReference;
import java.lang.ref.Reference;
import sun.misc.VM;

public class ReferenceQueue<T> {
    static ReferenceQueue NULL = new Null();
    static ReferenceQueue ENQUEUED = new Null();
    private Lock lock = new Lock();
    private volatile Reference<? extends T> head = null;
    private long queueLength = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueue(Reference<? extends T> r) {
        Reference<? extends T> reference = r;
        synchronized (reference) {
            if (r.queue == ENQUEUED) {
                return false;
            }
            Lock lock = this.lock;
            synchronized (lock) {
                r.queue = ENQUEUED;
                r.next = this.head == null ? r : this.head;
                this.head = r;
                ++this.queueLength;
                if (r instanceof FinalReference) {
                    VM.addFinalRefCount(1);
                }
                this.lock.notifyAll();
                return true;
            }
        }
    }

    private Reference<? extends T> reallyPoll() {
        if (this.head != null) {
            Reference<? extends T> r = this.head;
            this.head = r.next == r ? null : r.next;
            r.queue = NULL;
            r.next = r;
            --this.queueLength;
            if (r instanceof FinalReference) {
                VM.addFinalRefCount(-1);
            }
            return r;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> poll() {
        if (this.head == null) {
            return null;
        }
        Lock lock = this.lock;
        synchronized (lock) {
            return this.reallyPoll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> remove(long timeout) throws IllegalArgumentException, InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout value");
        }
        Lock lock = this.lock;
        synchronized (lock) {
            Reference<T> r = this.reallyPoll();
            if (r != null) {
                return r;
            }
            do {
                this.lock.wait(timeout);
                r = this.reallyPoll();
                if (r == null) continue;
                return r;
            } while (timeout == 0L);
            return null;
        }
    }

    public Reference<? extends T> remove() throws InterruptedException {
        return this.remove(0L);
    }

    private static class Lock {
        private Lock() {
        }
    }

    private static class Null
    extends ReferenceQueue {
        private Null() {
        }

        boolean enqueue(Reference r) {
            return false;
        }
    }
}

