/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.nimbus;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

class EffectUtils {
    EffectUtils() {
    }

    static void clearImage(BufferedImage img) {
        Graphics2D g2 = img.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, img.getWidth(), img.getHeight());
        g2.dispose();
    }

    static BufferedImage gaussianBlur(BufferedImage src, BufferedImage dst, int radius) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null || dst.getWidth() != width || dst.getHeight() != height || src.getType() != dst.getType()) {
            dst = EffectUtils.createColorModelCompatibleImage(src);
        }
        float[] kernel = EffectUtils.createGaussianKernel(radius);
        if (src.getType() == 2) {
            int[] srcPixels = new int[width * height];
            int[] dstPixels = new int[width * height];
            EffectUtils.getPixels(src, 0, 0, width, height, srcPixels);
            EffectUtils.blur(srcPixels, dstPixels, width, height, kernel, radius);
            EffectUtils.blur(dstPixels, srcPixels, height, width, kernel, radius);
            EffectUtils.setPixels(dst, 0, 0, width, height, srcPixels);
        } else if (src.getType() == 10) {
            byte[] srcPixels = new byte[width * height];
            byte[] dstPixels = new byte[width * height];
            EffectUtils.getPixels(src, 0, 0, width, height, srcPixels);
            EffectUtils.blur(srcPixels, dstPixels, width, height, kernel, radius);
            EffectUtils.blur(dstPixels, srcPixels, height, width, kernel, radius);
            EffectUtils.setPixels(dst, 0, 0, width, height, srcPixels);
        } else {
            throw new IllegalArgumentException("EffectUtils.gaussianBlur() src image is not a supported type, type=[" + src.getType() + "]");
        }
        return dst;
    }

    private static void blur(int[] srcPixels, int[] dstPixels, int width, int height, float[] kernel, int radius) {
        for (int y = 0; y < height; ++y) {
            int index = y;
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                float b = 0.0f;
                float g = 0.0f;
                float r = 0.0f;
                float a = 0.0f;
                for (int i = -radius; i <= radius; ++i) {
                    int subOffset = x + i;
                    if (subOffset < 0 || subOffset >= width) {
                        subOffset = (x + width) % width;
                    }
                    int pixel = srcPixels[offset + subOffset];
                    float blurFactor = kernel[radius + i];
                    a += blurFactor * (float)(pixel >> 24 & 0xFF);
                    r += blurFactor * (float)(pixel >> 16 & 0xFF);
                    g += blurFactor * (float)(pixel >> 8 & 0xFF);
                    b += blurFactor * (float)(pixel & 0xFF);
                }
                int ca = (int)(a + 0.5f);
                int cr = (int)(r + 0.5f);
                int cg = (int)(g + 0.5f);
                int cb = (int)(b + 0.5f);
                dstPixels[index] = (ca > 255 ? 255 : ca) << 24 | (cr > 255 ? 255 : cr) << 16 | (cg > 255 ? 255 : cg) << 8 | (cb > 255 ? 255 : cb);
                index += height;
            }
        }
    }

    static void blur(byte[] srcPixels, byte[] dstPixels, int width, int height, float[] kernel, int radius) {
        for (int y = 0; y < height; ++y) {
            int index = y;
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                float p = 0.0f;
                for (int i = -radius; i <= radius; ++i) {
                    int subOffset = x + i;
                    if (subOffset < 0 || subOffset >= width) {
                        subOffset = (x + width) % width;
                    }
                    int pixel = srcPixels[offset + subOffset] & 0xFF;
                    float blurFactor = kernel[radius + i];
                    p += blurFactor * (float)pixel;
                }
                int cp = (int)(p + 0.5f);
                dstPixels[index] = (byte)(cp > 255 ? 255 : cp);
                index += height;
            }
        }
    }

    static float[] createGaussianKernel(int radius) {
        int i;
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        float[] data = new float[radius * 2 + 1];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        for (i = -radius; i <= radius; ++i) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        return data;
    }

    static byte[] getPixels(BufferedImage img, int x, int y, int w, int h, byte[] pixels) {
        if (w == 0 || h == 0) {
            return new byte[0];
        }
        if (pixels == null) {
            pixels = new byte[w * h];
        } else if (pixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 10) {
            WritableRaster raster = img.getRaster();
            return (byte[])raster.getDataElements(x, y, w, h, pixels);
        }
        throw new IllegalArgumentException("Only type BYTE_GRAY is supported");
    }

    static void setPixels(BufferedImage img, int x, int y, int w, int h, byte[] pixels) {
        if (pixels == null || w == 0 || h == 0) {
            return;
        }
        if (pixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType != 10) {
            throw new IllegalArgumentException("Only type BYTE_GRAY is supported");
        }
        WritableRaster raster = img.getRaster();
        raster.setDataElements(x, y, w, h, pixels);
    }

    public static int[] getPixels(BufferedImage img, int x, int y, int w, int h, int[] pixels) {
        if (w == 0 || h == 0) {
            return new int[0];
        }
        if (pixels == null) {
            pixels = new int[w * h];
        } else if (pixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            return (int[])raster.getDataElements(x, y, w, h, pixels);
        }
        return img.getRGB(x, y, w, h, pixels, 0, w);
    }

    public static void setPixels(BufferedImage img, int x, int y, int w, int h, int[] pixels) {
        if (pixels == null || w == 0 || h == 0) {
            return;
        }
        if (pixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            raster.setDataElements(x, y, w, h, pixels);
        } else {
            img.setRGB(x, y, w, h, pixels, 0, w);
        }
    }

    public static BufferedImage createColorModelCompatibleImage(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        return new BufferedImage(cm, cm.createCompatibleWritableRaster(image.getWidth(), image.getHeight()), cm.isAlphaPremultiplied(), null);
    }

    public static BufferedImage createCompatibleTranslucentImage(int width, int height) {
        return EffectUtils.isHeadless() ? new BufferedImage(width, height, 2) : EffectUtils.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }
}

