/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;

class XMap {
    private static HashMap xMappers = new HashMap();
    char[] convertedGlyphs;
    static final int SINGLE_BYTE = 1;
    static final int DOUBLE_BYTE = 2;
    private static final char SURR_MIN = '\ud800';
    private static final char SURR_MAX = '\udfff';

    static synchronized XMap getXMapper(String encoding) {
        XMap mapper = (XMap)xMappers.get(encoding);
        if (mapper == null) {
            mapper = XMap.getXMapperInternal(encoding);
            xMappers.put(encoding, mapper);
        }
        return mapper;
    }

    private static XMap getXMapperInternal(String encoding) {
        String jclass = null;
        int nBytes = 1;
        int maxU = 65535;
        int minU = 0;
        boolean addAscii = false;
        boolean lowPartOnly = false;
        if (encoding.equals("dingbats")) {
            jclass = "sun.awt.motif.X11Dingbats";
            minU = 9985;
            maxU = 10174;
        } else if (encoding.equals("symbol")) {
            jclass = "sun.awt.Symbol";
            minU = 913;
            maxU = 8943;
        } else if (encoding.equals("iso8859-1")) {
            maxU = 255;
        } else if (encoding.equals("iso8859-2")) {
            jclass = "ISO8859_2";
        } else if (encoding.equals("jisx0208.1983-0")) {
            jclass = "sun.awt.motif.X11JIS0208";
            nBytes = 2;
        } else if (encoding.equals("jisx0201.1976-0")) {
            jclass = "sun.awt.motif.X11JIS0201";
            addAscii = true;
            lowPartOnly = true;
        } else if (encoding.equals("jisx0212.1990-0")) {
            jclass = "sun.awt.motif.X11JIS0212";
            nBytes = 2;
        } else if (encoding.equals("iso8859-4")) {
            jclass = "ISO8859_4";
        } else if (encoding.equals("iso8859-5")) {
            jclass = "ISO8859_5";
        } else if (encoding.equals("koi8-r")) {
            jclass = "KOI8_R";
        } else if (encoding.equals("ansi-1251")) {
            jclass = "windows-1251";
        } else if (encoding.equals("iso8859-6")) {
            jclass = "ISO8859_6";
        } else if (encoding.equals("iso8859-7")) {
            jclass = "ISO8859_7";
        } else if (encoding.equals("iso8859-8")) {
            jclass = "ISO8859_8";
        } else if (encoding.equals("iso8859-9")) {
            jclass = "ISO8859_9";
        } else if (encoding.equals("iso8859-13")) {
            jclass = "ISO8859_13";
        } else if (encoding.equals("iso8859-15")) {
            jclass = "ISO8859_15";
        } else if (encoding.equals("ksc5601.1987-0")) {
            jclass = "sun.awt.motif.X11KSC5601";
            nBytes = 2;
        } else if (encoding.equals("ksc5601.1992-3")) {
            jclass = "sun.awt.motif.X11Johab";
            nBytes = 2;
        } else if (encoding.equals("ksc5601.1987-1")) {
            jclass = "EUC_KR";
            nBytes = 2;
        } else if (encoding.equals("cns11643-1")) {
            jclass = "sun.awt.motif.X11CNS11643P1";
            nBytes = 2;
        } else if (encoding.equals("cns11643-2")) {
            jclass = "sun.awt.motif.X11CNS11643P2";
            nBytes = 2;
        } else if (encoding.equals("cns11643-3")) {
            jclass = "sun.awt.motif.X11CNS11643P3";
            nBytes = 2;
        } else if (encoding.equals("gb2312.1980-0")) {
            jclass = "sun.awt.motif.X11GB2312";
            nBytes = 2;
        } else if (encoding.indexOf("big5") >= 0) {
            jclass = "Big5";
            nBytes = 2;
            addAscii = true;
        } else if (encoding.equals("tis620.2533-0")) {
            jclass = "TIS620";
        } else if (encoding.equals("gbk-0")) {
            jclass = "sun.awt.motif.X11GBK";
            nBytes = 2;
        } else if (encoding.indexOf("sun.unicode-0") >= 0) {
            jclass = "sun.awt.motif.X11SunUnicode_0";
            nBytes = 2;
        } else if (encoding.indexOf("gb18030.2000-1") >= 0) {
            jclass = "sun.awt.motif.X11GB18030_1";
            nBytes = 2;
        } else if (encoding.indexOf("gb18030.2000-0") >= 0) {
            jclass = "sun.awt.motif.X11GB18030_0";
            nBytes = 2;
        } else if (encoding.indexOf("hkscs") >= 0) {
            jclass = "sun.awt.HKSCS";
            nBytes = 2;
        }
        return new XMap(jclass, minU, maxU, nBytes, addAscii, lowPartOnly);
    }

    private XMap(String className, int minU, int maxU, int nBytes, boolean addAscii, boolean lowPartOnly) {
        int max;
        CharsetEncoder enc = null;
        if (className != null) {
            try {
                enc = className.startsWith("sun.awt") ? ((Charset)Class.forName(className).newInstance()).newEncoder() : Charset.forName(className).newEncoder();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        if (enc == null) {
            this.convertedGlyphs = new char[256];
            for (int i = 0; i < 256; ++i) {
                this.convertedGlyphs[i] = (char)i;
            }
            return;
        }
        int count = maxU - minU + 1;
        byte[] bytes = new byte[count * nBytes];
        char[] chars = new char[count];
        for (int i = 0; i < count; ++i) {
            chars[i] = (char)(minU + i);
        }
        int startCharIndex = 0;
        if (nBytes > 1 && minU < 256) {
            startCharIndex = 256 - minU;
        }
        byte[] rbytes = new byte[nBytes];
        try {
            int cbLen = 0;
            int bbLen = 0;
            if (startCharIndex < 55296 && startCharIndex + count > 57343) {
                cbLen = 55296 - startCharIndex;
                bbLen = cbLen * nBytes;
                enc.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(rbytes).encode(CharBuffer.wrap(chars, startCharIndex, cbLen), ByteBuffer.wrap(bytes, startCharIndex * nBytes, bbLen), true);
                startCharIndex = 57344;
            }
            cbLen = count - startCharIndex;
            bbLen = cbLen * nBytes;
            enc.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(rbytes).encode(CharBuffer.wrap(chars, startCharIndex, cbLen), ByteBuffer.wrap(bytes, startCharIndex * nBytes, bbLen), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.convertedGlyphs = new char[65536];
        for (int i = 0; i < count; ++i) {
            this.convertedGlyphs[i + minU] = nBytes == 1 ? (char)(bytes[i] & 0xFF) : (char)(((bytes[i * 2] & 0xFF) << 8) + (bytes[i * 2 + 1] & 0xFF));
        }
        int n = max = lowPartOnly ? 128 : 256;
        if (addAscii && this.convertedGlyphs.length >= 256) {
            for (int i = 0; i < max; ++i) {
                if (this.convertedGlyphs[i] != '\u0000') continue;
                this.convertedGlyphs[i] = (char)i;
            }
        }
    }
}

