/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing.dtrace;

import sun.tracing.dtrace.DTraceProvider;
import sun.tracing.dtrace.JVM;
import sun.tracing.dtrace.SystemResource;

class Activation {
    private SystemResource resource;
    private int referenceCount;

    Activation(String moduleName, DTraceProvider[] providers) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            RuntimePermission perm = new RuntimePermission("com.sun.tracing.dtrace.createProvider");
            security.checkPermission(perm);
        }
        this.referenceCount = providers.length;
        for (DTraceProvider p : providers) {
            p.setActivation(this);
        }
        this.resource = new SystemResource(this, JVM.activate(moduleName, providers));
    }

    void disposeProvider(DTraceProvider p) {
        if (--this.referenceCount == 0) {
            this.resource.dispose();
        }
    }
}

