/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.LinkOption;
import java.util.HashSet;
import java.util.Set;

class Util {
    private Util() {
    }

    static String[] split(String s, char c) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        String[] result = new String[count + 1];
        int n = 0;
        int last = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            result[n++] = s.substring(last, i);
            last = i + 1;
        }
        result[n] = s.substring(last, s.length());
        return result;
    }

    static <E> Set<E> newSet(E ... elements) {
        HashSet<E> set = new HashSet<E>();
        for (E e : elements) {
            set.add(e);
        }
        return set;
    }

    static <E> Set<E> newSet(Set<E> other, E ... elements) {
        HashSet<E> set = new HashSet<E>(other);
        for (E e : elements) {
            set.add(e);
        }
        return set;
    }

    static boolean followLinks(LinkOption ... options) {
        boolean followLinks = true;
        for (LinkOption option : options) {
            if (option != LinkOption.NOFOLLOW_LINKS) {
                if (option == null) {
                    throw new NullPointerException();
                }
                throw new AssertionError((Object)"Should not get here");
            }
            followLinks = false;
        }
        return followLinks;
    }
}

