/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import javax.naming.directory.SearchControls;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;

final class NotifierArgs {
    static final int ADDED_MASK = 1;
    static final int REMOVED_MASK = 2;
    static final int CHANGED_MASK = 4;
    static final int RENAMED_MASK = 8;
    String name;
    String filter;
    SearchControls controls;
    int mask;
    private int sum = -1;

    NotifierArgs(String name, int scope, NamingListener l) {
        this(name, "(objectclass=*)", null, l);
        if (scope != 1) {
            this.controls = new SearchControls();
            this.controls.setSearchScope(scope);
        }
    }

    NotifierArgs(String name, String filter, SearchControls ctls, NamingListener l) {
        this.name = name;
        this.filter = filter;
        this.controls = ctls;
        if (l instanceof NamespaceChangeListener) {
            this.mask |= 0xB;
        }
        if (l instanceof ObjectChangeListener) {
            this.mask |= 4;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof NotifierArgs) {
            NotifierArgs target = (NotifierArgs)obj;
            return this.mask == target.mask && this.name.equals(target.name) && this.filter.equals(target.filter) && this.checkControls(target.controls);
        }
        return false;
    }

    private boolean checkControls(SearchControls ctls) {
        if (this.controls == null || ctls == null) {
            return ctls == this.controls;
        }
        return this.controls.getSearchScope() == ctls.getSearchScope() && this.controls.getTimeLimit() == ctls.getTimeLimit() && this.controls.getDerefLinkFlag() == ctls.getDerefLinkFlag() && this.controls.getReturningObjFlag() == ctls.getReturningObjFlag() && this.controls.getCountLimit() == ctls.getCountLimit() && NotifierArgs.checkStringArrays(this.controls.getReturningAttributes(), ctls.getReturningAttributes());
    }

    private static boolean checkStringArrays(String[] s1, String[] s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        if (s1.length != s2.length) {
            return false;
        }
        for (int i = 0; i < s1.length; ++i) {
            if (s1[i].equals(s2[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.sum == -1) {
            this.sum = this.mask + this.name.hashCode() + this.filter.hashCode() + this.controlsCode();
        }
        return this.sum;
    }

    private int controlsCode() {
        if (this.controls == null) {
            return 0;
        }
        int total = this.controls.getTimeLimit() + (int)this.controls.getCountLimit() + (this.controls.getDerefLinkFlag() ? 1 : 0) + (this.controls.getReturningObjFlag() ? 1 : 0);
        String[] attrs = this.controls.getReturningAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                total += attrs[i].hashCode();
            }
        }
        return total;
    }
}

