/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import sun.awt.AWTAccessor;
import sun.awt.IconInfo;
import sun.awt.SunToolkit;
import sun.awt.X11.WindowDimensions;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XContentWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XFocusChangeEvent;
import sun.awt.X11.XFocusProxyWindow;
import sun.awt.X11.XIconWindow;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.util.logging.PlatformLogger;

abstract class XDecoratedPeer
extends XWindowPeer {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XDecoratedPeer");
    private static final PlatformLogger insLog = PlatformLogger.getLogger("sun.awt.X11.insets.XDecoratedPeer");
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.awt.X11.focus.XDecoratedPeer");
    private static final PlatformLogger iconLog = PlatformLogger.getLogger("sun.awt.X11.icon.XDecoratedPeer");
    boolean configure_seen;
    boolean insets_corrected;
    XIconWindow iconWindow;
    WindowDimensions dimensions;
    XContentWindow content;
    Insets currentInsets;
    XFocusProxyWindow focusProxy;
    private Insets wm_set_insets;
    long reparent_serial = 0L;
    boolean no_reparent_artifacts = false;
    XWindowPeer actualFocusedWindow = null;

    XDecoratedPeer(Window target) {
        super(target);
    }

    XDecoratedPeer(XCreateWindowParams params) {
        super(params);
    }

    public long getShell() {
        return this.window;
    }

    @Override
    public long getContentWindow() {
        return this.content == null ? this.window : this.content.getWindow();
    }

    @Override
    void preInit(XCreateWindowParams params) {
        super.preInit(params);
        this.winAttr.initialFocus = true;
        this.currentInsets = new Insets(0, 0, 0, 0);
        this.applyGuessedInsets();
        Rectangle bounds = (Rectangle)params.get("bounds");
        this.dimensions = new WindowDimensions(bounds, this.getRealInsets(), false);
        params.put("bounds", this.dimensions.getClientRect());
        if (insLog.isLoggable(PlatformLogger.Level.FINE)) {
            insLog.fine("Initial dimensions {0}", this.dimensions);
        }
        Long eventMask = (Long)params.get("event mask");
        params.add((Object)"event mask", eventMask & 0xFFFFFFFFFFDFFFFCL);
    }

    @Override
    void postInit(XCreateWindowParams params) {
        this.updateSizeHints(this.dimensions);
        super.postInit(params);
        this.initResizability();
        XWM.requestWMExtents(this.getWindow());
        this.content = XContentWindow.createContent(this);
        if (this.warningWindow != null) {
            this.warningWindow.toFront();
        }
        this.focusProxy = this.createFocusProxy();
    }

    @Override
    void setIconHints(List<IconInfo> icons) {
        if (!XWM.getWM().setNetWMIcon(this, icons) && icons.size() > 0) {
            if (this.iconWindow == null) {
                this.iconWindow = new XIconWindow(this);
            }
            this.iconWindow.setIconImages(icons);
        }
    }

    @Override
    public void updateMinimumSize() {
        super.updateMinimumSize();
        this.updateMinSizeHints();
    }

    private void updateMinSizeHints() {
        if (this.isResizable()) {
            Dimension minimumSize = this.getTargetMinimumSize();
            if (minimumSize != null) {
                Insets insets = this.getRealInsets();
                int minWidth = minimumSize.width - insets.left - insets.right;
                int minHeight = minimumSize.height - insets.top - insets.bottom;
                if (minWidth < 0) {
                    minWidth = 0;
                }
                if (minHeight < 0) {
                    minHeight = 0;
                }
                this.setSizeHints(0x10L | (this.isLocationByPlatform() ? 0L : 5L), this.getX(), this.getY(), minWidth, minHeight);
                if (this.isVisible()) {
                    int nh;
                    Rectangle bounds = this.getShellBounds();
                    int nw = bounds.width < minWidth ? minWidth : bounds.width;
                    int n = nh = bounds.height < minHeight ? minHeight : bounds.height;
                    if (nw != bounds.width || nh != bounds.height) {
                        this.setShellSize(new Rectangle(0, 0, nw, nh));
                    }
                }
            } else {
                boolean isMinSizeSet = this.isMinSizeSet();
                XWM.removeSizeHints(this, 16L);
                if (isMinSizeSet && this.isShowing() && XWM.needRemap(this)) {
                    this.xSetVisible(false);
                    XToolkit.XSync();
                    this.xSetVisible(true);
                }
            }
        }
    }

    XFocusProxyWindow createFocusProxy() {
        return new XFocusProxyWindow(this);
    }

    @Override
    protected XAtomList getWMProtocols() {
        XAtomList protocols = super.getWMProtocols();
        protocols.add(wm_delete_window);
        protocols.add(wm_take_focus);
        return protocols;
    }

    @Override
    public Graphics getGraphics() {
        AWTAccessor.ComponentAccessor compAccessor = AWTAccessor.getComponentAccessor();
        return this.getGraphics(this.content.surfaceData, compAccessor.getForeground(this.target), compAccessor.getBackground(this.target), compAccessor.getFont(this.target));
    }

    public void setTitle(String title) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Title is " + title);
        }
        this.winAttr.title = title;
        this.updateWMName();
    }

    @Override
    protected String getWMName() {
        if (this.winAttr.title == null || this.winAttr.title.trim().equals("")) {
            return " ";
        }
        return this.winAttr.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateWMName() {
        super.updateWMName();
        String name = this.getWMName();
        XToolkit.awtLock();
        try {
            if (name == null || name.trim().equals("")) {
                name = "Java";
            }
            XAtom iconNameAtom = XAtom.get(37L);
            iconNameAtom.setProperty(this.getWindow(), name);
            XAtom netIconNameAtom = XAtom.get("_NET_WM_ICON_NAME");
            netIconNameAtom.setPropertyUTF8(this.getWindow(), name);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    @Override
    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    @Override
    public void handleFocusEvent(XEvent xev) {
        super.handleFocusEvent(xev);
        XFocusChangeEvent xfe = xev.get_xfocus();
        if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
            focusLog.finer("Received focus event on shell: " + xfe);
        }
    }

    @Override
    protected boolean isInitialReshape() {
        return false;
    }

    private static Insets difference(Insets i1, Insets i2) {
        return new Insets(i1.top - i2.top, i1.left - i2.left, i1.bottom - i2.bottom, i1.right - i2.right);
    }

    private static boolean isNull(Insets i) {
        return i == null || (i.left | i.top | i.right | i.bottom) == 0;
    }

    private static Insets copy(Insets i) {
        return new Insets(i.top, i.left, i.bottom, i.right);
    }

    private Insets getWMSetInsets(XAtom changedAtom) {
        if (this.isEmbedded()) {
            return null;
        }
        if (this.wm_set_insets != null) {
            return this.wm_set_insets;
        }
        this.wm_set_insets = changedAtom == null ? XWM.getInsetsFromExtents(this.getWindow()) : XWM.getInsetsFromProp(this.getWindow(), changedAtom);
        if (insLog.isLoggable(PlatformLogger.Level.FINER)) {
            insLog.finer("FRAME_EXTENTS: {0}", this.wm_set_insets);
        }
        if (this.wm_set_insets != null) {
            this.wm_set_insets = XDecoratedPeer.copy(this.wm_set_insets);
        }
        return this.wm_set_insets;
    }

    private void resetWMSetInsets() {
        this.wm_set_insets = null;
    }

    @Override
    public void handlePropertyNotify(XEvent xev) {
        super.handlePropertyNotify(xev);
        XPropertyEvent ev = xev.get_xproperty();
        if (ev.get_atom() == XWM.XA_KDE_NET_WM_FRAME_STRUT.getAtom() || ev.get_atom() == XWM.XA_NET_FRAME_EXTENTS.getAtom()) {
            this.getWMSetInsets(XAtom.get(ev.get_atom()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleReparentNotifyEvent(XEvent xev) {
        XReparentEvent xe = xev.get_xreparent();
        if (insLog.isLoggable(PlatformLogger.Level.FINE)) {
            insLog.fine(xe.toString());
        }
        this.reparent_serial = xe.get_serial();
        XToolkit.awtLock();
        try {
            long root = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
            if (this.isEmbedded()) {
                this.setReparented(true);
                this.insets_corrected = true;
                return;
            }
            Component t = this.target;
            if (this.getDecorations() == XWindowAttributesData.AWT_DECOR_NONE) {
                this.setReparented(true);
                this.insets_corrected = true;
                this.reshape(this.dimensions, 2, false);
            } else if (xe.get_parent() == root) {
                this.configure_seen = false;
                this.insets_corrected = false;
                if (this.isVisible()) {
                    XWM.getWM().unshadeKludge(this);
                    insLog.fine("- WM exited");
                } else {
                    insLog.fine(" - reparent due to hide");
                }
            } else {
                this.setReparented(true);
                this.insets_corrected = false;
                Insets correctWM = this.getWMSetInsets(null);
                if (correctWM != null) {
                    Insets dimInsets;
                    if (insLog.isLoggable(PlatformLogger.Level.FINER)) {
                        insLog.finer("wm-provided insets {0}", correctWM);
                    }
                    if (correctWM.equals(dimInsets = this.dimensions.getInsets())) {
                        insLog.finer("Insets are the same as estimated - no additional reshapes necessary");
                        this.no_reparent_artifacts = true;
                        this.insets_corrected = true;
                        this.applyGuessedInsets();
                        return;
                    }
                } else {
                    correctWM = XWM.getWM().getInsets(this, xe.get_window(), xe.get_parent());
                    if (insLog.isLoggable(PlatformLogger.Level.FINER)) {
                        if (correctWM != null) {
                            insLog.finer("correctWM {0}", correctWM);
                        } else {
                            insLog.finer("correctWM insets are not available, waiting for configureNotify");
                        }
                    }
                }
                if (correctWM != null) {
                    this.handleCorrectInsets(correctWM);
                }
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCorrectInsets(Insets correctWM) {
        XToolkit.awtLock();
        try {
            Insets correction = XDecoratedPeer.difference(correctWM, this.currentInsets);
            if (insLog.isLoggable(PlatformLogger.Level.FINEST)) {
                insLog.finest("Corrention {0}", correction);
            }
            if (!XDecoratedPeer.isNull(correction)) {
                this.currentInsets = XDecoratedPeer.copy(correctWM);
                this.applyGuessedInsets();
                this.updateMinSizeHints();
            }
            if (insLog.isLoggable(PlatformLogger.Level.FINER)) {
                insLog.finer("Dimensions before reparent: " + this.dimensions);
            }
            this.dimensions.setInsets(this.getRealInsets());
            this.insets_corrected = true;
            if (this.isMaximized()) {
                return;
            }
            if ((this.getHints().get_flags() & 5L) != 0L) {
                this.reshape(this.dimensions, 3, false);
            } else {
                this.reshape(this.dimensions, 2, false);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void handleMoved(WindowDimensions dims) {
        Point loc = dims.getLocation();
        AWTAccessor.getComponentAccessor().setLocation(this.target, loc.x, loc.y);
        this.postEvent(new ComponentEvent(this.target, 100));
    }

    protected Insets guessInsets() {
        if (this.isEmbedded() || this.isTargetUndecorated()) {
            return new Insets(0, 0, 0, 0);
        }
        if (!XDecoratedPeer.isNull(this.currentInsets)) {
            return XDecoratedPeer.copy(this.currentInsets);
        }
        Insets res = this.getWMSetInsets(null);
        if (res == null) {
            res = XWM.getWM().guessInsets(this);
        }
        return res;
    }

    private void applyGuessedInsets() {
        Insets guessed = this.guessInsets();
        this.currentInsets = XDecoratedPeer.copy(guessed);
    }

    public void revalidate() {
        XToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            @Override
            public void run() {
                XDecoratedPeer.this.target.invalidate();
                XDecoratedPeer.this.target.validate();
            }
        });
    }

    Insets getRealInsets() {
        if (XDecoratedPeer.isNull(this.currentInsets)) {
            this.applyGuessedInsets();
        }
        return this.currentInsets;
    }

    @Override
    public Insets getInsets() {
        Insets in = XDecoratedPeer.copy(this.getRealInsets());
        in.top += this.getMenuBarHeight();
        if (insLog.isLoggable(PlatformLogger.Level.FINEST)) {
            insLog.finest("Get insets returns {0}", in);
        }
        return in;
    }

    boolean gravityBug() {
        return XWM.configureGravityBuggy();
    }

    int getInputMethodHeight() {
        return 0;
    }

    void updateSizeHints(WindowDimensions dims) {
        Rectangle rec = dims.getClientRect();
        this.checkShellRect(rec);
        this.updateSizeHints(rec.x, rec.y, rec.width, rec.height);
    }

    @Override
    void updateSizeHints() {
        this.updateSizeHints(this.dimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reshape(WindowDimensions newDimensions, int op, boolean userReshape) {
        if (insLog.isLoggable(PlatformLogger.Level.FINE)) {
            insLog.fine("Reshaping " + this + " to " + newDimensions + " op " + op + " user reshape " + userReshape);
        }
        if (userReshape) {
            Rectangle newBounds = newDimensions.getBounds();
            Insets insets = newDimensions.getInsets();
            if (newDimensions.isClientSizeSet()) {
                newBounds = new Rectangle(newBounds.x, newBounds.y, newBounds.width - insets.left - insets.right, newBounds.height - insets.top - insets.bottom);
            }
            newDimensions = new WindowDimensions(newBounds, insets, newDimensions.isClientSizeSet());
        }
        XToolkit.awtLock();
        try {
            if (!this.isReparented() || !this.isVisible()) {
                if (insLog.isLoggable(PlatformLogger.Level.FINE)) {
                    insLog.fine("- not reparented({0}) or not visible({1}), default reshape", this.isReparented(), this.visible);
                }
                Point oldLocation = this.getLocation();
                Point newLocation = new Point(AWTAccessor.getComponentAccessor().getX(this.target), AWTAccessor.getComponentAccessor().getY(this.target));
                if (!newLocation.equals(oldLocation)) {
                    this.handleMoved(newDimensions);
                }
                this.dimensions = new WindowDimensions(newDimensions);
                this.updateSizeHints(this.dimensions);
                Rectangle client = this.dimensions.getClientRect();
                this.checkShellRect(client);
                this.setShellBounds(client);
                if (this.content != null && !this.content.getSize().equals(newDimensions.getSize())) {
                    this.reconfigureContentWindow(newDimensions);
                }
                return;
            }
            int wm = XWM.getWMID();
            this.updateChildrenSizes();
            this.applyGuessedInsets();
            Rectangle shellRect = newDimensions.getClientRect();
            if (this.gravityBug()) {
                Insets in = newDimensions.getInsets();
                shellRect.translate(in.left, in.top);
            }
            if ((op & 0x4000) == 0 && this.isEmbedded()) {
                shellRect.setLocation(0, 0);
            }
            this.checkShellRectSize(shellRect);
            if (!this.isEmbedded()) {
                this.checkShellRectPos(shellRect);
            }
            if ((op &= 0xFFFFBFFF) == 1) {
                this.setShellPosition(shellRect);
            } else if (this.isResizable()) {
                if (op == 3) {
                    this.setShellBounds(shellRect);
                } else {
                    this.setShellSize(shellRect);
                }
            } else {
                XWM.setShellNotResizable(this, newDimensions, shellRect, true);
                if (op == 3) {
                    this.setShellPosition(shellRect);
                }
            }
            this.reconfigureContentWindow(newDimensions);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private void reshape(int x, int y, int width, int height, int operation, boolean userReshape) {
        boolean setClient = false;
        WindowDimensions dims = new WindowDimensions(this.dimensions);
        switch (operation & 0xFFFFBFFF) {
            case 1: {
                dims.setLocation(x, y);
                break;
            }
            case 2: {
                dims.setSize(width, height);
                break;
            }
            case 4: {
                Insets in = this.currentInsets;
                dims.setClientSize(width -= in.left + in.right, height -= in.top + in.bottom);
                break;
            }
            default: {
                dims.setLocation(x, y);
                dims.setSize(width, height);
            }
        }
        if (insLog.isLoggable(PlatformLogger.Level.FINE)) {
            insLog.fine("For the operation {0} new dimensions are {1}", XDecoratedPeer.operationToString(operation), dims);
        }
        this.reshape(dims, operation, userReshape);
    }

    abstract boolean isTargetUndecorated();

    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
        this.reshape(x, y, width, height, op, true);
        this.validateSurface();
    }

    void reconfigureContentWindow(WindowDimensions dims) {
        if (this.content == null) {
            insLog.fine("WARNING: Content window is null");
            return;
        }
        this.content.setContentBounds(dims);
    }

    @Override
    public void handleConfigureNotifyEvent(XEvent xev) {
        assert (SunToolkit.isAWTLockHeldByCurrentThread());
        XConfigureEvent xe = xev.get_xconfigure();
        if (insLog.isLoggable(PlatformLogger.Level.FINE)) {
            insLog.fine("Configure notify {0}", xe);
        }
        if (this.isReparented()) {
            this.configure_seen = true;
        }
        if (!(this.isMaximized() || xe.get_serial() != this.reparent_serial && xe.get_window() == this.getShell() || this.no_reparent_artifacts)) {
            insLog.fine("- reparent artifact, skipping");
            return;
        }
        this.no_reparent_artifacts = false;
        if (!this.isVisible() && XWM.getWMID() != 2) {
            insLog.fine(" - not visible, skipping");
            return;
        }
        int runningWM = XWM.getWMID();
        if (insLog.isLoggable(PlatformLogger.Level.FINE)) {
            insLog.fine("reparented={0}, visible={1}, WM={2}, decorations={3}", this.isReparented(), this.isVisible(), runningWM, this.getDecorations());
        }
        if (!this.isReparented() && this.isVisible() && runningWM != 2 && !XWM.isNonReparentingWM() && this.getDecorations() != XWindowAttributesData.AWT_DECOR_NONE) {
            insLog.fine("- visible but not reparented, skipping");
            return;
        }
        if (!this.insets_corrected && this.getDecorations() != XWindowAttributesData.AWT_DECOR_NONE) {
            Insets correctWM;
            long parent = XlibUtil.getParentWindow(this.window);
            Insets insets = correctWM = parent != -1L ? XWM.getWM().getInsets(this, this.window, parent) : null;
            if (insLog.isLoggable(PlatformLogger.Level.FINER)) {
                if (correctWM != null) {
                    insLog.finer("Configure notify - insets : " + correctWM);
                } else {
                    insLog.finer("Configure notify - insets are still not available");
                }
            }
            if (correctWM != null) {
                this.handleCorrectInsets(correctWM);
            } else {
                this.insets_corrected = true;
            }
        }
        this.updateChildrenSizes();
        Rectangle targetBounds = AWTAccessor.getComponentAccessor().getBounds(this.target);
        Point newLocation = targetBounds.getLocation();
        if (xe.get_send_event() || runningWM == 2 || XWM.isNonReparentingWM()) {
            newLocation = new Point(xe.get_x() - this.currentInsets.left, xe.get_y() - this.currentInsets.top);
        } else {
            switch (XWM.getWMID()) {
                case 5: 
                case 6: 
                case 9: 
                case 11: 
                case 15: {
                    Point xlocation = this.queryXLocation();
                    if (log.isLoggable(PlatformLogger.Level.FINE)) {
                        log.fine("New X location: {0}", xlocation);
                    }
                    if (xlocation == null) break;
                    newLocation = xlocation;
                    break;
                }
            }
        }
        WindowDimensions newDimensions = new WindowDimensions(newLocation, new Dimension(xe.get_width(), xe.get_height()), XDecoratedPeer.copy(this.currentInsets), true);
        if (insLog.isLoggable(PlatformLogger.Level.FINER)) {
            insLog.finer("Insets are {0}, new dimensions {1}", this.currentInsets, newDimensions);
        }
        this.checkIfOnNewScreen(newDimensions.getBounds());
        Point oldLocation = this.getLocation();
        this.dimensions = newDimensions;
        if (!newLocation.equals(oldLocation)) {
            this.handleMoved(newDimensions);
        }
        this.reconfigureContentWindow(newDimensions);
        this.updateChildrenSizes();
        this.repositionSecurityWarning();
    }

    private void checkShellRectSize(Rectangle shellRect) {
        shellRect.width = Math.max(1, shellRect.width);
        shellRect.height = Math.max(1, shellRect.height);
    }

    private void checkShellRectPos(Rectangle shellRect) {
        int wm = XWM.getWMID();
        if ((wm == 5 || wm == 6) && shellRect.x == 0 && shellRect.y == 0) {
            shellRect.y = 1;
            shellRect.x = 1;
        }
    }

    private void checkShellRect(Rectangle shellRect) {
        this.checkShellRectSize(shellRect);
        this.checkShellRectPos(shellRect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellBounds(Rectangle rec) {
        if (insLog.isLoggable(PlatformLogger.Level.FINE)) {
            insLog.fine("Setting shell bounds on " + this + " to " + rec);
        }
        XToolkit.awtLock();
        try {
            this.updateSizeHints(rec.x, rec.y, rec.width, rec.height);
            XlibWrapper.XResizeWindow(XToolkit.getDisplay(), this.getShell(), rec.width, rec.height);
            XlibWrapper.XMoveWindow(XToolkit.getDisplay(), this.getShell(), rec.x, rec.y);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellSize(Rectangle rec) {
        if (insLog.isLoggable(PlatformLogger.Level.FINE)) {
            insLog.fine("Setting shell size on " + this + " to " + rec);
        }
        XToolkit.awtLock();
        try {
            this.updateSizeHints(rec.x, rec.y, rec.width, rec.height);
            XlibWrapper.XResizeWindow(XToolkit.getDisplay(), this.getShell(), rec.width, rec.height);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellPosition(Rectangle rec) {
        if (insLog.isLoggable(PlatformLogger.Level.FINE)) {
            insLog.fine("Setting shell position on " + this + " to " + rec);
        }
        XToolkit.awtLock();
        try {
            this.updateSizeHints(rec.x, rec.y, rec.width, rec.height);
            XlibWrapper.XMoveWindow(XToolkit.getDisplay(), this.getShell(), rec.x, rec.y);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void initResizability() {
        this.setResizable(this.winAttr.initialResizability);
    }

    public void setResizable(boolean resizable) {
        int fs = this.winAttr.functions;
        if (!this.isResizable() && resizable) {
            this.currentInsets = new Insets(0, 0, 0, 0);
            this.resetWMSetInsets();
            if (!this.isEmbedded()) {
                this.setReparented(false);
            }
            this.winAttr.isResizable = resizable;
            fs = (fs & 1) != 0 ? (fs &= 0xFFFFFFED) : (fs |= 0x12);
            this.winAttr.functions = fs;
            XWM.setShellResizable(this);
        } else if (this.isResizable() && !resizable) {
            this.currentInsets = new Insets(0, 0, 0, 0);
            this.resetWMSetInsets();
            if (!this.isEmbedded()) {
                this.setReparented(false);
            }
            this.winAttr.isResizable = resizable;
            fs = (fs & 1) != 0 ? (fs |= 0x12) : (fs &= 0xFFFFFFED);
            this.winAttr.functions = fs;
            XWM.setShellNotResizable(this, this.dimensions, this.dimensions.getBounds(), false);
        }
    }

    Rectangle getShellBounds() {
        return this.dimensions.getClientRect();
    }

    @Override
    public Rectangle getBounds() {
        return this.dimensions.getBounds();
    }

    @Override
    public Dimension getSize() {
        return this.dimensions.getSize();
    }

    @Override
    public int getX() {
        return this.dimensions.getLocation().x;
    }

    @Override
    public int getY() {
        return this.dimensions.getLocation().y;
    }

    public Point getLocation() {
        return this.dimensions.getLocation();
    }

    @Override
    public int getAbsoluteX() {
        return this.dimensions.getScreenBounds().x;
    }

    @Override
    public int getAbsoluteY() {
        return this.dimensions.getScreenBounds().y;
    }

    @Override
    public int getWidth() {
        return this.getSize().width;
    }

    @Override
    public int getHeight() {
        return this.getSize().height;
    }

    public final WindowDimensions getDimensions() {
        return this.dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getLocationOnScreen() {
        XToolkit.awtLock();
        try {
            if (this.configure_seen) {
                Point point = this.toGlobal(0, 0);
                return point;
            }
            Point location = this.target.getLocation();
            if (insLog.isLoggable(PlatformLogger.Level.FINE)) {
                insLog.fine("getLocationOnScreen {0} not reparented: {1} ", this, location);
            }
            Point point = location;
            return point;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    protected boolean isEventDisabled(XEvent e) {
        switch (e.get_type()) {
            case 22: {
                return true;
            }
            case 7: 
            case 8: {
                return true;
            }
        }
        return super.isEventDisabled(e);
    }

    int getDecorations() {
        return this.winAttr.decorations;
    }

    int getFunctions() {
        return this.winAttr.functions;
    }

    @Override
    public void setVisible(boolean vis) {
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("Setting {0} to visible {1}", this, vis);
        }
        if (vis && !this.isVisible()) {
            XWM.setShellDecor(this);
            super.setVisible(vis);
            if (this.winAttr.isResizable) {
                XWM.removeSizeHints(this, 32L);
                this.updateMinimumSize();
            }
        } else {
            super.setVisible(vis);
        }
    }

    @Override
    protected void suppressWmTakeFocus(boolean doSuppress) {
        XAtomList protocols = this.getWMProtocols();
        if (doSuppress) {
            protocols.remove(wm_take_focus);
        } else {
            protocols.add(wm_take_focus);
        }
        wm_protocols.setAtomListProperty((XBaseWindow)this, protocols);
    }

    @Override
    public void dispose() {
        if (this.content != null) {
            this.content.destroy();
        }
        this.focusProxy.destroy();
        if (this.iconWindow != null) {
            this.iconWindow.destroy();
        }
        super.dispose();
    }

    @Override
    public void handleClientMessage(XEvent xev) {
        super.handleClientMessage(xev);
        XClientMessageEvent cl = xev.get_xclient();
        if (wm_protocols != null && cl.get_message_type() == wm_protocols.getAtom()) {
            if (cl.get_data(0) == wm_delete_window.getAtom()) {
                this.handleQuit();
            } else if (cl.get_data(0) == wm_take_focus.getAtom()) {
                this.handleWmTakeFocus(cl);
            }
        }
    }

    private void handleWmTakeFocus(XClientMessageEvent cl) {
        if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
            focusLog.fine("WM_TAKE_FOCUS on {0}", this);
        }
        this.requestWindowFocus(cl.get_data(1), true);
    }

    @Override
    protected void requestXFocus(long time, boolean timeProvided) {
        if (this.focusProxy == null) {
            if (focusLog.isLoggable(PlatformLogger.Level.WARNING)) {
                focusLog.warning("Focus proxy is null for " + this);
            }
        } else {
            if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                focusLog.fine("Requesting focus to proxy: " + this.focusProxy);
            }
            if (timeProvided) {
                this.focusProxy.xRequestFocus(time);
            } else {
                this.focusProxy.xRequestFocus();
            }
        }
    }

    XFocusProxyWindow getFocusProxy() {
        return this.focusProxy;
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    final void dumpMe() {
        System.err.println(">>> Peer: " + this.x + ", " + this.y + ", " + this.width + ", " + this.height);
    }

    final void dumpTarget() {
        AWTAccessor.ComponentAccessor compAccessor = AWTAccessor.getComponentAccessor();
        int getWidth = compAccessor.getWidth(this.target);
        int getHeight = compAccessor.getHeight(this.target);
        int getTargetX = compAccessor.getX(this.target);
        int getTargetY = compAccessor.getY(this.target);
        System.err.println(">>> Target: " + getTargetX + ", " + getTargetY + ", " + getWidth + ", " + getHeight);
    }

    final void dumpShell() {
        this.dumpWindow("Shell", this.getShell());
    }

    final void dumpContent() {
        this.dumpWindow("Content", this.getContentWindow());
    }

    final void dumpParent() {
        long parent = XlibUtil.getParentWindow(this.getShell());
        if (parent != 0L) {
            this.dumpWindow("Parent", parent);
        } else {
            System.err.println(">>> NO PARENT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpWindow(String id, long window) {
        XWindowAttributes pattr = new XWindowAttributes();
        try {
            XToolkit.awtLock();
            try {
                int n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), window, pattr.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
            System.err.println(">>>> " + id + ": " + pattr.get_x() + ", " + pattr.get_y() + ", " + pattr.get_width() + ", " + pattr.get_height());
        }
        finally {
            pattr.dispose();
        }
    }

    final void dumpAll() {
        this.dumpTarget();
        this.dumpMe();
        this.dumpParent();
        this.dumpShell();
        this.dumpContent();
    }

    boolean isMaximized() {
        return false;
    }

    @Override
    boolean isOverrideRedirect() {
        return Window.Type.POPUP.equals((Object)this.getWindowType());
    }

    @Override
    public boolean requestWindowFocus(long time, boolean timeProvided) {
        focusLog.fine("Request for decorated window focus");
        Window focusedWindow = XKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow();
        Window activeWindow = XWindowPeer.getDecoratedOwner(focusedWindow);
        if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
            focusLog.finer("Current window is: active={0}, focused={1}", this.target == activeWindow, this.target == focusedWindow);
        }
        XWindowPeer toFocus = this;
        while (toFocus.nextTransientFor != null) {
            toFocus = toFocus.nextTransientFor;
        }
        if (toFocus == null || !toFocus.focusAllowedFor()) {
            return false;
        }
        if (this == toFocus) {
            if (this.isWMStateNetHidden()) {
                focusLog.fine("The window is unmapped, so rejecting the request");
                return false;
            }
            if (this.target == activeWindow && this.target != focusedWindow) {
                focusLog.fine("Focus is on child window - transfering it back to the owner");
                this.handleWindowFocusInSync(-1L);
                return true;
            }
            Window realNativeFocusedWindow = XWindowPeer.getNativeFocusedWindow();
            if (focusLog.isLoggable(PlatformLogger.Level.FINEST)) {
                focusLog.finest("Real native focused window: " + realNativeFocusedWindow + "\nKFM's focused window: " + focusedWindow);
            }
            if (this.target == realNativeFocusedWindow && XWM.getWMID() == 11) {
                if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                    focusLog.fine("The window is already natively focused.");
                }
                return true;
            }
        }
        if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
            focusLog.fine("Requesting focus to " + (this == toFocus ? "this window" : toFocus));
        }
        if (timeProvided) {
            toFocus.requestXFocus(time);
        } else {
            toFocus.requestXFocus();
        }
        return this == toFocus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setActualFocusedWindow(XWindowPeer actualFocusedWindow) {
        Object object = this.getStateLock();
        synchronized (object) {
            this.actualFocusedWindow = actualFocusedWindow;
        }
    }

    boolean requestWindowFocus(XWindowPeer actualFocusedWindow, long time, boolean timeProvided) {
        this.setActualFocusedWindow(actualFocusedWindow);
        return this.requestWindowFocus(time, timeProvided);
    }

    @Override
    public void handleWindowFocusIn(long serial) {
        if (null == this.actualFocusedWindow) {
            super.handleWindowFocusIn(serial);
        } else {
            this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    XWindowPeer fw = null;
                    Object object = XDecoratedPeer.this.getStateLock();
                    synchronized (object) {
                        fw = XDecoratedPeer.this.actualFocusedWindow;
                        XDecoratedPeer.this.actualFocusedWindow = null;
                        if (null == fw || !fw.isVisible() || !fw.isFocusableWindow()) {
                            fw = XDecoratedPeer.this;
                        }
                    }
                    fw.handleWindowFocusIn_Dispatch();
                }
            }));
        }
    }

    @Override
    public void handleWindowFocusOut(Window oppositeWindow, long serial) {
        Window owner;
        Window actualFocusedWindow = XKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow();
        if (actualFocusedWindow != null && actualFocusedWindow != this.target && (owner = XWindowPeer.getDecoratedOwner(actualFocusedWindow)) != null && owner == this.target) {
            this.setActualFocusedWindow((XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(actualFocusedWindow));
        }
        super.handleWindowFocusOut(oppositeWindow, serial);
    }

    private Point queryXLocation() {
        return XlibUtil.translateCoordinates(this.getContentWindow(), XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber()), new Point(0, 0));
    }
}

