/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.naming.pcosnaming;

import com.sun.corba.se.impl.naming.pcosnaming.NameService;
import com.sun.corba.se.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.se.spi.activation.InitialNameService;
import com.sun.corba.se.spi.activation.InitialNameServiceHelper;
import com.sun.corba.se.spi.orb.ORB;
import java.io.File;
import java.util.Properties;
import org.omg.CosNaming.NamingContext;

public class NameServer {
    private ORB orb;
    private File dbDir;
    private static final String dbName = "names.db";

    public static void main(String[] args) {
        NameServer ns = new NameServer(args);
        ns.run();
    }

    protected NameServer(String[] args) {
        Properties props = System.getProperties();
        props.put("com.sun.CORBA.POA.ORBServerId", "1000");
        props.put("org.omg.CORBA.ORBClass", "com.sun.corba.se.impl.orb.ORBImpl");
        this.orb = (ORB)org.omg.CORBA.ORB.init(args, props);
        String dbDirName = props.getProperty("com.sun.CORBA.activation.DbDir") + props.getProperty("file.separator") + dbName + props.getProperty("file.separator");
        this.dbDir = new File(dbDirName);
        if (!this.dbDir.exists()) {
            this.dbDir.mkdir();
        }
    }

    protected void run() {
        try {
            NameService ns = new NameService(this.orb, this.dbDir);
            NamingContext rootContext = ns.initialNamingContext();
            InitialNameService ins = InitialNameServiceHelper.narrow(this.orb.resolve_initial_references("InitialNameService"));
            ins.bind("NameService", rootContext, true);
            System.out.println(CorbaResourceUtil.getText("pnameserv.success"));
            this.orb.run();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

