/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.colorchooser.ColorPanel;

final class DiagramComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    private final ColorPanel panel;
    private final boolean diagram;
    private final Insets insets = new Insets(0, 0, 0, 0);
    private int width;
    private int height;
    private int[] array;
    private BufferedImage image;

    DiagramComponent(ColorPanel panel, boolean diagram) {
        this.panel = panel;
        this.diagram = diagram;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean update;
        this.getInsets(this.insets);
        this.width = this.getWidth() - this.insets.left - this.insets.right;
        this.height = this.getHeight() - this.insets.top - this.insets.bottom;
        boolean bl = update = this.image == null || this.width != this.image.getWidth() || this.height != this.image.getHeight();
        if (update) {
            int size = this.width * this.height;
            if (this.array == null || this.array.length < size) {
                this.array = new int[size];
            }
            this.image = new BufferedImage(this.width, this.height, 1);
        }
        float dx = 1.0f / (float)(this.width - 1);
        float dy = 1.0f / (float)(this.height - 1);
        int offset = 0;
        float y = 0.0f;
        int h = 0;
        while (h < this.height) {
            int w;
            if (this.diagram) {
                float x = 0.0f;
                w = 0;
                while (w < this.width) {
                    this.array[offset] = this.panel.getColor(x, y);
                    ++w;
                    x += dx;
                    ++offset;
                }
            } else {
                int color = this.panel.getColor(y);
                w = 0;
                while (w < this.width) {
                    this.array[offset] = color;
                    ++w;
                    ++offset;
                }
            }
            ++h;
            y += dy;
        }
        this.image.setRGB(0, 0, this.width, this.height, this.array, 0, this.width);
        g.drawImage(this.image, this.insets.left, this.insets.top, this.width, this.height, this);
        if (this.isEnabled()) {
            --this.width;
            --this.height;
            g.setXORMode(Color.WHITE);
            g.setColor(Color.BLACK);
            if (this.diagram) {
                int x = DiagramComponent.getValue(this.panel.getValueX(), this.insets.left, this.width);
                int y2 = DiagramComponent.getValue(this.panel.getValueY(), this.insets.top, this.height);
                g.drawLine(x - 8, y2, x + 8, y2);
                g.drawLine(x, y2 - 8, x, y2 + 8);
            } else {
                int z = DiagramComponent.getValue(this.panel.getValueZ(), this.insets.top, this.height);
                g.drawLine(this.insets.left, z, this.insets.left + this.width, z);
            }
            g.setPaintMode();
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.mouseDragged(event);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.isEnabled()) {
            float y = DiagramComponent.getValue(event.getY(), this.insets.top, this.height);
            if (this.diagram) {
                float x = DiagramComponent.getValue(event.getX(), this.insets.left, this.width);
                this.panel.setValue(x, y);
            } else {
                this.panel.setValue(y);
            }
        }
    }

    private static int getValue(float value, int min, int max) {
        return min + (int)(value * (float)max);
    }

    private static float getValue(int value, int min, int max) {
        if (min < value) {
            return (value -= min) < max ? (float)value / (float)max : 1.0f;
        }
        return 0.0f;
    }
}

