/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.action.GetPropertyAction;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;
import sun.security.provider.DSAPublicKeyImpl;

public class DSAKeyFactory
extends KeyFactorySpi {
    static final boolean SERIAL_INTEROP;
    private static final String SERIAL_PROP = "sun.security.key.serial.interop";

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DSAPublicKeySpec) {
                DSAPublicKeySpec dsaPubKeySpec = (DSAPublicKeySpec)keySpec;
                if (SERIAL_INTEROP) {
                    return new DSAPublicKey(dsaPubKeySpec.getY(), dsaPubKeySpec.getP(), dsaPubKeySpec.getQ(), dsaPubKeySpec.getG());
                }
                return new DSAPublicKeyImpl(dsaPubKeySpec.getY(), dsaPubKeySpec.getP(), dsaPubKeySpec.getQ(), dsaPubKeySpec.getG());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                if (SERIAL_INTEROP) {
                    return new DSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
                }
                return new DSAPublicKeyImpl(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DSAPrivateKeySpec) {
                DSAPrivateKeySpec dsaPrivKeySpec = (DSAPrivateKeySpec)keySpec;
                return new DSAPrivateKey(dsaPrivKeySpec.getX(), dsaPrivKeySpec.getP(), dsaPrivKeySpec.getQ(), dsaPrivKeySpec.getG());
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new DSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
        }
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        try {
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                Class<T> dsaPubKeySpec = Class.forName("java.security.spec.DSAPublicKeySpec");
                Class<T> x509KeySpec = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (dsaPubKeySpec.isAssignableFrom(keySpec)) {
                    java.security.interfaces.DSAPublicKey dsaPubKey = (java.security.interfaces.DSAPublicKey)key;
                    DSAParams params = dsaPubKey.getParams();
                    return (T)((KeySpec)keySpec.cast(new DSAPublicKeySpec(dsaPubKey.getY(), params.getP(), params.getQ(), params.getG())));
                }
                if (x509KeySpec.isAssignableFrom(keySpec)) {
                    return (T)((KeySpec)keySpec.cast(new X509EncodedKeySpec(key.getEncoded())));
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.DSAPrivateKey) {
                Class<T> dsaPrivKeySpec = Class.forName("java.security.spec.DSAPrivateKeySpec");
                Class<T> pkcs8KeySpec = Class.forName("java.security.spec.PKCS8EncodedKeySpec");
                if (dsaPrivKeySpec.isAssignableFrom(keySpec)) {
                    java.security.interfaces.DSAPrivateKey dsaPrivKey = (java.security.interfaces.DSAPrivateKey)key;
                    DSAParams params = dsaPrivKey.getParams();
                    return (T)((KeySpec)keySpec.cast(new DSAPrivateKeySpec(dsaPrivKey.getX(), params.getP(), params.getQ(), params.getG())));
                }
                if (pkcs8KeySpec.isAssignableFrom(keySpec)) {
                    return (T)((KeySpec)keySpec.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key type");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                if (key instanceof DSAPublicKey) {
                    return key;
                }
                DSAPublicKeySpec dsaPubKeySpec = this.engineGetKeySpec(key, DSAPublicKeySpec.class);
                return this.engineGeneratePublic(dsaPubKeySpec);
            }
            if (key instanceof java.security.interfaces.DSAPrivateKey) {
                if (key instanceof DSAPrivateKey) {
                    return key;
                }
                DSAPrivateKeySpec dsaPrivKeySpec = this.engineGetKeySpec(key, DSAPrivateKeySpec.class);
                return this.engineGeneratePrivate(dsaPrivKeySpec);
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key: " + e.getMessage());
        }
    }

    static {
        String prop = AccessController.doPrivileged(new GetPropertyAction(SERIAL_PROP, null));
        SERIAL_INTEROP = "true".equalsIgnoreCase(prop);
    }
}

