/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthDesktopPaneUI;
import javax.swing.plaf.synth.SynthInternalFrameTitlePane;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthInternalFrameUI
extends BasicInternalFrameUI
implements SynthUI,
PropertyChangeListener {
    private SynthStyle style;

    public static ComponentUI createUI(JComponent b) {
        return new SynthInternalFrameUI((JInternalFrame)b);
    }

    protected SynthInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    @Override
    public void installDefaults() {
        this.internalFrameLayout = this.createLayoutManager();
        this.frame.setLayout(this.internalFrameLayout);
        this.updateStyle(this.frame);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallComponents() {
        if (this.frame.getComponentPopupMenu() instanceof UIResource) {
            this.frame.setComponentPopupMenu(null);
        }
        super.uninstallComponents();
    }

    @Override
    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    private void updateStyle(JComponent c) {
        SynthContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            Icon frameIcon = this.frame.getFrameIcon();
            if (frameIcon == null || frameIcon instanceof UIResource) {
                this.frame.setFrameIcon(context.getStyle().getIcon(context, "InternalFrame.icon"));
            }
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.frame, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        if (this.frame.getLayout() == this.internalFrameLayout) {
            this.frame.setLayout(null);
        }
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new SynthInternalFrameTitlePane(w);
        this.titlePane.setName("InternalFrame.northPane");
        return this.titlePane;
    }

    @Override
    protected ComponentListener createComponentListener() {
        if (UIManager.getBoolean("InternalFrame.useTaskBar")) {
            return new BasicInternalFrameUI.ComponentHandler(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (SynthInternalFrameUI.this.frame != null && SynthInternalFrameUI.this.frame.isMaximum()) {
                        JDesktopPane desktop = (JDesktopPane)e.getSource();
                        for (Component comp : desktop.getComponents()) {
                            if (!(comp instanceof SynthDesktopPaneUI.TaskBar)) continue;
                            SynthInternalFrameUI.this.frame.setBounds(0, 0, desktop.getWidth(), desktop.getHeight() - comp.getHeight());
                            SynthInternalFrameUI.this.frame.revalidate();
                            break;
                        }
                    }
                    JInternalFrame f = SynthInternalFrameUI.this.frame;
                    SynthInternalFrameUI.this.frame = null;
                    super.componentResized(e);
                    SynthInternalFrameUI.this.frame = f;
                }
            };
        }
        return super.createComponentListener();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintInternalFrameBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintInternalFrameBorder(context, g, x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        SynthStyle oldStyle = this.style;
        JInternalFrame f = (JInternalFrame)evt.getSource();
        String prop = evt.getPropertyName();
        if (SynthLookAndFeel.shouldUpdateStyle(evt)) {
            this.updateStyle(f);
        }
        if (this.style == oldStyle && (prop == "maximum" || prop == "selected")) {
            SynthContext context = this.getContext(f, 1);
            this.style.uninstallDefaults(context);
            this.style.installDefaults(context, this);
        }
    }
}

