/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalSliderUI
extends BasicSliderUI {
    protected final int TICK_BUFFER = 4;
    protected boolean filledSlider = false;
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;
    protected static int trackWidth;
    protected static int tickLength;
    private int safeLength;
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;
    private static Icon SAFE_HORIZ_THUMB_ICON;
    private static Icon SAFE_VERT_THUMB_ICON;
    protected final String SLIDER_FILL = "JSlider.isFilled";

    public static ComponentUI createUI(JComponent c) {
        return new MetalSliderUI();
    }

    public MetalSliderUI() {
        super(null);
    }

    private static Icon getHorizThumbIcon() {
        if (System.getSecurityManager() != null) {
            return SAFE_HORIZ_THUMB_ICON;
        }
        return horizThumbIcon;
    }

    private static Icon getVertThumbIcon() {
        if (System.getSecurityManager() != null) {
            return SAFE_VERT_THUMB_ICON;
        }
        return vertThumbIcon;
    }

    @Override
    public void installUI(JComponent c) {
        trackWidth = (Integer)UIManager.get("Slider.trackWidth");
        tickLength = this.safeLength = ((Integer)UIManager.get("Slider.majorTickLength")).intValue();
        horizThumbIcon = SAFE_HORIZ_THUMB_ICON = UIManager.getIcon("Slider.horizontalThumbIcon");
        vertThumbIcon = SAFE_VERT_THUMB_ICON = UIManager.getIcon("Slider.verticalThumbIcon");
        super.installUI(c);
        thumbColor = UIManager.getColor("Slider.thumb");
        highlightColor = UIManager.getColor("Slider.highlight");
        darkShadowColor = UIManager.getColor("Slider.darkShadow");
        this.scrollListener.setScrollByBlock(false);
        this.prepareFilledSliderField();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JSlider slider) {
        return new MetalPropertyListener();
    }

    private void prepareFilledSliderField() {
        this.filledSlider = MetalLookAndFeel.usingOcean();
        Object sliderFillProp = this.slider.getClientProperty("JSlider.isFilled");
        if (sliderFillProp != null) {
            this.filledSlider = (Boolean)sliderFillProp;
        }
    }

    @Override
    public void paintThumb(Graphics g) {
        Rectangle knobBounds = this.thumbRect;
        g.translate(knobBounds.x, knobBounds.y);
        if (this.slider.getOrientation() == 0) {
            MetalSliderUI.getHorizThumbIcon().paintIcon(this.slider, g, 0, 0);
        } else {
            MetalSliderUI.getVertThumbIcon().paintIcon(this.slider, g, 0, 0);
        }
        g.translate(-knobBounds.x, -knobBounds.y);
    }

    private Rectangle getPaintTrackRect() {
        int trackRight;
        int trackBottom;
        int trackLeft = 0;
        int trackTop = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - 1 - this.getThumbOverhang();
            trackTop = trackBottom - (this.getTrackWidth() - 1);
            trackRight = this.trackRect.width - 1;
        } else {
            if (MetalUtils.isLeftToRight(this.slider)) {
                trackLeft = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                trackRight = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                trackLeft = this.getThumbOverhang();
                trackRight = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            trackBottom = this.trackRect.height - 1;
        }
        return new Rectangle(this.trackRect.x + trackLeft, this.trackRect.y + trackTop, trackRight - trackLeft, trackBottom - trackTop);
    }

    @Override
    public void paintTrack(Graphics g) {
        int trackRight;
        int trackBottom;
        if (MetalLookAndFeel.usingOcean()) {
            this.oceanPaintTrack(g);
            return;
        }
        ColorUIResource trackColor = !this.slider.isEnabled() ? MetalLookAndFeel.getControlShadow() : this.slider.getForeground();
        boolean leftToRight = MetalUtils.isLeftToRight(this.slider);
        g.translate(this.trackRect.x, this.trackRect.y);
        int trackLeft = 0;
        int trackTop = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - 1 - this.getThumbOverhang();
            trackTop = trackBottom - (this.getTrackWidth() - 1);
            trackRight = this.trackRect.width - 1;
        } else {
            if (leftToRight) {
                trackLeft = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                trackRight = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                trackLeft = this.getThumbOverhang();
                trackRight = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            trackBottom = this.trackRect.height - 1;
        }
        if (this.slider.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawRect(trackLeft, trackTop, trackRight - trackLeft - 1, trackBottom - trackTop - 1);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(trackLeft + 1, trackBottom, trackRight, trackBottom);
            g.drawLine(trackRight, trackTop + 1, trackRight, trackBottom);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawLine(trackLeft + 1, trackTop + 1, trackRight - 2, trackTop + 1);
            g.drawLine(trackLeft + 1, trackTop + 1, trackLeft + 1, trackBottom - 2);
        } else {
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawRect(trackLeft, trackTop, trackRight - trackLeft - 1, trackBottom - trackTop - 1);
        }
        if (this.filledSlider) {
            int fillRight;
            int fillLeft;
            int fillBottom;
            int fillTop;
            if (this.slider.getOrientation() == 0) {
                int middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2;
                middleOfThumb -= this.trackRect.x;
                fillTop = !this.slider.isEnabled() ? trackTop : trackTop + 1;
                int n = fillBottom = !this.slider.isEnabled() ? trackBottom - 1 : trackBottom - 2;
                if (!this.drawInverted()) {
                    fillLeft = !this.slider.isEnabled() ? trackLeft : trackLeft + 1;
                    fillRight = middleOfThumb;
                } else {
                    fillLeft = middleOfThumb;
                    fillRight = !this.slider.isEnabled() ? trackRight - 1 : trackRight - 2;
                }
            } else {
                int middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2;
                middleOfThumb -= this.trackRect.y;
                fillLeft = !this.slider.isEnabled() ? trackLeft : trackLeft + 1;
                int n = fillRight = !this.slider.isEnabled() ? trackRight - 1 : trackRight - 2;
                if (!this.drawInverted()) {
                    fillTop = middleOfThumb;
                    fillBottom = !this.slider.isEnabled() ? trackBottom - 1 : trackBottom - 2;
                } else {
                    fillTop = !this.slider.isEnabled() ? trackTop : trackTop + 1;
                    fillBottom = middleOfThumb;
                }
            }
            if (this.slider.isEnabled()) {
                g.setColor(this.slider.getBackground());
                g.drawLine(fillLeft, fillTop, fillRight, fillTop);
                g.drawLine(fillLeft, fillTop, fillLeft, fillBottom);
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.fillRect(fillLeft + 1, fillTop + 1, fillRight - fillLeft, fillBottom - fillTop);
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.fillRect(fillLeft, fillTop, fillRight - fillLeft, fillBottom - fillTop);
            }
        }
        g.translate(-this.trackRect.x, -this.trackRect.y);
    }

    private void oceanPaintTrack(Graphics g) {
        boolean leftToRight = MetalUtils.isLeftToRight(this.slider);
        boolean drawInverted = this.drawInverted();
        Color sliderAltTrackColor = (Color)UIManager.get("Slider.altTrackColor");
        Rectangle paintRect = this.getPaintTrackRect();
        g.translate(paintRect.x, paintRect.y);
        int w = paintRect.width;
        int h = paintRect.height;
        if (this.slider.getOrientation() == 0) {
            int middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2 - paintRect.x;
            if (this.slider.isEnabled()) {
                if (middleOfThumb > 0) {
                    g.setColor(drawInverted ? MetalLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getPrimaryControlDarkShadow());
                    g.drawRect(0, 0, middleOfThumb - 1, h - 1);
                }
                if (middleOfThumb < w) {
                    g.setColor(drawInverted ? MetalLookAndFeel.getPrimaryControlDarkShadow() : MetalLookAndFeel.getControlDarkShadow());
                    g.drawRect(middleOfThumb, 0, w - middleOfThumb - 1, h - 1);
                }
                if (this.filledSlider) {
                    int fillMaxX;
                    int fillMinX;
                    g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                    if (drawInverted) {
                        fillMinX = middleOfThumb;
                        fillMaxX = w - 2;
                        g.drawLine(1, 1, middleOfThumb, 1);
                    } else {
                        fillMinX = 1;
                        fillMaxX = middleOfThumb;
                        g.drawLine(middleOfThumb, 1, w - 1, 1);
                    }
                    if (h == 6) {
                        g.setColor(MetalLookAndFeel.getWhite());
                        g.drawLine(fillMinX, 1, fillMaxX, 1);
                        g.setColor(sliderAltTrackColor);
                        g.drawLine(fillMinX, 2, fillMaxX, 2);
                        g.setColor(MetalLookAndFeel.getControlShadow());
                        g.drawLine(fillMinX, 3, fillMaxX, 3);
                        g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                        g.drawLine(fillMinX, 4, fillMaxX, 4);
                    }
                }
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                if (middleOfThumb > 0) {
                    if (!drawInverted && this.filledSlider) {
                        g.fillRect(0, 0, middleOfThumb - 1, h - 1);
                    } else {
                        g.drawRect(0, 0, middleOfThumb - 1, h - 1);
                    }
                }
                if (middleOfThumb < w) {
                    if (drawInverted && this.filledSlider) {
                        g.fillRect(middleOfThumb, 0, w - middleOfThumb - 1, h - 1);
                    } else {
                        g.drawRect(middleOfThumb, 0, w - middleOfThumb - 1, h - 1);
                    }
                }
            }
        } else {
            int middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2 - paintRect.y;
            if (this.slider.isEnabled()) {
                if (middleOfThumb > 0) {
                    g.setColor(drawInverted ? MetalLookAndFeel.getPrimaryControlDarkShadow() : MetalLookAndFeel.getControlDarkShadow());
                    g.drawRect(0, 0, w - 1, middleOfThumb - 1);
                }
                if (middleOfThumb < h) {
                    g.setColor(drawInverted ? MetalLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getPrimaryControlDarkShadow());
                    g.drawRect(0, middleOfThumb, w - 1, h - middleOfThumb - 1);
                }
                if (this.filledSlider) {
                    int fillMaxY;
                    int fillMinY;
                    g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                    if (this.drawInverted()) {
                        fillMinY = 1;
                        fillMaxY = middleOfThumb;
                        if (leftToRight) {
                            g.drawLine(1, middleOfThumb, 1, h - 1);
                        } else {
                            g.drawLine(w - 2, middleOfThumb, w - 2, h - 1);
                        }
                    } else {
                        fillMinY = middleOfThumb;
                        fillMaxY = h - 2;
                        if (leftToRight) {
                            g.drawLine(1, 1, 1, middleOfThumb);
                        } else {
                            g.drawLine(w - 2, 1, w - 2, middleOfThumb);
                        }
                    }
                    if (w == 6) {
                        g.setColor(leftToRight ? MetalLookAndFeel.getWhite() : MetalLookAndFeel.getPrimaryControlShadow());
                        g.drawLine(1, fillMinY, 1, fillMaxY);
                        g.setColor(leftToRight ? sliderAltTrackColor : MetalLookAndFeel.getControlShadow());
                        g.drawLine(2, fillMinY, 2, fillMaxY);
                        g.setColor(leftToRight ? MetalLookAndFeel.getControlShadow() : sliderAltTrackColor);
                        g.drawLine(3, fillMinY, 3, fillMaxY);
                        g.setColor(leftToRight ? MetalLookAndFeel.getPrimaryControlShadow() : MetalLookAndFeel.getWhite());
                        g.drawLine(4, fillMinY, 4, fillMaxY);
                    }
                }
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                if (middleOfThumb > 0) {
                    if (drawInverted && this.filledSlider) {
                        g.fillRect(0, 0, w - 1, middleOfThumb - 1);
                    } else {
                        g.drawRect(0, 0, w - 1, middleOfThumb - 1);
                    }
                }
                if (middleOfThumb < h) {
                    if (!drawInverted && this.filledSlider) {
                        g.fillRect(0, middleOfThumb, w - 1, h - middleOfThumb - 1);
                    } else {
                        g.drawRect(0, middleOfThumb, w - 1, h - middleOfThumb - 1);
                    }
                }
            }
        }
        g.translate(-paintRect.x, -paintRect.y);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    protected Dimension getThumbSize() {
        Dimension size = new Dimension();
        if (this.slider.getOrientation() == 1) {
            size.width = MetalSliderUI.getVertThumbIcon().getIconWidth();
            size.height = MetalSliderUI.getVertThumbIcon().getIconHeight();
        } else {
            size.width = MetalSliderUI.getHorizThumbIcon().getIconWidth();
            size.height = MetalSliderUI.getHorizThumbIcon().getIconHeight();
        }
        return size;
    }

    @Override
    public int getTickLength() {
        return this.slider.getOrientation() == 0 ? this.safeLength + 4 + 1 : this.safeLength + 4 + 3;
    }

    protected int getTrackWidth() {
        double kIdealTrackWidth = 7.0;
        double kIdealThumbHeight = 16.0;
        double kWidthScalar = 0.4375;
        if (this.slider.getOrientation() == 0) {
            return (int)(0.4375 * (double)this.thumbRect.height);
        }
        return (int)(0.4375 * (double)this.thumbRect.width);
    }

    protected int getTrackLength() {
        if (this.slider.getOrientation() == 0) {
            return this.trackRect.width;
        }
        return this.trackRect.height;
    }

    protected int getThumbOverhang() {
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    @Override
    protected void scrollDueToClickInTrack(int dir) {
        this.scrollByUnit(dir);
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        g.drawLine(x, 4, x, 4 + this.safeLength / 2);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        g.drawLine(x, 4, x, 4 + (this.safeLength - 1));
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        if (MetalUtils.isLeftToRight(this.slider)) {
            g.drawLine(4, y, 4 + this.safeLength / 2, y);
        } else {
            g.drawLine(0, y, this.safeLength / 2, y);
        }
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        if (MetalUtils.isLeftToRight(this.slider)) {
            g.drawLine(4, y, 4 + this.safeLength, y);
        } else {
            g.drawLine(0, y, this.safeLength, y);
        }
    }

    protected class MetalPropertyListener
    extends BasicSliderUI.PropertyChangeHandler {
        protected MetalPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            if (e.getPropertyName().equals("JSlider.isFilled")) {
                MetalSliderUI.this.prepareFilledSliderField();
            }
        }
    }
}

