/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import javax.security.auth.kerberos.KrbServicePermissionCollection;

public final class ServicePermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -1227585031618624935L;
    private static final int INITIATE = 1;
    private static final int ACCEPT = 2;
    private static final int ALL = 3;
    private static final int NONE = 0;
    private transient int mask;
    private String actions;

    public ServicePermission(String servicePrincipal, String action) {
        super(servicePrincipal);
        this.init(servicePrincipal, ServicePermission.getMask(action));
    }

    private void init(String servicePrincipal, int mask) {
        if (servicePrincipal == null) {
            throw new NullPointerException("service principal can't be null");
        }
        if ((mask & 3) != mask) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        this.mask = mask;
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof ServicePermission)) {
            return false;
        }
        ServicePermission that = (ServicePermission)p;
        return (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
    }

    boolean impliesIgnoreMask(ServicePermission p) {
        return this.getName().equals("*") || this.getName().equals(p.getName()) || p.getName().startsWith("@") && this.getName().endsWith(p.getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServicePermission)) {
            return false;
        }
        ServicePermission that = (ServicePermission)obj;
        return (this.mask & that.mask) == that.mask && this.getName().equals(that.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() ^ this.mask;
    }

    private static String getActions(int mask) {
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        if ((mask & 1) == 1) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("initiate");
        }
        if ((mask & 2) == 2) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("accept");
        }
        return sb.toString();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            this.actions = ServicePermission.getActions(this.mask);
        }
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new KrbServicePermissionCollection();
    }

    int getMask() {
        return this.mask;
    }

    private static int getMask(String action) {
        int matchlen;
        if (action == null) {
            throw new NullPointerException("action can't be null");
        }
        if (action.equals("")) {
            throw new IllegalArgumentException("action can't be empty");
        }
        int mask = 0;
        char[] a = action.toCharArray();
        if (a.length == 1 && a[0] == '-') {
            return mask;
        }
        for (int i = a.length - 1; i != -1; i -= matchlen) {
            char c;
            while (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --i;
            }
            if (!(i < 7 || a[i - 7] != 'i' && a[i - 7] != 'I' || a[i - 6] != 'n' && a[i - 6] != 'N' || a[i - 5] != 'i' && a[i - 5] != 'I' || a[i - 4] != 't' && a[i - 4] != 'T' || a[i - 3] != 'i' && a[i - 3] != 'I' || a[i - 2] != 'a' && a[i - 2] != 'A' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'e' && a[i] != 'E')) {
                matchlen = 8;
                mask |= 1;
            } else if (!(i < 5 || a[i - 5] != 'a' && a[i - 5] != 'A' || a[i - 4] != 'c' && a[i - 4] != 'C' || a[i - 3] != 'c' && a[i - 3] != 'C' || a[i - 2] != 'e' && a[i - 2] != 'E' || a[i - 1] != 'p' && a[i - 1] != 'P' || a[i] != 't' && a[i] != 'T')) {
                matchlen = 6;
                mask |= 2;
            } else {
                throw new IllegalArgumentException("invalid permission: " + action);
            }
            boolean seencomma = false;
            while (i >= matchlen && !seencomma) {
                switch (a[i - matchlen]) {
                    case ',': {
                        seencomma = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + action);
                    }
                }
                --i;
            }
        }
        return mask;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(this.getName(), ServicePermission.getMask(this.actions));
    }
}

