/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.policytool;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.text.MessageFormat;
import sun.security.action.GetPropertyAction;
import sun.security.tools.policytool.CancelButtonListener;
import sun.security.tools.policytool.ErrorOKButtonListener;
import sun.security.tools.policytool.FileMenuListener;
import sun.security.tools.policytool.MainWindowListener;
import sun.security.tools.policytool.NoDisplayException;
import sun.security.tools.policytool.PolicyEntry;
import sun.security.tools.policytool.PolicyListListener;
import sun.security.tools.policytool.PolicyTool;
import sun.security.tools.policytool.StatusOKButtonListener;
import sun.security.tools.policytool.ToolDialog;
import sun.security.tools.policytool.ToolWindowListener;

class ToolWindow
extends Frame {
    private static final long serialVersionUID = 5682568601210376777L;
    public static final Insets TOP_PADDING = new Insets(25, 0, 0, 0);
    public static final Insets BOTTOM_PADDING = new Insets(0, 0, 25, 0);
    public static final Insets LITE_BOTTOM_PADDING = new Insets(0, 0, 10, 0);
    public static final Insets LR_PADDING = new Insets(0, 10, 0, 10);
    public static final Insets TOP_BOTTOM_PADDING = new Insets(15, 0, 15, 0);
    public static final Insets L_TOP_BOTTOM_PADDING = new Insets(5, 10, 15, 0);
    public static final Insets LR_BOTTOM_PADDING = new Insets(0, 10, 5, 10);
    public static final Insets L_BOTTOM_PADDING = new Insets(0, 10, 5, 0);
    public static final Insets R_BOTTOM_PADDING = new Insets(0, 0, 5, 10);
    public static final String NEW_POLICY_FILE = PolicyTool.rb.getString("New");
    public static final String OPEN_POLICY_FILE = PolicyTool.rb.getString("Open");
    public static final String SAVE_POLICY_FILE = PolicyTool.rb.getString("Save");
    public static final String SAVE_AS_POLICY_FILE = PolicyTool.rb.getString("Save.As");
    public static final String VIEW_WARNINGS = PolicyTool.rb.getString("View.Warning.Log");
    public static final String QUIT = PolicyTool.rb.getString("Exit");
    public static final String ADD_POLICY_ENTRY = PolicyTool.rb.getString("Add.Policy.Entry");
    public static final String EDIT_POLICY_ENTRY = PolicyTool.rb.getString("Edit.Policy.Entry");
    public static final String REMOVE_POLICY_ENTRY = PolicyTool.rb.getString("Remove.Policy.Entry");
    public static final String EDIT_KEYSTORE = PolicyTool.rb.getString("Edit");
    public static final String ADD_PUBKEY_ALIAS = PolicyTool.rb.getString("Add.Public.Key.Alias");
    public static final String REMOVE_PUBKEY_ALIAS = PolicyTool.rb.getString("Remove.Public.Key.Alias");
    public static final int MW_FILENAME_LABEL = 0;
    public static final int MW_FILENAME_TEXTFIELD = 1;
    public static final int MW_PANEL = 2;
    public static final int MW_ADD_BUTTON = 0;
    public static final int MW_EDIT_BUTTON = 1;
    public static final int MW_REMOVE_BUTTON = 2;
    public static final int MW_POLICY_LIST = 3;
    private PolicyTool tool;

    ToolWindow(PolicyTool tool) {
        this.tool = tool;
    }

    private void initWindow() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu(PolicyTool.rb.getString("File"));
        menu.add(NEW_POLICY_FILE);
        menu.add(OPEN_POLICY_FILE);
        menu.add(SAVE_POLICY_FILE);
        menu.add(SAVE_AS_POLICY_FILE);
        menu.add(VIEW_WARNINGS);
        menu.add(QUIT);
        menu.addActionListener(new FileMenuListener(this.tool, this));
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        menu = new Menu(PolicyTool.rb.getString("KeyStore"));
        menu.add(EDIT_KEYSTORE);
        menu.addActionListener(new MainWindowListener(this.tool, this));
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        Label label = new Label(PolicyTool.rb.getString("Policy.File."));
        this.addNewComponent(this, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1, TOP_BOTTOM_PADDING);
        TextField tf = new TextField(50);
        tf.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("Policy.File."));
        tf.setEditable(false);
        this.addNewComponent(this, tf, 1, 1, 0, 1, 1, 0.0, 0.0, 1, TOP_BOTTOM_PADDING);
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Button button = new Button(ADD_POLICY_ENTRY);
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 0, 0, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        button = new Button(EDIT_POLICY_ENTRY);
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 1, 1, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        button = new Button(REMOVE_POLICY_ENTRY);
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 2, 2, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        this.addNewComponent(this, panel, 2, 0, 2, 2, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        String policyFile = this.tool.getPolicyFileName();
        if (policyFile == null) {
            String userHome = AccessController.doPrivileged(new GetPropertyAction("user.home"));
            policyFile = userHome + File.separatorChar + ".java.policy";
        }
        try {
            this.tool.openPolicy(policyFile);
            List list = new List(40, false);
            list.addActionListener(new PolicyListListener(this.tool, this));
            PolicyEntry[] entries = this.tool.getEntry();
            if (entries != null) {
                for (int i = 0; i < entries.length; ++i) {
                    list.add(entries[i].headerToString());
                }
            }
            TextField newFilename = (TextField)this.getComponent(1);
            newFilename.setText(policyFile);
            this.initPolicyList(list);
        }
        catch (FileNotFoundException fnfe) {
            List list = new List(40, false);
            list.addActionListener(new PolicyListListener(this.tool, this));
            this.initPolicyList(list);
            this.tool.setPolicyFileName(null);
            this.tool.modified = false;
            this.setVisible(true);
            this.tool.warnings.addElement(fnfe.toString());
        }
        catch (Exception e) {
            List list = new List(40, false);
            list.addActionListener(new PolicyListListener(this.tool, this));
            this.initPolicyList(list);
            this.tool.setPolicyFileName(null);
            this.tool.modified = false;
            this.setVisible(true);
            MessageFormat form = new MessageFormat(PolicyTool.rb.getString("Could.not.open.policy.file.policyFile.e.toString."));
            Object[] source = new Object[]{policyFile, e.toString()};
            this.displayErrorDialog(null, form.format(source));
        }
    }

    void addNewComponent(Container container, Component component, int index, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int fill, Insets is) {
        container.add(component, index);
        GridBagLayout gbl = (GridBagLayout)container.getLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.fill = fill;
        if (is != null) {
            gbc.insets = is;
        }
        gbl.setConstraints(component, gbc);
    }

    void addNewComponent(Container container, Component component, int index, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int fill) {
        this.addNewComponent(container, component, index, gridx, gridy, gridwidth, gridheight, weightx, weighty, fill, null);
    }

    void initPolicyList(List policyList) {
        this.addNewComponent(this, policyList, 3, 0, 3, 2, 1, 1.0, 1.0, 1);
    }

    void replacePolicyList(List policyList) {
        List list = (List)this.getComponent(3);
        list.removeAll();
        String[] newItems = policyList.getItems();
        for (int i = 0; i < newItems.length; ++i) {
            list.add(newItems[i]);
        }
    }

    void displayToolWindow(String[] args) {
        this.setTitle(PolicyTool.rb.getString("Policy.Tool"));
        this.setResizable(true);
        this.addWindowListener(new ToolWindowListener(this));
        this.setBounds(135, 80, 500, 500);
        this.setLayout(new GridBagLayout());
        this.initWindow();
        this.setVisible(true);
        if (this.tool.newWarning) {
            this.displayStatusDialog(this, PolicyTool.rb.getString("Errors.have.occurred.while.opening.the.policy.configuration.View.the.Warning.Log.for.more.information."));
        }
    }

    void displayErrorDialog(Window w, String error) {
        ToolDialog ed = new ToolDialog(PolicyTool.rb.getString("Error"), this.tool, this, true);
        Point location = w == null ? this.getLocationOnScreen() : w.getLocationOnScreen();
        ed.setBounds(location.x + 50, location.y + 50, 600, 100);
        ed.setLayout(new GridBagLayout());
        Label label = new Label(error);
        this.addNewComponent(ed, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        Button okButton = new Button(PolicyTool.rb.getString("OK"));
        okButton.addActionListener(new ErrorOKButtonListener(ed));
        this.addNewComponent(ed, okButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        ed.pack();
        ed.setVisible(true);
    }

    void displayErrorDialog(Window w, Throwable t) {
        if (t instanceof NoDisplayException) {
            return;
        }
        this.displayErrorDialog(w, t.toString());
    }

    void displayStatusDialog(Window w, String status) {
        ToolDialog sd = new ToolDialog(PolicyTool.rb.getString("Status"), this.tool, this, true);
        Point location = w == null ? this.getLocationOnScreen() : w.getLocationOnScreen();
        sd.setBounds(location.x + 50, location.y + 50, 500, 100);
        sd.setLayout(new GridBagLayout());
        Label label = new Label(status);
        this.addNewComponent(sd, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        Button okButton = new Button(PolicyTool.rb.getString("OK"));
        okButton.addActionListener(new StatusOKButtonListener(sd));
        this.addNewComponent(sd, okButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        sd.pack();
        sd.setVisible(true);
    }

    void displayWarningLog(Window w) {
        ToolDialog wd = new ToolDialog(PolicyTool.rb.getString("Warning"), this.tool, this, true);
        Point location = w == null ? this.getLocationOnScreen() : w.getLocationOnScreen();
        wd.setBounds(location.x + 50, location.y + 50, 500, 100);
        wd.setLayout(new GridBagLayout());
        TextArea ta = new TextArea();
        ta.setEditable(false);
        for (int i = 0; i < this.tool.warnings.size(); ++i) {
            ta.append(this.tool.warnings.elementAt(i));
            ta.append(PolicyTool.rb.getString("NEWLINE"));
        }
        this.addNewComponent(wd, ta, 0, 0, 0, 1, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        ta.setFocusable(false);
        Button okButton = new Button(PolicyTool.rb.getString("OK"));
        okButton.addActionListener(new CancelButtonListener(wd));
        this.addNewComponent(wd, okButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        wd.pack();
        wd.setVisible(true);
    }

    char displayYesNoDialog(Window w, String title, String prompt, String yes, String no) {
        final ToolDialog tw = new ToolDialog(title, this.tool, this, true);
        Point location = w == null ? this.getLocationOnScreen() : w.getLocationOnScreen();
        tw.setBounds(location.x + 75, location.y + 100, 400, 150);
        tw.setLayout(new GridBagLayout());
        TextArea ta = new TextArea(prompt, 10, 50, 1);
        ta.setEditable(false);
        this.addNewComponent(tw, ta, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        ta.setFocusable(false);
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        final StringBuffer chooseResult = new StringBuffer();
        Button button = new Button(yes);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                chooseResult.append('Y');
                tw.setVisible(false);
                tw.dispose();
            }
        });
        this.addNewComponent(panel, button, 0, 0, 0, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        button = new Button(no);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                chooseResult.append('N');
                tw.setVisible(false);
                tw.dispose();
            }
        });
        this.addNewComponent(panel, button, 1, 1, 0, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        this.addNewComponent(tw, panel, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        tw.pack();
        tw.setVisible(true);
        if (chooseResult.length() > 0) {
            return chooseResult.charAt(0);
        }
        return 'N';
    }
}

