/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sun.jmx.defaults.JmxProperties;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import sun.misc.JavaSecurityAccess;
import sun.misc.SharedSecrets;
import sun.reflect.misc.MethodUtil;
import sun.reflect.misc.ReflectUtil;

public class RequiredModelMBean
implements ModelMBean,
MBeanRegistration,
NotificationEmitter {
    ModelMBeanInfo modelMBeanInfo;
    private NotificationBroadcasterSupport generalBroadcaster = null;
    private NotificationBroadcasterSupport attributeBroadcaster = null;
    private Object managedResource = null;
    private boolean registered = false;
    private transient MBeanServer server = null;
    private static final JavaSecurityAccess javaSecurityAccess = SharedSecrets.getJavaSecurityAccess();
    private final AccessControlContext acc = AccessController.getContext();
    private static final Class<?>[] primitiveClasses = new Class[]{Integer.TYPE, Long.TYPE, Boolean.TYPE, Double.TYPE, Float.TYPE, Short.TYPE, Byte.TYPE, Character.TYPE};
    private static final Map<String, Class<?>> primitiveClassMap = new HashMap();
    private static Set<String> rmmbMethodNames;
    private static final String[] primitiveTypes;
    private static final String[] primitiveWrappers;

    public RequiredModelMBean() throws MBeanException, RuntimeOperationsException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "RequiredModelMBean()", "Entry");
        }
        this.modelMBeanInfo = this.createDefaultModelMBeanInfo();
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "RequiredModelMBean()", "Exit");
        }
    }

    public RequiredModelMBean(ModelMBeanInfo mbi) throws MBeanException, RuntimeOperationsException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "RequiredModelMBean(MBeanInfo)", "Entry");
        }
        this.setModelMBeanInfo(mbi);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "RequiredModelMBean(MBeanInfo)", "Exit");
        }
    }

    @Override
    public void setModelMBeanInfo(ModelMBeanInfo mbi) throws MBeanException, RuntimeOperationsException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setModelMBeanInfo(ModelMBeanInfo)", "Entry");
        }
        if (mbi == null) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setModelMBeanInfo(ModelMBeanInfo)", "ModelMBeanInfo is null: Raising exception.");
            }
            IllegalArgumentException x = new IllegalArgumentException("ModelMBeanInfo must not be null");
            String exceptionText = "Exception occurred trying to initialize the ModelMBeanInfo of the RequiredModelMBean";
            throw new RuntimeOperationsException(x, "Exception occurred trying to initialize the ModelMBeanInfo of the RequiredModelMBean");
        }
        if (this.registered) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setModelMBeanInfo(ModelMBeanInfo)", "RequiredMBean is registered: Raising exception.");
            }
            String exceptionText = "Exception occurred trying to set the ModelMBeanInfo of the RequiredModelMBean";
            IllegalStateException x = new IllegalStateException("cannot call setModelMBeanInfo while ModelMBean is registered");
            throw new RuntimeOperationsException(x, "Exception occurred trying to set the ModelMBeanInfo of the RequiredModelMBean");
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setModelMBeanInfo(ModelMBeanInfo)", "Setting ModelMBeanInfo to " + this.printModelMBeanInfo(mbi));
            int noOfNotifications = 0;
            if (mbi.getNotifications() != null) {
                noOfNotifications = mbi.getNotifications().length;
            }
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setModelMBeanInfo(ModelMBeanInfo)", "ModelMBeanInfo notifications has " + noOfNotifications + " elements");
        }
        this.modelMBeanInfo = (ModelMBeanInfo)mbi.clone();
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setModelMBeanInfo(ModelMBeanInfo)", "set mbeanInfo to: " + this.printModelMBeanInfo(this.modelMBeanInfo));
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setModelMBeanInfo(ModelMBeanInfo)", "Exit");
        }
    }

    @Override
    public void setManagedResource(Object mr, String mr_type) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setManagedResource(Object,String)", "Entry");
        }
        if (mr_type == null || !mr_type.equalsIgnoreCase("objectReference")) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setManagedResource(Object,String)", "Managed Resouce Type is not supported: " + mr_type);
            }
            throw new InvalidTargetObjectTypeException(mr_type);
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setManagedResource(Object,String)", "Managed Resouce is valid");
        }
        this.managedResource = mr;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setManagedResource(Object, String)", "Exit");
        }
    }

    @Override
    public void load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        ServiceNotFoundException x = new ServiceNotFoundException("Persistence not supported for this MBean");
        throw new MBeanException(x, x.getMessage());
    }

    @Override
    public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        ServiceNotFoundException x = new ServiceNotFoundException("Persistence not supported for this MBean");
        throw new MBeanException(x, x.getMessage());
    }

    private Object resolveForCacheValue(Descriptor descr) throws MBeanException, RuntimeOperationsException {
        Object objExpTime;
        String expTime;
        Descriptor mmbDescr;
        boolean tracing = JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER);
        String mth = "resolveForCacheValue(Descriptor)";
        if (tracing) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", "Entry");
        }
        Object response = null;
        boolean resetValue = false;
        boolean returnCachedValue = true;
        long currencyPeriod = 0L;
        if (descr == null) {
            if (tracing) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", "Input Descriptor is null");
            }
            return response;
        }
        if (tracing) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", "descriptor is " + descr);
        }
        if ((mmbDescr = this.modelMBeanInfo.getMBeanDescriptor()) == null && tracing) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", "MBean Descriptor is null");
        }
        if ((expTime = (objExpTime = descr.getFieldValue("currencyTimeLimit")) != null ? objExpTime.toString() : null) == null && mmbDescr != null) {
            objExpTime = mmbDescr.getFieldValue("currencyTimeLimit");
            expTime = objExpTime != null ? objExpTime.toString() : null;
        }
        if (expTime != null) {
            if (tracing) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", "currencyTimeLimit: " + expTime);
            }
            if ((currencyPeriod = new Long(expTime) * 1000L) < 0L) {
                returnCachedValue = false;
                resetValue = true;
                if (tracing) {
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", currencyPeriod + ": never Cached");
                }
            } else if (currencyPeriod == 0L) {
                returnCachedValue = true;
                resetValue = false;
                if (tracing) {
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", "always valid Cache");
                }
            } else {
                long now;
                Object objtStamp = descr.getFieldValue("lastUpdatedTimeStamp");
                String tStamp = objtStamp != null ? objtStamp.toString() : null;
                if (tracing) {
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", "lastUpdatedTimeStamp: " + tStamp);
                }
                if (tStamp == null) {
                    tStamp = "0";
                }
                long lastTime = new Long(tStamp);
                if (tracing) {
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", "currencyPeriod:" + currencyPeriod + " lastUpdatedTimeStamp:" + lastTime);
                }
                if ((now = new Date().getTime()) < lastTime + currencyPeriod) {
                    returnCachedValue = true;
                    resetValue = false;
                    if (tracing) {
                        JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", " timed valid Cache for " + now + " < " + (lastTime + currencyPeriod));
                    }
                } else {
                    returnCachedValue = false;
                    resetValue = true;
                    if (tracing) {
                        JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", "timed expired cache for " + now + " > " + (lastTime + currencyPeriod));
                    }
                }
            }
            if (tracing) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", "returnCachedValue:" + returnCachedValue + " resetValue: " + resetValue);
            }
            if (returnCachedValue) {
                Object currValue = descr.getFieldValue("value");
                if (currValue != null) {
                    response = currValue;
                    if (tracing) {
                        JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", "valid Cache value: " + currValue);
                    }
                } else {
                    response = null;
                    if (tracing) {
                        JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", "no Cached value");
                    }
                }
            }
            if (resetValue) {
                descr.removeField("lastUpdatedTimeStamp");
                descr.removeField("value");
                response = null;
                this.modelMBeanInfo.setDescriptor(descr, null);
                if (tracing) {
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", "reset cached value to null");
                }
            }
        }
        if (tracing) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveForCacheValue(Descriptor)", "Exit");
        }
        return response;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getMBeanInfo()", "Entry");
        }
        if (this.modelMBeanInfo == null) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getMBeanInfo()", "modelMBeanInfo is null");
            }
            this.modelMBeanInfo = this.createDefaultModelMBeanInfo();
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getMBeanInfo()", "ModelMBeanInfo is " + this.modelMBeanInfo.getClassName() + " for " + this.modelMBeanInfo.getDescription());
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getMBeanInfo()", this.printModelMBeanInfo(this.modelMBeanInfo));
        }
        return (MBeanInfo)this.modelMBeanInfo.clone();
    }

    private String printModelMBeanInfo(ModelMBeanInfo info) {
        StringBuilder retStr = new StringBuilder();
        if (info == null) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "printModelMBeanInfo(ModelMBeanInfo)", "ModelMBeanInfo to print is null, printing local ModelMBeanInfo");
            }
            info = this.modelMBeanInfo;
        }
        retStr.append("\nMBeanInfo for ModelMBean is:");
        retStr.append("\nCLASSNAME: \t" + info.getClassName());
        retStr.append("\nDESCRIPTION: \t" + info.getDescription());
        try {
            retStr.append("\nMBEAN DESCRIPTOR: \t" + info.getMBeanDescriptor());
        }
        catch (Exception e) {
            retStr.append("\nMBEAN DESCRIPTOR: \t is invalid");
        }
        retStr.append("\nATTRIBUTES");
        MBeanAttributeInfo[] attrInfo = info.getAttributes();
        if (attrInfo != null && attrInfo.length > 0) {
            for (int i = 0; i < attrInfo.length; ++i) {
                ModelMBeanAttributeInfo attInfo = (ModelMBeanAttributeInfo)attrInfo[i];
                retStr.append(" ** NAME: \t" + attInfo.getName());
                retStr.append("    DESCR: \t" + attInfo.getDescription());
                retStr.append("    TYPE: \t" + attInfo.getType() + "    READ: \t" + attInfo.isReadable() + "    WRITE: \t" + attInfo.isWritable());
                retStr.append("    DESCRIPTOR: " + attInfo.getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No attributes **");
        }
        retStr.append("\nCONSTRUCTORS");
        MBeanConstructorInfo[] constrInfo = info.getConstructors();
        if (constrInfo != null && constrInfo.length > 0) {
            for (int i = 0; i < constrInfo.length; ++i) {
                ModelMBeanConstructorInfo ctorInfo = (ModelMBeanConstructorInfo)constrInfo[i];
                retStr.append(" ** NAME: \t" + ctorInfo.getName());
                retStr.append("    DESCR: \t" + ctorInfo.getDescription());
                retStr.append("    PARAM: \t" + ctorInfo.getSignature().length + " parameter(s)");
                retStr.append("    DESCRIPTOR: " + ctorInfo.getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No Constructors **");
        }
        retStr.append("\nOPERATIONS");
        MBeanOperationInfo[] opsInfo = info.getOperations();
        if (opsInfo != null && opsInfo.length > 0) {
            for (int i = 0; i < opsInfo.length; ++i) {
                ModelMBeanOperationInfo operInfo = (ModelMBeanOperationInfo)opsInfo[i];
                retStr.append(" ** NAME: \t" + operInfo.getName());
                retStr.append("    DESCR: \t" + operInfo.getDescription());
                retStr.append("    PARAM: \t" + operInfo.getSignature().length + " parameter(s)");
                retStr.append("    DESCRIPTOR: " + operInfo.getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No operations ** ");
        }
        retStr.append("\nNOTIFICATIONS");
        MBeanNotificationInfo[] notifInfo = info.getNotifications();
        if (notifInfo != null && notifInfo.length > 0) {
            for (int i = 0; i < notifInfo.length; ++i) {
                ModelMBeanNotificationInfo nInfo = (ModelMBeanNotificationInfo)notifInfo[i];
                retStr.append(" ** NAME: \t" + nInfo.getName());
                retStr.append("    DESCR: \t" + nInfo.getDescription());
                retStr.append("    DESCRIPTOR: " + nInfo.getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No notifications **");
        }
        retStr.append(" ** ModelMBean: End of MBeanInfo ** ");
        return retStr.toString();
    }

    @Override
    public Object invoke(String opName, Object[] opArgs, String[] sig) throws MBeanException, ReflectionException {
        Object targetObject;
        Method method;
        ModelMBeanOperationInfo opInfo;
        String opMethodName;
        boolean tracing = JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER);
        String mth = "invoke(String, Object[], String[])";
        if (tracing) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "invoke(String, Object[], String[])", "Entry");
        }
        if (opName == null) {
            IllegalArgumentException x = new IllegalArgumentException("Method name must not be null");
            throw new RuntimeOperationsException(x, "An exception occurred while trying to invoke a method on a RequiredModelMBean");
        }
        String opClassName = null;
        int opSplitter = opName.lastIndexOf(".");
        if (opSplitter > 0) {
            opClassName = opName.substring(0, opSplitter);
            opMethodName = opName.substring(opSplitter + 1);
        } else {
            opMethodName = opName;
        }
        opSplitter = opMethodName.indexOf("(");
        if (opSplitter > 0) {
            opMethodName = opMethodName.substring(0, opSplitter);
        }
        if (tracing) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "invoke(String, Object[], String[])", "Finding operation " + opName + " as " + opMethodName);
        }
        if ((opInfo = this.modelMBeanInfo.getOperation(opMethodName)) == null) {
            String msg = "Operation " + opName + " not in ModelMBeanInfo";
            throw new MBeanException(new ServiceNotFoundException(msg), msg);
        }
        Descriptor opDescr = opInfo.getDescriptor();
        if (opDescr == null) {
            String msg = "Operation descriptor null";
            throw new MBeanException(new ServiceNotFoundException("Operation descriptor null"), "Operation descriptor null");
        }
        Object cached = this.resolveForCacheValue(opDescr);
        if (cached != null) {
            if (tracing) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "invoke(String, Object[], String[])", "Returning cached value");
            }
            return cached;
        }
        if (opClassName == null) {
            opClassName = (String)opDescr.getFieldValue("class");
        }
        if ((opMethodName = (String)opDescr.getFieldValue("name")) == null) {
            String msg = "Method descriptor must include `name' field";
            throw new MBeanException(new ServiceNotFoundException("Method descriptor must include `name' field"), "Method descriptor must include `name' field");
        }
        String targetTypeField = (String)opDescr.getFieldValue("targetType");
        if (targetTypeField != null && !targetTypeField.equalsIgnoreCase("objectReference")) {
            String msg = "Target type must be objectReference: " + targetTypeField;
            throw new MBeanException(new InvalidTargetObjectTypeException(msg), msg);
        }
        Object targetObjectField = opDescr.getFieldValue("targetObject");
        if (tracing && targetObjectField != null) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "invoke(String, Object[], String[])", "Found target object in descriptor");
        }
        if ((method = this.findRMMBMethod(opMethodName, targetObjectField, opClassName, sig)) != null) {
            targetObject = this;
        } else {
            Class targetClass;
            block27: {
                if (tracing) {
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "invoke(String, Object[], String[])", "looking for method in managedResource class");
                }
                if (targetObjectField != null) {
                    targetObject = targetObjectField;
                } else {
                    targetObject = this.managedResource;
                    if (targetObject == null) {
                        String msg = "managedResource for invoke " + opName + " is null";
                        ServiceNotFoundException snfe = new ServiceNotFoundException(msg);
                        throw new MBeanException(snfe);
                    }
                }
                if (opClassName != null) {
                    try {
                        AccessControlContext stack = AccessController.getContext();
                        final Object obj = targetObject;
                        final String className = opClassName;
                        final ClassNotFoundException[] caughtException = new ClassNotFoundException[1];
                        targetClass = (Class)javaSecurityAccess.doIntersectionPrivilege(new PrivilegedAction<Class<?>>(){

                            @Override
                            public Class<?> run() {
                                try {
                                    ReflectUtil.checkPackageAccess(className);
                                    ClassLoader targetClassLoader = obj.getClass().getClassLoader();
                                    return Class.forName(className, false, targetClassLoader);
                                }
                                catch (ClassNotFoundException e) {
                                    caughtException[0] = e;
                                    return null;
                                }
                            }
                        }, stack, this.acc);
                        if (caughtException[0] != null) {
                            throw caughtException[0];
                        }
                        break block27;
                    }
                    catch (ClassNotFoundException e) {
                        String msg = "class for invoke " + opName + " not found";
                        throw new ReflectionException(e, msg);
                    }
                }
                targetClass = targetObject.getClass();
            }
            method = this.resolveMethod(targetClass, opMethodName, sig);
        }
        if (tracing) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "invoke(String, Object[], String[])", "found " + opMethodName + ", now invoking");
        }
        Object result = this.invokeMethod(opName, method, targetObject, opArgs);
        if (tracing) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "invoke(String, Object[], String[])", "successfully invoked method");
        }
        if (result != null) {
            this.cacheResult(opInfo, opDescr, result);
        }
        return result;
    }

    private Method resolveMethod(Class<?> targetClass, String opMethodName, final String[] sig) throws ReflectionException {
        Class[] argClasses;
        final boolean tracing = JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER);
        if (tracing) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveMethod", "resolving " + targetClass.getName() + "." + opMethodName);
        }
        if (sig == null) {
            argClasses = null;
        } else {
            AccessControlContext stack = AccessController.getContext();
            final ReflectionException[] caughtException = new ReflectionException[1];
            final ClassLoader targetClassLoader = targetClass.getClassLoader();
            argClasses = new Class[sig.length];
            javaSecurityAccess.doIntersectionPrivilege(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    for (int i = 0; i < sig.length; ++i) {
                        if (tracing) {
                            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveMethod", "resolve type " + sig[i]);
                        }
                        argClasses[i] = (Class)primitiveClassMap.get(sig[i]);
                        if (argClasses[i] != null) continue;
                        try {
                            ReflectUtil.checkPackageAccess(sig[i]);
                            argClasses[i] = Class.forName(sig[i], false, targetClassLoader);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            if (tracing) {
                                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "resolveMethod", "class not found");
                            }
                            String msg = "Parameter class not found";
                            caughtException[0] = new ReflectionException(e, "Parameter class not found");
                        }
                    }
                    return null;
                }
            }, stack, this.acc);
            if (caughtException[0] != null) {
                throw caughtException[0];
            }
        }
        try {
            return targetClass.getMethod(opMethodName, argClasses);
        }
        catch (NoSuchMethodException e) {
            String msg = "Target method not found: " + targetClass.getName() + "." + opMethodName;
            throw new ReflectionException(e, msg);
        }
    }

    private Method findRMMBMethod(String opMethodName, Object targetObjectField, String opClassName, String[] sig) {
        Class targetClass;
        boolean tracing = JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER);
        if (tracing) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "invoke(String, Object[], String[])", "looking for method in RequiredModelMBean class");
        }
        if (!RequiredModelMBean.isRMMBMethodName(opMethodName)) {
            return null;
        }
        if (targetObjectField != null) {
            return null;
        }
        final Class rmmbClass = RequiredModelMBean.class;
        if (opClassName == null) {
            targetClass = rmmbClass;
        } else {
            AccessControlContext stack = AccessController.getContext();
            final String className = opClassName;
            targetClass = (Class)javaSecurityAccess.doIntersectionPrivilege(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    try {
                        ReflectUtil.checkPackageAccess(className);
                        ClassLoader targetClassLoader = rmmbClass.getClassLoader();
                        Class<?> clz = Class.forName(className, false, targetClassLoader);
                        if (!rmmbClass.isAssignableFrom(clz)) {
                            return null;
                        }
                        return clz;
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            }, stack, this.acc);
        }
        try {
            return targetClass != null ? this.resolveMethod(targetClass, opMethodName, sig) : null;
        }
        catch (ReflectionException e) {
            return null;
        }
    }

    private Object invokeMethod(String opName, final Method method, final Object targetObject, final Object[] opArgs) throws MBeanException, ReflectionException {
        try {
            final Throwable[] caughtException = new Throwable[1];
            AccessControlContext stack = AccessController.getContext();
            Object rslt = javaSecurityAccess.doIntersectionPrivilege(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        ReflectUtil.checkPackageAccess(method.getDeclaringClass());
                        return MethodUtil.invoke(method, targetObject, opArgs);
                    }
                    catch (InvocationTargetException e) {
                        caughtException[0] = e;
                    }
                    catch (IllegalAccessException e) {
                        caughtException[0] = e;
                    }
                    return null;
                }
            }, stack, this.acc);
            if (caughtException[0] != null) {
                if (caughtException[0] instanceof Exception) {
                    throw (Exception)caughtException[0];
                }
                if (caughtException[0] instanceof Error) {
                    throw (Error)caughtException[0];
                }
            }
            return rslt;
        }
        catch (RuntimeErrorException ree) {
            throw new RuntimeOperationsException(ree, "RuntimeException occurred in RequiredModelMBean while trying to invoke operation " + opName);
        }
        catch (RuntimeException re) {
            throw new RuntimeOperationsException(re, "RuntimeException occurred in RequiredModelMBean while trying to invoke operation " + opName);
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionException(iae, "IllegalAccessException occurred in RequiredModelMBean while trying to invoke operation " + opName);
        }
        catch (InvocationTargetException ite) {
            Throwable mmbTargEx = ite.getTargetException();
            if (mmbTargEx instanceof RuntimeException) {
                throw new MBeanException((RuntimeException)mmbTargEx, "RuntimeException thrown in RequiredModelMBean while trying to invoke operation " + opName);
            }
            if (mmbTargEx instanceof Error) {
                throw new RuntimeErrorException((Error)mmbTargEx, "Error occurred in RequiredModelMBean while trying to invoke operation " + opName);
            }
            if (mmbTargEx instanceof ReflectionException) {
                throw (ReflectionException)mmbTargEx;
            }
            throw new MBeanException((Exception)mmbTargEx, "Exception thrown in RequiredModelMBean while trying to invoke operation " + opName);
        }
        catch (Error err) {
            throw new RuntimeErrorException(err, "Error occurred in RequiredModelMBean while trying to invoke operation " + opName);
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Exception occurred in RequiredModelMBean while trying to invoke operation " + opName);
        }
    }

    private void cacheResult(ModelMBeanOperationInfo opInfo, Descriptor opDescr, Object result) throws MBeanException {
        Descriptor mmbDesc = this.modelMBeanInfo.getMBeanDescriptor();
        Object objctl = opDescr.getFieldValue("currencyTimeLimit");
        String ctl = objctl != null ? objctl.toString() : null;
        if (ctl == null && mmbDesc != null) {
            objctl = mmbDesc.getFieldValue("currencyTimeLimit");
            ctl = objctl != null ? objctl.toString() : null;
        }
        if (ctl != null && !ctl.equals("-1")) {
            opDescr.setField("value", result);
            opDescr.setField("lastUpdatedTimeStamp", String.valueOf(new Date().getTime()));
            this.modelMBeanInfo.setDescriptor(opDescr, "operation");
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "invoke(String,Object[],Object[])", "new descriptor is " + opDescr);
            }
        }
    }

    private static synchronized boolean isRMMBMethodName(String name) {
        if (rmmbMethodNames == null) {
            try {
                HashSet<String> names = new HashSet<String>();
                Method[] methods = RequiredModelMBean.class.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    names.add(methods[i].getName());
                }
                rmmbMethodNames = names;
            }
            catch (Exception e) {
                return true;
            }
        }
        return rmmbMethodNames.contains(name);
    }

    @Override
    public Object getAttribute(String attrName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object response;
        boolean tracing;
        block39: {
            if (attrName == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("attributeName must not be null"), "Exception occurred trying to get attribute of a RequiredModelMBean");
            }
            String mth = "getAttribute(String)";
            tracing = JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER);
            if (tracing) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "Entry with " + attrName);
            }
            try {
                if (this.modelMBeanInfo == null) {
                    throw new AttributeNotFoundException("getAttribute failed: ModelMBeanInfo not found for " + attrName);
                }
                ModelMBeanAttributeInfo attrInfo = this.modelMBeanInfo.getAttribute(attrName);
                Descriptor mmbDesc = this.modelMBeanInfo.getMBeanDescriptor();
                if (attrInfo == null) {
                    throw new AttributeNotFoundException("getAttribute failed: ModelMBeanAttributeInfo not found for " + attrName);
                }
                Descriptor attrDescr = attrInfo.getDescriptor();
                if (attrDescr != null) {
                    String responseClass;
                    if (!attrInfo.isReadable()) {
                        throw new AttributeNotFoundException("getAttribute failed: " + attrName + " is not readable ");
                    }
                    response = this.resolveForCacheValue(attrDescr);
                    if (tracing) {
                        JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "*** cached value is " + response);
                    }
                    if (response == null) {
                        String attrGetMethod;
                        if (tracing) {
                            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "**** cached value is null - getting getMethod");
                        }
                        if ((attrGetMethod = (String)attrDescr.getFieldValue("getMethod")) != null) {
                            Object getResponse;
                            if (tracing) {
                                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "invoking a getMethod for " + attrName);
                            }
                            if ((getResponse = this.invoke(attrGetMethod, new Object[0], new String[0])) != null) {
                                if (tracing) {
                                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "got a non-null response from getMethod\n");
                                }
                                response = getResponse;
                                Object objctl = attrDescr.getFieldValue("currencyTimeLimit");
                                String ctl = objctl != null ? objctl.toString() : null;
                                if (ctl == null && mmbDesc != null) {
                                    objctl = mmbDesc.getFieldValue("currencyTimeLimit");
                                    ctl = objctl != null ? objctl.toString() : null;
                                }
                                if (ctl != null && !ctl.equals("-1")) {
                                    if (tracing) {
                                        JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "setting cached value and lastUpdatedTime in descriptor");
                                    }
                                    attrDescr.setField("value", response);
                                    String stamp = String.valueOf(new Date().getTime());
                                    attrDescr.setField("lastUpdatedTimeStamp", stamp);
                                    attrInfo.setDescriptor(attrDescr);
                                    this.modelMBeanInfo.setDescriptor(attrDescr, "attribute");
                                    if (tracing) {
                                        JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "new descriptor is " + attrDescr);
                                        JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "AttributeInfo descriptor is " + attrInfo.getDescriptor());
                                        String attStr = this.modelMBeanInfo.getDescriptor(attrName, "attribute").toString();
                                        JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "modelMBeanInfo: AttributeInfo descriptor is " + attStr);
                                    }
                                }
                            } else {
                                if (tracing) {
                                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "got a null response from getMethod\n");
                                }
                                response = null;
                            }
                        } else {
                            String qualifier = "";
                            response = attrDescr.getFieldValue("value");
                            if (response == null) {
                                qualifier = "default ";
                                response = attrDescr.getFieldValue("default");
                            }
                            if (tracing) {
                                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "could not find getMethod for " + attrName + ", returning descriptor " + qualifier + "value");
                            }
                        }
                    }
                    final String respType = attrInfo.getType();
                    if (response == null || respType.equals(responseClass = response.getClass().getName())) break block39;
                    boolean wrongType = false;
                    boolean primitiveType = false;
                    boolean correspondingTypes = false;
                    for (int i = 0; i < primitiveTypes.length; ++i) {
                        if (!respType.equals(primitiveTypes[i])) continue;
                        primitiveType = true;
                        if (!responseClass.equals(primitiveWrappers[i])) break;
                        correspondingTypes = true;
                        break;
                    }
                    if (primitiveType) {
                        if (!correspondingTypes) {
                            wrongType = true;
                        }
                    } else {
                        boolean subtype;
                        block40: {
                            try {
                                final Class<?> respClass = response.getClass();
                                final Exception[] caughException = new Exception[1];
                                AccessControlContext stack = AccessController.getContext();
                                Class c = (Class)javaSecurityAccess.doIntersectionPrivilege(new PrivilegedAction<Class<?>>(){

                                    @Override
                                    public Class<?> run() {
                                        try {
                                            ReflectUtil.checkPackageAccess(respType);
                                            ClassLoader cl = respClass.getClassLoader();
                                            return Class.forName(respType, true, cl);
                                        }
                                        catch (Exception e) {
                                            caughException[0] = e;
                                            return null;
                                        }
                                    }
                                }, stack, this.acc);
                                if (caughException[0] != null) {
                                    throw caughException[0];
                                }
                                subtype = c.isInstance(response);
                            }
                            catch (Exception e) {
                                subtype = false;
                                if (!tracing) break block40;
                                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "Exception: ", e);
                            }
                        }
                        if (!subtype) {
                            wrongType = true;
                        }
                    }
                    if (wrongType) {
                        if (tracing) {
                            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "Wrong response type '" + respType + "'");
                        }
                        throw new MBeanException(new InvalidAttributeValueException("Wrong value type received for get attribute"), "An exception occurred while trying to get an attribute value through a RequiredModelMBean");
                    }
                    break block39;
                }
                if (tracing) {
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "getMethod failed " + attrName + " not in attributeDescriptor\n");
                }
                throw new MBeanException(new InvalidAttributeValueException("Unable to resolve attribute value, no getMethod defined in descriptor for attribute"), "An exception occurred while trying to get an attribute value through a RequiredModelMBean");
            }
            catch (MBeanException mbe) {
                throw mbe;
            }
            catch (AttributeNotFoundException t) {
                throw t;
            }
            catch (Exception e) {
                if (tracing) {
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "getMethod failed with " + e.getMessage() + " exception type " + e.getClass().toString());
                }
                throw new MBeanException(e, "An exception occurred while trying to get an attribute value: " + e.getMessage());
            }
        }
        if (tracing) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttribute(String)", "Exit");
        }
        return response;
    }

    @Override
    public AttributeList getAttributes(String[] attrNames) {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttributes(String[])", "Entry");
        }
        if (attrNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames must not be null"), "Exception occurred trying to get attributes of a RequiredModelMBean");
        }
        AttributeList responseList = new AttributeList();
        for (int i = 0; i < attrNames.length; ++i) {
            try {
                responseList.add(new Attribute(attrNames[i], this.getAttribute(attrNames[i])));
                continue;
            }
            catch (Exception e) {
                if (!JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) continue;
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttributes(String[])", "Failed to get \"" + attrNames[i] + "\": ", e);
            }
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getAttributes(String[])", "Exit");
        }
        return responseList;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Attribute oldAttr;
        boolean tracing = JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER);
        if (tracing) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setAttribute()", "Entry");
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attribute must not be null"), "Exception occurred trying to set an attribute of a RequiredModelMBean");
        }
        String attrName = attribute.getName();
        Object attrValue = attribute.getValue();
        boolean updateDescriptor = false;
        ModelMBeanAttributeInfo attrInfo = this.modelMBeanInfo.getAttribute(attrName);
        if (attrInfo == null) {
            throw new AttributeNotFoundException("setAttribute failed: " + attrName + " is not found ");
        }
        Descriptor mmbDesc = this.modelMBeanInfo.getMBeanDescriptor();
        Descriptor attrDescr = attrInfo.getDescriptor();
        if (attrDescr != null) {
            boolean updateCache;
            if (!attrInfo.isWritable()) {
                throw new AttributeNotFoundException("setAttribute failed: " + attrName + " is not writable ");
            }
            String attrSetMethod = (String)attrDescr.getFieldValue("setMethod");
            String attrGetMethod = (String)attrDescr.getFieldValue("getMethod");
            String attrType = attrInfo.getType();
            Object currValue = "Unknown";
            try {
                currValue = this.getAttribute(attrName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            oldAttr = new Attribute(attrName, currValue);
            if (attrSetMethod == null) {
                block23: {
                    if (attrValue != null) {
                        try {
                            Class<?> clazz = this.loadClass(attrType);
                            if (!clazz.isInstance(attrValue)) {
                                throw new InvalidAttributeValueException(clazz.getName() + " expected, " + attrValue.getClass().getName() + " received.");
                            }
                        }
                        catch (ClassNotFoundException x) {
                            if (!JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) break block23;
                            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setAttribute(Attribute)", "Class " + attrType + " for attribute " + attrName + " not found: ", x);
                        }
                    }
                }
                updateDescriptor = true;
            } else {
                this.invoke(attrSetMethod, new Object[]{attrValue}, new String[]{attrType});
            }
            Object objctl = attrDescr.getFieldValue("currencyTimeLimit");
            String ctl = objctl != null ? objctl.toString() : null;
            if (ctl == null && mmbDesc != null) {
                objctl = mmbDesc.getFieldValue("currencyTimeLimit");
                ctl = objctl != null ? objctl.toString() : null;
            }
            boolean bl = updateCache = ctl != null && !ctl.equals("-1");
            if (attrSetMethod == null && !updateCache && attrGetMethod != null) {
                throw new MBeanException(new ServiceNotFoundException("No setMethod field is defined in the descriptor for " + attrName + " attribute and caching is not enabled " + "for it"));
            }
            if (updateCache || updateDescriptor) {
                if (tracing) {
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setAttribute(Attribute)", "setting cached value of " + attrName + " to " + attrValue);
                }
                attrDescr.setField("value", attrValue);
                if (updateCache) {
                    String currtime = String.valueOf(new Date().getTime());
                    attrDescr.setField("lastUpdatedTimeStamp", currtime);
                }
                attrInfo.setDescriptor(attrDescr);
                this.modelMBeanInfo.setDescriptor(attrDescr, "attribute");
                if (tracing) {
                    StringBuilder strb = new StringBuilder().append("new descriptor is ").append(attrDescr).append(". AttributeInfo descriptor is ").append(attrInfo.getDescriptor()).append(". AttributeInfo descriptor is ").append(this.modelMBeanInfo.getDescriptor(attrName, "attribute"));
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setAttribute(Attribute)", strb.toString());
                }
            }
            if (tracing) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setAttribute(Attribute)", "sending sendAttributeNotification");
            }
        } else {
            if (tracing) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setAttribute(Attribute)", "setMethod failed " + attrName + " not in attributeDescriptor\n");
            }
            throw new InvalidAttributeValueException("Unable to resolve attribute value, no defined in descriptor for attribute");
        }
        this.sendAttributeChangeNotification(oldAttr, attribute);
        if (tracing) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setAttribute(Attribute)", "Exit");
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "setAttribute(Attribute)", "Entry");
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributes must not be null"), "Exception occurred trying to set attributes of a RequiredModelMBean");
        }
        AttributeList responseList = new AttributeList();
        for (Attribute attr : attributes.asList()) {
            try {
                this.setAttribute(attr);
                responseList.add(attr);
            }
            catch (Exception excep) {
                responseList.remove(attr);
            }
        }
        return responseList;
    }

    private ModelMBeanInfo createDefaultModelMBeanInfo() {
        return new ModelMBeanInfoSupport(this.getClass().getName(), "Default ModelMBean", null, null, null, null);
    }

    private synchronized void writeToLog(String logFileName, String logEntry) throws Exception {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "writeToLog(String, String)", "Notification Logging to " + logFileName + ": " + logEntry);
        }
        if (logFileName == null || logEntry == null) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "writeToLog(String, String)", "Bad input parameters, will not log this entry.");
            }
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(logFileName, true);){
            PrintStream logOut = new PrintStream(fos);
            logOut.println(logEntry);
            logOut.close();
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "writeToLog(String, String)", "Successfully opened log " + logFileName);
            }
        }
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        String mth = "addNotificationListener(NotificationListener, NotificationFilter, Object)";
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "addNotificationListener(NotificationListener, NotificationFilter, Object)", "Entry");
        }
        if (listener == null) {
            throw new IllegalArgumentException("notification listener must not be null");
        }
        if (this.generalBroadcaster == null) {
            this.generalBroadcaster = new NotificationBroadcasterSupport();
        }
        this.generalBroadcaster.addNotificationListener(listener, filter, handback);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "addNotificationListener(NotificationListener, NotificationFilter, Object)", "NotificationListener added");
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "addNotificationListener(NotificationListener, NotificationFilter, Object)", "Exit");
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (listener == null) {
            throw new ListenerNotFoundException("Notification listener is null");
        }
        String mth = "removeNotificationListener(NotificationListener)";
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "removeNotificationListener(NotificationListener)", "Entry");
        }
        if (this.generalBroadcaster == null) {
            throw new ListenerNotFoundException("No notification listeners registered");
        }
        this.generalBroadcaster.removeNotificationListener(listener);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "removeNotificationListener(NotificationListener)", "Exit");
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (listener == null) {
            throw new ListenerNotFoundException("Notification listener is null");
        }
        String mth = "removeNotificationListener(NotificationListener, NotificationFilter, Object)";
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "removeNotificationListener(NotificationListener, NotificationFilter, Object)", "Entry");
        }
        if (this.generalBroadcaster == null) {
            throw new ListenerNotFoundException("No notification listeners registered");
        }
        this.generalBroadcaster.removeNotificationListener(listener, filter, handback);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "removeNotificationListener(NotificationListener, NotificationFilter, Object)", "Exit");
        }
    }

    @Override
    public void sendNotification(Notification ntfyObj) throws MBeanException, RuntimeOperationsException {
        block11: {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "sendNotification(Notification)", "Entry");
            }
            if (ntfyObj == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("notification object must not be null"), "Exception occurred trying to send a notification from a RequiredModelMBean");
            }
            Descriptor ntfyDesc = this.modelMBeanInfo.getDescriptor(ntfyObj.getType(), "notification");
            Descriptor mmbDesc = this.modelMBeanInfo.getMBeanDescriptor();
            if (ntfyDesc != null) {
                String logging2 = (String)ntfyDesc.getFieldValue("log");
                if (logging2 == null && mmbDesc != null) {
                    logging2 = (String)mmbDesc.getFieldValue("log");
                }
                if (logging2 != null && (logging2.equalsIgnoreCase("t") || logging2.equalsIgnoreCase("true"))) {
                    String logfile = (String)ntfyDesc.getFieldValue("logfile");
                    if (logfile == null && mmbDesc != null) {
                        logfile = (String)mmbDesc.getFieldValue("logfile");
                    }
                    if (logfile != null) {
                        try {
                            this.writeToLog(logfile, "LogMsg: " + new Date(ntfyObj.getTimeStamp()).toString() + " " + ntfyObj.getType() + " " + ntfyObj.getMessage() + " Severity = " + (String)ntfyDesc.getFieldValue("severity"));
                        }
                        catch (Exception e) {
                            if (!JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINE)) break block11;
                            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINE, RequiredModelMBean.class.getName(), "sendNotification(Notification)", "Failed to log " + ntfyObj.getType() + " notification: ", e);
                        }
                    }
                }
            }
        }
        if (this.generalBroadcaster != null) {
            this.generalBroadcaster.sendNotification(ntfyObj);
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "sendNotification(Notification)", "sendNotification sent provided notification object");
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "sendNotification(Notification)", " Exit");
        }
    }

    @Override
    public void sendNotification(String ntfyText) throws MBeanException, RuntimeOperationsException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "sendNotification(String)", "Entry");
        }
        if (ntfyText == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("notification message must not be null"), "Exception occurred trying to send a text notification from a ModelMBean");
        }
        Notification myNtfyObj = new Notification("jmx.modelmbean.generic", (Object)this, 1L, ntfyText);
        this.sendNotification(myNtfyObj);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "sendNotification(String)", "Notification sent");
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "sendNotification(String)", "Exit");
        }
    }

    private static final boolean hasNotification(ModelMBeanInfo info, String notifName) {
        try {
            if (info == null) {
                return false;
            }
            return info.getNotification(notifName) != null;
        }
        catch (MBeanException x) {
            return false;
        }
        catch (RuntimeOperationsException r) {
            return false;
        }
    }

    private static final ModelMBeanNotificationInfo makeGenericInfo() {
        DescriptorSupport genericDescriptor = new DescriptorSupport("name=GENERIC", "descriptorType=notification", "log=T", "severity=6", "displayName=jmx.modelmbean.generic");
        return new ModelMBeanNotificationInfo(new String[]{"jmx.modelmbean.generic"}, "GENERIC", "A text notification has been issued by the managed resource", genericDescriptor);
    }

    private static final ModelMBeanNotificationInfo makeAttributeChangeInfo() {
        DescriptorSupport attributeDescriptor = new DescriptorSupport("name=ATTRIBUTE_CHANGE", "descriptorType=notification", "log=T", "severity=6", "displayName=jmx.attribute.change");
        return new ModelMBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "ATTRIBUTE_CHANGE", "Signifies that an observed MBean attribute value has changed", attributeDescriptor);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getNotificationInfo()", "Entry");
        }
        boolean hasGeneric = RequiredModelMBean.hasNotification(this.modelMBeanInfo, "GENERIC");
        boolean hasAttributeChange = RequiredModelMBean.hasNotification(this.modelMBeanInfo, "ATTRIBUTE_CHANGE");
        ModelMBeanNotificationInfo[] currInfo = (ModelMBeanNotificationInfo[])this.modelMBeanInfo.getNotifications();
        int len = (currInfo == null ? 0 : currInfo.length) + (hasGeneric ? 0 : 1) + (hasAttributeChange ? 0 : 1);
        MBeanNotificationInfo[] respInfo = new ModelMBeanNotificationInfo[len];
        int inserted = 0;
        if (!hasGeneric) {
            respInfo[inserted++] = RequiredModelMBean.makeGenericInfo();
        }
        if (!hasAttributeChange) {
            respInfo[inserted++] = RequiredModelMBean.makeAttributeChangeInfo();
        }
        int count = currInfo.length;
        int offset = inserted;
        for (int j = 0; j < count; ++j) {
            respInfo[offset + j] = currInfo[j];
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "getNotificationInfo()", "Exit");
        }
        return respInfo;
    }

    @Override
    public void addAttributeChangeNotificationListener(NotificationListener inlistener, String inAttributeName, Object inhandback) throws MBeanException, RuntimeOperationsException, IllegalArgumentException {
        int i;
        String mth = "addAttributeChangeNotificationListener(NotificationListener, String, Object)";
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "addAttributeChangeNotificationListener(NotificationListener, String, Object)", "Entry");
        }
        if (inlistener == null) {
            throw new IllegalArgumentException("Listener to be registered must not be null");
        }
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new NotificationBroadcasterSupport();
        }
        AttributeChangeNotificationFilter currFilter = new AttributeChangeNotificationFilter();
        MBeanAttributeInfo[] attrInfo = this.modelMBeanInfo.getAttributes();
        boolean found = false;
        if (inAttributeName == null) {
            if (attrInfo != null && attrInfo.length > 0) {
                for (i = 0; i < attrInfo.length; ++i) {
                    currFilter.enableAttribute(attrInfo[i].getName());
                }
            }
        } else {
            if (attrInfo != null && attrInfo.length > 0) {
                for (i = 0; i < attrInfo.length; ++i) {
                    if (!inAttributeName.equals(attrInfo[i].getName())) continue;
                    found = true;
                    currFilter.enableAttribute(inAttributeName);
                    break;
                }
            }
            if (!found) {
                throw new RuntimeOperationsException(new IllegalArgumentException("The attribute name does not exist"), "Exception occurred trying to add an AttributeChangeNotification listener");
            }
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            Vector<String> enabledAttrs = currFilter.getEnabledAttributes();
            String s = enabledAttrs.size() > 1 ? "[" + enabledAttrs.firstElement() + ", ...]" : enabledAttrs.toString();
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "addAttributeChangeNotificationListener(NotificationListener, String, Object)", "Set attribute change filter to " + s);
        }
        this.attributeBroadcaster.addNotificationListener(inlistener, currFilter, inhandback);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "addAttributeChangeNotificationListener(NotificationListener, String, Object)", "Notification listener added for " + inAttributeName);
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "addAttributeChangeNotificationListener(NotificationListener, String, Object)", "Exit");
        }
    }

    @Override
    public void removeAttributeChangeNotificationListener(NotificationListener inlistener, String inAttributeName) throws MBeanException, RuntimeOperationsException, ListenerNotFoundException {
        if (inlistener == null) {
            throw new ListenerNotFoundException("Notification listener is null");
        }
        String mth = "removeAttributeChangeNotificationListener(NotificationListener, String)";
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "removeAttributeChangeNotificationListener(NotificationListener, String)", "Entry");
        }
        if (this.attributeBroadcaster == null) {
            throw new ListenerNotFoundException("No attribute change notification listeners registered");
        }
        MBeanAttributeInfo[] attrInfo = this.modelMBeanInfo.getAttributes();
        boolean found = false;
        if (attrInfo != null && attrInfo.length > 0) {
            for (int i = 0; i < attrInfo.length; ++i) {
                if (!attrInfo[i].getName().equals(inAttributeName)) continue;
                found = true;
                break;
            }
        }
        if (!found && inAttributeName != null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid attribute name"), "Exception occurred trying to remove attribute change notification listener");
        }
        this.attributeBroadcaster.removeNotificationListener(inlistener);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "removeAttributeChangeNotificationListener(NotificationListener, String)", "Exit");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendAttributeChangeNotification(AttributeChangeNotification ntfyObj) throws MBeanException, RuntimeOperationsException {
        block20: {
            String logfile;
            String logging2;
            String mth = "sendAttributeChangeNotification(AttributeChangeNotification)";
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "sendAttributeChangeNotification(AttributeChangeNotification)", "Entry");
            }
            if (ntfyObj == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("attribute change notification object must not be null"), "Exception occurred trying to send attribute change notification of a ModelMBean");
            }
            Object oldv = ntfyObj.getOldValue();
            Object newv = ntfyObj.getNewValue();
            if (oldv == null) {
                oldv = "null";
            }
            if (newv == null) {
                newv = "null";
            }
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "sendAttributeChangeNotification(AttributeChangeNotification)", "Sending AttributeChangeNotification with " + ntfyObj.getAttributeName() + ntfyObj.getAttributeType() + ntfyObj.getNewValue() + ntfyObj.getOldValue());
            }
            Descriptor ntfyDesc = this.modelMBeanInfo.getDescriptor(ntfyObj.getType(), "notification");
            Descriptor mmbDesc = this.modelMBeanInfo.getMBeanDescriptor();
            if (ntfyDesc != null) {
                String logging3 = (String)ntfyDesc.getFieldValue("log");
                if (logging3 == null && mmbDesc != null) {
                    logging3 = (String)mmbDesc.getFieldValue("log");
                }
                if (logging3 != null && (logging3.equalsIgnoreCase("t") || logging3.equalsIgnoreCase("true"))) {
                    String logfile2 = (String)ntfyDesc.getFieldValue("logfile");
                    if (logfile2 == null && mmbDesc != null) {
                        logfile2 = (String)mmbDesc.getFieldValue("logfile");
                    }
                    if (logfile2 != null) {
                        try {
                            this.writeToLog(logfile2, "LogMsg: " + new Date(ntfyObj.getTimeStamp()).toString() + " " + ntfyObj.getType() + " " + ntfyObj.getMessage() + " Name = " + ntfyObj.getAttributeName() + " Old value = " + oldv + " New value = " + newv);
                        }
                        catch (Exception e) {
                            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINE)) {
                                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINE, RequiredModelMBean.class.getName(), "sendAttributeChangeNotification(AttributeChangeNotification)", "Failed to log " + ntfyObj.getType() + " notification: ", e);
                            }
                        }
                    }
                }
            } else if (mmbDesc != null && (logging2 = (String)mmbDesc.getFieldValue("log")) != null && (logging2.equalsIgnoreCase("t") || logging2.equalsIgnoreCase("true")) && (logfile = (String)mmbDesc.getFieldValue("logfile")) != null) {
                try {
                    this.writeToLog(logfile, "LogMsg: " + new Date(ntfyObj.getTimeStamp()).toString() + " " + ntfyObj.getType() + " " + ntfyObj.getMessage() + " Name = " + ntfyObj.getAttributeName() + " Old value = " + oldv + " New value = " + newv);
                }
                catch (Exception e) {
                    if (!JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINE)) break block20;
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINE, RequiredModelMBean.class.getName(), "sendAttributeChangeNotification(AttributeChangeNotification)", "Failed to log " + ntfyObj.getType() + " notification: ", e);
                }
            }
        }
        if (this.attributeBroadcaster != null) {
            this.attributeBroadcaster.sendNotification(ntfyObj);
        }
        if (this.generalBroadcaster != null) {
            this.generalBroadcaster.sendNotification(ntfyObj);
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "sendAttributeChangeNotification(AttributeChangeNotification)", "sent notification");
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "sendAttributeChangeNotification(AttributeChangeNotification)", "Exit");
        }
    }

    @Override
    public void sendAttributeChangeNotification(Attribute inOldVal, Attribute inNewVal) throws MBeanException, RuntimeOperationsException {
        String mth = "sendAttributeChangeNotification(Attribute, Attribute)";
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "sendAttributeChangeNotification(Attribute, Attribute)", "Entry");
        }
        if (inOldVal == null || inNewVal == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute object must not be null"), "Exception occurred trying to send attribute change notification of a ModelMBean");
        }
        if (!inOldVal.getName().equals(inNewVal.getName())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute names are not the same"), "Exception occurred trying to send attribute change notification of a ModelMBean");
        }
        Object newVal = inNewVal.getValue();
        Object oldVal = inOldVal.getValue();
        String className = "unknown";
        if (newVal != null) {
            className = newVal.getClass().getName();
        }
        if (oldVal != null) {
            className = oldVal.getClass().getName();
        }
        AttributeChangeNotification myNtfyObj = new AttributeChangeNotification(this, 1L, new Date().getTime(), "AttributeChangeDetected", inOldVal.getName(), className, inOldVal.getValue(), inNewVal.getValue());
        this.sendAttributeChangeNotification(myNtfyObj);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, RequiredModelMBean.class.getName(), "sendAttributeChangeNotification(Attribute, Attribute)", "Exit");
        }
    }

    protected ClassLoaderRepository getClassLoaderRepository() {
        return MBeanServerFactory.getClassLoaderRepository(this.server);
    }

    private Class<?> loadClass(final String className) throws ClassNotFoundException {
        AccessControlContext stack = AccessController.getContext();
        final ClassNotFoundException[] caughtException = new ClassNotFoundException[1];
        Class c = (Class)javaSecurityAccess.doIntersectionPrivilege(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    ReflectUtil.checkPackageAccess(className);
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    ClassLoaderRepository clr = RequiredModelMBean.this.getClassLoaderRepository();
                    try {
                        if (clr == null) {
                            throw new ClassNotFoundException(className);
                        }
                        return clr.loadClass(className);
                    }
                    catch (ClassNotFoundException ex) {
                        caughtException[0] = ex;
                        return null;
                    }
                }
            }
        }, stack, this.acc);
        if (caughtException[0] != null) {
            throw caughtException[0];
        }
        return c;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name == null) {
            throw new NullPointerException("name of RequiredModelMBean to registered is null");
        }
        this.server = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        this.registered = registrationDone;
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.registered = false;
        this.server = null;
    }

    static {
        for (int i = 0; i < primitiveClasses.length; ++i) {
            Class<?> c = primitiveClasses[i];
            primitiveClassMap.put(c.getName(), c);
        }
        primitiveTypes = new String[]{Boolean.TYPE.getName(), Byte.TYPE.getName(), Character.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Void.TYPE.getName()};
        primitiveWrappers = new String[]{Boolean.class.getName(), Byte.class.getName(), Character.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), Void.class.getName()};
    }
}

