/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class Util {
    public static ObjectName newObjectName(String string) {
        try {
            return new ObjectName(string);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static <K, V> Map<K, V> newMap() {
        return new HashMap();
    }

    static <K, V> Map<K, V> newSynchronizedMap() {
        return Collections.synchronizedMap(Util.newMap());
    }

    static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    static <K, V> Map<K, V> newSynchronizedIdentityHashMap() {
        IdentityHashMap<K, V> map = Util.newIdentityHashMap();
        return Collections.synchronizedMap(map);
    }

    static <K, V> SortedMap<K, V> newSortedMap() {
        return new TreeMap();
    }

    static <K, V> SortedMap<K, V> newSortedMap(Comparator<? super K> comp) {
        return new TreeMap(comp);
    }

    static <K, V> Map<K, V> newInsertionOrderMap() {
        return new LinkedHashMap();
    }

    static <E> Set<E> newSet() {
        return new HashSet();
    }

    static <E> Set<E> newSet(Collection<E> c) {
        return new HashSet<E>(c);
    }

    static <E> List<E> newList() {
        return new ArrayList();
    }

    static <E> List<E> newList(Collection<E> c) {
        return new ArrayList<E>(c);
    }

    public static <T> T cast(Object x) {
        return (T)x;
    }

    public static int hashCode(String[] names, Object[] values) {
        int hash = 0;
        for (int i = 0; i < names.length; ++i) {
            Object v = values[i];
            int h = v == null ? 0 : (v instanceof Object[] ? Arrays.deepHashCode((Object[])v) : (v.getClass().isArray() ? Arrays.deepHashCode(new Object[]{v}) - 31 : v.hashCode()));
            hash += names[i].toLowerCase().hashCode() ^ h;
        }
        return hash;
    }

    private static boolean wildmatch(String str, String pat, int stri, int strend, int pati, int patend) {
        int starpati = -1;
        int starstri = -1;
        block4: while (true) {
            if (pati < patend) {
                char patc = pat.charAt(pati);
                switch (patc) {
                    case '?': {
                        if (stri == strend) break;
                        ++stri;
                        ++pati;
                        continue block4;
                    }
                    case '*': {
                        starpati = ++pati;
                        starstri = stri;
                        continue block4;
                    }
                    default: {
                        if (stri < strend && str.charAt(stri) == patc) {
                            ++stri;
                            ++pati;
                            continue block4;
                        } else {
                            break;
                        }
                    }
                }
            } else if (stri == strend) {
                return true;
            }
            if (starpati < 0 || starstri == strend) {
                return false;
            }
            pati = starpati;
            stri = ++starstri;
        }
    }

    public static boolean wildmatch(String str, String pat) {
        return Util.wildmatch(str, pat, 0, str.length(), 0, pat.length());
    }
}

