/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto.dk;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.krb5.Confounder;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.KeyUsage;
import sun.security.krb5.internal.crypto.dk.DkCrypto;
import sun.security.provider.MD4;

public class ArcFourCrypto
extends DkCrypto {
    private static final boolean debug = false;
    private static final int confounderSize = 8;
    private static final byte[] ZERO_IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int hashSize = 16;
    private final int keyLength;

    public ArcFourCrypto(int length) {
        this.keyLength = length;
    }

    @Override
    protected int getKeySeedLength() {
        return this.keyLength;
    }

    @Override
    protected byte[] randomToKey(byte[] in) {
        return in;
    }

    public byte[] stringToKey(char[] passwd) throws GeneralSecurityException {
        return this.stringToKey(passwd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] stringToKey(char[] secret, byte[] opaque) throws GeneralSecurityException {
        if (opaque != null && opaque.length > 0) {
            throw new RuntimeException("Invalid parameter to stringToKey");
        }
        byte[] passwd = null;
        byte[] digest = null;
        try {
            passwd = ArcFourCrypto.charToUtf16(secret);
            MessageDigest md = MD4.getInstance();
            md.update(passwd);
            digest = md.digest();
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (passwd != null) {
                Arrays.fill(passwd, (byte)0);
            }
        }
        return digest;
    }

    @Override
    protected Cipher getCipher(byte[] key, byte[] ivec, int mode) throws GeneralSecurityException {
        if (ivec == null) {
            ivec = ZERO_IV;
        }
        SecretKeySpec secretKey = new SecretKeySpec(key, "ARCFOUR");
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        IvParameterSpec encIv = new IvParameterSpec(ivec, 0, ivec.length);
        cipher.init(mode, (Key)secretKey, encIv);
        return cipher;
    }

    @Override
    public int getChecksumLength() {
        return 16;
    }

    @Override
    protected byte[] getHmac(byte[] key, byte[] msg) throws GeneralSecurityException {
        SecretKeySpec keyKi = new SecretKeySpec(key, "HmacMD5");
        Mac m = Mac.getInstance("HmacMD5");
        m.init(keyKi);
        byte[] hash = m.doFinal(msg);
        return hash;
    }

    @Override
    public byte[] calculateChecksum(byte[] baseKey, int usage, byte[] input, int start, int len) throws GeneralSecurityException {
        if (!KeyUsage.isValid(usage)) {
            throw new GeneralSecurityException("Invalid key usage number: " + usage);
        }
        byte[] Ksign = null;
        try {
            byte[] ss = "signaturekey".getBytes();
            byte[] new_ss = new byte[ss.length + 1];
            System.arraycopy(ss, 0, new_ss, 0, ss.length);
            Ksign = this.getHmac(baseKey, new_ss);
        }
        catch (Exception e) {
            GeneralSecurityException gse = new GeneralSecurityException("Calculate Checkum Failed!");
            gse.initCause(e);
            throw gse;
        }
        byte[] salt = this.getSalt(usage);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            GeneralSecurityException gse = new GeneralSecurityException("Calculate Checkum Failed!");
            gse.initCause(e);
            throw gse;
        }
        messageDigest.update(salt);
        messageDigest.update(input, start, len);
        byte[] md5tmp = messageDigest.digest();
        byte[] hmac = this.getHmac(Ksign, md5tmp);
        if (hmac.length == this.getChecksumLength()) {
            return hmac;
        }
        if (hmac.length > this.getChecksumLength()) {
            byte[] buf = new byte[this.getChecksumLength()];
            System.arraycopy(hmac, 0, buf, 0, buf.length);
            return buf;
        }
        throw new GeneralSecurityException("checksum size too short: " + hmac.length + "; expecting : " + this.getChecksumLength());
    }

    public byte[] encryptSeq(byte[] baseKey, int usage, byte[] checksum, byte[] plaintext, int start, int len) throws GeneralSecurityException, KrbCryptoException {
        if (!KeyUsage.isValid(usage)) {
            throw new GeneralSecurityException("Invalid key usage number: " + usage);
        }
        byte[] salt = new byte[4];
        byte[] kSeq = this.getHmac(baseKey, salt);
        kSeq = this.getHmac(kSeq, checksum);
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        SecretKeySpec secretKey = new SecretKeySpec(kSeq, "ARCFOUR");
        cipher.init(1, secretKey);
        byte[] output = cipher.doFinal(plaintext, start, len);
        return output;
    }

    public byte[] decryptSeq(byte[] baseKey, int usage, byte[] checksum, byte[] ciphertext, int start, int len) throws GeneralSecurityException, KrbCryptoException {
        if (!KeyUsage.isValid(usage)) {
            throw new GeneralSecurityException("Invalid key usage number: " + usage);
        }
        byte[] salt = new byte[4];
        byte[] kSeq = this.getHmac(baseKey, salt);
        kSeq = this.getHmac(kSeq, checksum);
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        SecretKeySpec secretKey = new SecretKeySpec(kSeq, "ARCFOUR");
        cipher.init(2, secretKey);
        byte[] output = cipher.doFinal(ciphertext, start, len);
        return output;
    }

    @Override
    public byte[] encrypt(byte[] baseKey, int usage, byte[] ivec, byte[] new_ivec, byte[] plaintext, int start, int len) throws GeneralSecurityException, KrbCryptoException {
        if (!KeyUsage.isValid(usage)) {
            throw new GeneralSecurityException("Invalid key usage number: " + usage);
        }
        byte[] confounder = Confounder.bytes(8);
        int plainSize = this.roundup(confounder.length + len, 1);
        byte[] toBeEncrypted = new byte[plainSize];
        System.arraycopy(confounder, 0, toBeEncrypted, 0, confounder.length);
        System.arraycopy(plaintext, start, toBeEncrypted, confounder.length, len);
        byte[] k1 = new byte[baseKey.length];
        System.arraycopy(baseKey, 0, k1, 0, baseKey.length);
        byte[] salt = this.getSalt(usage);
        byte[] k2 = this.getHmac(k1, salt);
        byte[] checksum = this.getHmac(k2, toBeEncrypted);
        byte[] k3 = this.getHmac(k2, checksum);
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        SecretKeySpec secretKey = new SecretKeySpec(k3, "ARCFOUR");
        cipher.init(1, secretKey);
        byte[] output = cipher.doFinal(toBeEncrypted, 0, toBeEncrypted.length);
        byte[] result = new byte[16 + output.length];
        System.arraycopy(checksum, 0, result, 0, 16);
        System.arraycopy(output, 0, result, 16, output.length);
        return result;
    }

    @Override
    public byte[] encryptRaw(byte[] baseKey, int usage, byte[] seqNum, byte[] plaintext, int start, int len) throws GeneralSecurityException, KrbCryptoException {
        if (!KeyUsage.isValid(usage)) {
            throw new GeneralSecurityException("Invalid key usage number: " + usage);
        }
        byte[] klocal = new byte[baseKey.length];
        for (int i = 0; i <= 15; ++i) {
            klocal[i] = (byte)(baseKey[i] ^ 0xF0);
        }
        byte[] salt = new byte[4];
        byte[] kcrypt = this.getHmac(klocal, salt);
        kcrypt = this.getHmac(kcrypt, seqNum);
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        SecretKeySpec secretKey = new SecretKeySpec(kcrypt, "ARCFOUR");
        cipher.init(1, secretKey);
        byte[] output = cipher.doFinal(plaintext, start, len);
        return output;
    }

    @Override
    public byte[] decrypt(byte[] baseKey, int usage, byte[] ivec, byte[] ciphertext, int start, int len) throws GeneralSecurityException {
        if (!KeyUsage.isValid(usage)) {
            throw new GeneralSecurityException("Invalid key usage number: " + usage);
        }
        byte[] k1 = new byte[baseKey.length];
        System.arraycopy(baseKey, 0, k1, 0, baseKey.length);
        byte[] salt = this.getSalt(usage);
        byte[] k2 = this.getHmac(k1, salt);
        byte[] checksum = new byte[16];
        System.arraycopy(ciphertext, start, checksum, 0, 16);
        byte[] k3 = this.getHmac(k2, checksum);
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        SecretKeySpec secretKey = new SecretKeySpec(k3, "ARCFOUR");
        cipher.init(2, secretKey);
        byte[] plaintext = cipher.doFinal(ciphertext, start + 16, len - 16);
        byte[] calculatedHmac = this.getHmac(k2, plaintext);
        boolean cksumFailed = false;
        if (calculatedHmac.length >= 16) {
            for (int i = 0; i < 16; ++i) {
                if (calculatedHmac[i] == ciphertext[i]) continue;
                cksumFailed = true;
                break;
            }
        }
        if (cksumFailed) {
            throw new GeneralSecurityException("Checksum failed");
        }
        byte[] output = new byte[plaintext.length - 8];
        System.arraycopy(plaintext, 8, output, 0, output.length);
        return output;
    }

    public byte[] decryptRaw(byte[] baseKey, int usage, byte[] ivec, byte[] ciphertext, int start, int len, byte[] seqNum) throws GeneralSecurityException {
        if (!KeyUsage.isValid(usage)) {
            throw new GeneralSecurityException("Invalid key usage number: " + usage);
        }
        byte[] klocal = new byte[baseKey.length];
        for (int i = 0; i <= 15; ++i) {
            klocal[i] = (byte)(baseKey[i] ^ 0xF0);
        }
        byte[] salt = new byte[4];
        byte[] kcrypt = this.getHmac(klocal, salt);
        byte[] sequenceNum = new byte[4];
        System.arraycopy(seqNum, 0, sequenceNum, 0, sequenceNum.length);
        kcrypt = this.getHmac(kcrypt, sequenceNum);
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        SecretKeySpec secretKey = new SecretKeySpec(kcrypt, "ARCFOUR");
        cipher.init(2, secretKey);
        byte[] output = cipher.doFinal(ciphertext, start, len);
        return output;
    }

    private byte[] getSalt(int usage) {
        int ms_usage = this.arcfour_translate_usage(usage);
        byte[] salt = new byte[]{(byte)(ms_usage & 0xFF), (byte)(ms_usage >> 8 & 0xFF), (byte)(ms_usage >> 16 & 0xFF), (byte)(ms_usage >> 24 & 0xFF)};
        return salt;
    }

    private int arcfour_translate_usage(int usage) {
        switch (usage) {
            case 3: {
                return 8;
            }
            case 9: {
                return 8;
            }
            case 23: {
                return 13;
            }
        }
        return usage;
    }
}

