/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.net.dns.ResolverConfiguration;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Credentials;
import sun.security.krb5.KdcComm;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbServiceLocator;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.SCDynamicStoreConfig;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.crypto.EType;

public class Config {
    private static Config singleton = null;
    private Hashtable<String, Object> stanzaTable;
    private static boolean DEBUG = Krb5.DEBUG;
    private static final int BASE16_0 = 1;
    private static final int BASE16_1 = 16;
    private static final int BASE16_2 = 256;
    private static final int BASE16_3 = 4096;
    private final String defaultRealm;
    private final String defaultKDC;

    private static native String getWindowsDirectory(boolean var0);

    public static synchronized Config getInstance() throws KrbException {
        if (singleton == null) {
            singleton = new Config();
        }
        return singleton;
    }

    public static synchronized void refresh() throws KrbException {
        singleton = new Config();
        KdcComm.initStatic();
    }

    private static boolean isMacosLionOrBetter() {
        String osname = Config.getProperty("os.name");
        if (!osname.contains("OS X")) {
            return false;
        }
        String osVersion = Config.getProperty("os.version");
        String[] fragments = osVersion.split("\\.");
        if (!fragments[0].equals("10")) {
            return false;
        }
        if (fragments.length < 2) {
            return false;
        }
        try {
            int minorVers = Integer.parseInt(fragments[1]);
            if (minorVers >= 7) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private Config() throws KrbException {
        block11: {
            String tmp = Config.getProperty("java.security.krb5.kdc");
            this.defaultKDC = tmp != null ? tmp.replace(':', ' ') : null;
            this.defaultRealm = Config.getProperty("java.security.krb5.realm");
            if (this.defaultKDC == null && this.defaultRealm != null || this.defaultRealm == null && this.defaultKDC != null) {
                throw new KrbException("System property java.security.krb5.kdc and java.security.krb5.realm both must be set or neither must be set.");
            }
            try {
                String fileName = this.getJavaFileName();
                if (fileName != null) {
                    Vector<String> configFile = this.loadConfigFile(fileName);
                    this.stanzaTable = this.parseStanzaTable(configFile);
                    if (DEBUG) {
                        System.out.println("Loaded from Java config");
                    }
                    break block11;
                }
                boolean found = false;
                if (Config.isMacosLionOrBetter()) {
                    try {
                        this.stanzaTable = SCDynamicStoreConfig.getConfig();
                        if (DEBUG) {
                            System.out.println("Loaded from SCDynamicStoreConfig");
                        }
                        found = true;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!found) {
                    fileName = this.getNativeFileName();
                    Vector<String> configFile = this.loadConfigFile(fileName);
                    this.stanzaTable = this.parseStanzaTable(configFile);
                    if (DEBUG) {
                        System.out.println("Loaded from native config");
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getDefaultIntValue(String name) {
        String result = null;
        int value = Integer.MIN_VALUE;
        result = this.getDefault(name);
        if (result != null) {
            try {
                value = this.parseIntValue(result);
            }
            catch (NumberFormatException e) {
                if (DEBUG) {
                    System.out.println("Exception in getting value of " + name + " " + e.getMessage());
                    System.out.println("Setting " + name + " to minimum value");
                }
                value = Integer.MIN_VALUE;
            }
        }
        return value;
    }

    public int getDefaultIntValue(String name, String section) {
        String result = null;
        int value = Integer.MIN_VALUE;
        result = this.getDefault(name, section);
        if (result != null) {
            try {
                value = this.parseIntValue(result);
            }
            catch (NumberFormatException e) {
                if (DEBUG) {
                    System.out.println("Exception in getting value of " + name + " in section " + section + " " + e.getMessage());
                    System.out.println("Setting " + name + " to minimum value");
                }
                value = Integer.MIN_VALUE;
            }
        }
        return value;
    }

    public String getDefault(String name) {
        if (this.stanzaTable == null) {
            return null;
        }
        return this.getDefault(name, this.stanzaTable);
    }

    private String getDefault(String k, Hashtable<String, Object> t) {
        String result = null;
        if (this.stanzaTable != null) {
            Enumeration<String> e = t.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Object ob = t.get(key);
                if (ob instanceof Hashtable) {
                    Hashtable table = (Hashtable)ob;
                    result = this.getDefault(k, table);
                    if (result == null) continue;
                    return result;
                }
                if (!key.equalsIgnoreCase(k)) continue;
                if (ob instanceof String) {
                    return (String)t.get(key);
                }
                if (!(ob instanceof Vector)) continue;
                result = "";
                int length = ((Vector)ob).size();
                for (int i = 0; i < length; ++i) {
                    result = i == length - 1 ? result + (String)((Vector)ob).elementAt(i) : result + (String)((Vector)ob).elementAt(i) + " ";
                }
                return result;
            }
        }
        return result;
    }

    public String getDefault(String name, String section) {
        String result = null;
        if (this.stanzaTable != null) {
            Enumeration<String> e = this.stanzaTable.keys();
            while (e.hasMoreElements()) {
                Hashtable temp;
                Object ob;
                String stanzaName = e.nextElement();
                Hashtable subTable = (Hashtable)this.stanzaTable.get(stanzaName);
                if (stanzaName.equalsIgnoreCase(section)) {
                    if (!subTable.containsKey(name)) continue;
                    return (String)subTable.get(name);
                }
                if (!subTable.containsKey(section) || !((ob = subTable.get(section)) instanceof Hashtable) || !(temp = (Hashtable)ob).containsKey(name)) continue;
                Object object = temp.get(name);
                if (object instanceof Vector) {
                    result = "";
                    int length = ((Vector)object).size();
                    for (int i = 0; i < length; ++i) {
                        result = i == length - 1 ? result + (String)((Vector)object).elementAt(i) : result + (String)((Vector)object).elementAt(i) + " ";
                    }
                    continue;
                }
                result = (String)object;
            }
        }
        return result;
    }

    public boolean getDefaultBooleanValue(String name) {
        String val = null;
        val = this.stanzaTable == null ? null : this.getDefault(name, this.stanzaTable);
        return val != null && val.equalsIgnoreCase("true");
    }

    public boolean getDefaultBooleanValue(String name, String section) {
        String val = this.getDefault(name, section);
        return val != null && val.equalsIgnoreCase("true");
    }

    private Boolean getDefaultBooleanObject(String name, String section) {
        String s = this.getDefault(name, section);
        if (s == null) {
            return null;
        }
        switch (s.toLowerCase(Locale.US)) {
            case "yes": 
            case "true": {
                return Boolean.TRUE;
            }
            case "no": 
            case "false": {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private int parseIntValue(String input) throws NumberFormatException {
        int value = 0;
        if (input.startsWith("+")) {
            String temp = input.substring(1);
            return Integer.parseInt(temp);
        }
        if (input.startsWith("0x")) {
            String temp = input.substring(2);
            char[] chars = temp.toCharArray();
            if (chars.length > 8) {
                throw new NumberFormatException();
            }
            block18: for (int i = 0; i < chars.length; ++i) {
                int index = chars.length - i - 1;
                switch (chars[i]) {
                    case '0': {
                        value += 0;
                        continue block18;
                    }
                    case '1': {
                        value += 1 * this.getBase(index);
                        continue block18;
                    }
                    case '2': {
                        value += 2 * this.getBase(index);
                        continue block18;
                    }
                    case '3': {
                        value += 3 * this.getBase(index);
                        continue block18;
                    }
                    case '4': {
                        value += 4 * this.getBase(index);
                        continue block18;
                    }
                    case '5': {
                        value += 5 * this.getBase(index);
                        continue block18;
                    }
                    case '6': {
                        value += 6 * this.getBase(index);
                        continue block18;
                    }
                    case '7': {
                        value += 7 * this.getBase(index);
                        continue block18;
                    }
                    case '8': {
                        value += 8 * this.getBase(index);
                        continue block18;
                    }
                    case '9': {
                        value += 9 * this.getBase(index);
                        continue block18;
                    }
                    case 'A': 
                    case 'a': {
                        value += 10 * this.getBase(index);
                        continue block18;
                    }
                    case 'B': 
                    case 'b': {
                        value += 11 * this.getBase(index);
                        continue block18;
                    }
                    case 'C': 
                    case 'c': {
                        value += 12 * this.getBase(index);
                        continue block18;
                    }
                    case 'D': 
                    case 'd': {
                        value += 13 * this.getBase(index);
                        continue block18;
                    }
                    case 'E': 
                    case 'e': {
                        value += 14 * this.getBase(index);
                        continue block18;
                    }
                    case 'F': 
                    case 'f': {
                        value += 15 * this.getBase(index);
                        continue block18;
                    }
                    default: {
                        throw new NumberFormatException("Invalid numerical format");
                    }
                }
            }
            if (value < 0) {
                throw new NumberFormatException("Data overflow.");
            }
        } else {
            value = Integer.parseInt(input);
        }
        return value;
    }

    private int getBase(int i) {
        int result = 16;
        switch (i) {
            case 0: {
                result = 1;
                break;
            }
            case 1: {
                result = 16;
                break;
            }
            case 2: {
                result = 256;
                break;
            }
            case 3: {
                result = 4096;
                break;
            }
            default: {
                for (int j = 1; j < i; ++j) {
                    result *= 16;
                }
            }
        }
        return result;
    }

    private String find(String key1, String key2) {
        String result;
        if (this.stanzaTable != null && (result = (String)((Hashtable)this.stanzaTable.get(key1)).get(key2)) != null) {
            return result;
        }
        return "";
    }

    private Vector<String> loadConfigFile(final String fileName) throws IOException {
        try {
            if (!fileName.equals("")) {
                String Line2;
                BufferedReader br = new BufferedReader(new InputStreamReader(AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws IOException {
                        return new FileInputStream(fileName);
                    }
                })));
                Vector<String> v = new Vector<String>();
                String previous = null;
                while ((Line2 = br.readLine()) != null) {
                    if (Line2.startsWith("#") || Line2.trim().isEmpty()) continue;
                    String current = Line2.trim();
                    if (current.equals("{")) {
                        if (previous == null) {
                            throw new IOException("Config file should not start with \"{\"");
                        }
                        previous = previous + " " + current;
                        continue;
                    }
                    if (previous != null) {
                        v.addElement(previous);
                    }
                    previous = current;
                }
                if (previous != null) {
                    v.addElement(previous);
                }
                br.close();
                return v;
            }
            return null;
        }
        catch (PrivilegedActionException pe) {
            throw (IOException)pe.getException();
        }
    }

    private Hashtable<String, Object> parseStanzaTable(Vector<String> v) throws KrbException {
        if (v == null) {
            throw new KrbException("I/O error while reading configuration file.");
        }
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        block0: for (int i = 0; i < v.size(); ++i) {
            String line = v.elementAt(i).trim();
            if (line.equalsIgnoreCase("[realms]")) {
                for (int count = i + 1; count < v.size() + 1; ++count) {
                    if (count != v.size() && !v.elementAt(count).startsWith("[")) continue;
                    Hashtable<Object, Object> temp = new Hashtable();
                    temp = this.parseRealmField(v, i + 1, count);
                    table.put("realms", temp);
                    i = count - 1;
                    continue block0;
                }
                continue;
            }
            if (line.equalsIgnoreCase("[capaths]")) {
                for (int count = i + 1; count < v.size() + 1; ++count) {
                    if (count != v.size() && !v.elementAt(count).startsWith("[")) continue;
                    Hashtable<Object, Object> temp = new Hashtable();
                    temp = this.parseRealmField(v, i + 1, count);
                    table.put("capaths", temp);
                    i = count - 1;
                    continue block0;
                }
                continue;
            }
            if (!line.startsWith("[") || !line.endsWith("]")) continue;
            String key = line.substring(1, line.length() - 1);
            for (int count = i + 1; count < v.size() + 1; ++count) {
                if (count != v.size() && !v.elementAt(count).startsWith("[")) continue;
                Hashtable<String, String> temp = this.parseField(v, i + 1, count);
                table.put(key, temp);
                i = count - 1;
                continue block0;
            }
        }
        return table;
    }

    private String getJavaFileName() {
        String name = Config.getProperty("java.security.krb5.conf");
        if (name == null && !this.fileExists(name = Config.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "krb5.conf")) {
            name = null;
        }
        if (DEBUG) {
            System.out.println("Java config name: " + name);
        }
        return name;
    }

    private String getNativeFileName() {
        String name = null;
        String osname = Config.getProperty("os.name");
        if (osname.startsWith("Windows")) {
            try {
                Credentials.ensureLoaded();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Credentials.alreadyLoaded) {
                String path = Config.getWindowsDirectory(false);
                if (path != null && this.fileExists(path = path.endsWith("\\") ? path + "krb5.ini" : path + "\\krb5.ini")) {
                    name = path;
                }
                if (name == null && (path = Config.getWindowsDirectory(true)) != null) {
                    path = path.endsWith("\\") ? path + "krb5.ini" : path + "\\krb5.ini";
                    name = path;
                }
            }
            if (name == null) {
                name = "c:\\winnt\\krb5.ini";
            }
        } else {
            name = osname.startsWith("SunOS") ? "/etc/krb5/krb5.conf" : (osname.contains("OS X") ? this.findMacosConfigFile() : "/etc/krb5.conf");
        }
        if (DEBUG) {
            System.out.println("Native config name: " + name);
        }
        return name;
    }

    private static String getProperty(String property) {
        return AccessController.doPrivileged(new GetPropertyAction(property));
    }

    private String findMacosConfigFile() {
        String userHome = Config.getProperty("user.home");
        String PREF_FILE = "/Library/Preferences/edu.mit.Kerberos";
        String userPrefs = userHome + "/Library/Preferences/edu.mit.Kerberos";
        if (this.fileExists(userPrefs)) {
            return userPrefs;
        }
        if (this.fileExists("/Library/Preferences/edu.mit.Kerberos")) {
            return "/Library/Preferences/edu.mit.Kerberos";
        }
        return "/etc/krb5.conf";
    }

    private static String trimmed(String s) {
        if ((s = s.trim()).length() >= 2 && (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"' || s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'')) {
            s = s.substring(1, s.length() - 1).trim();
        }
        return s;
    }

    private Hashtable<String, String> parseField(Vector<String> v, int start, int end) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        block0: for (int i = start; i < end; ++i) {
            String line = v.elementAt(i);
            for (int j = 0; j < line.length(); ++j) {
                if (line.charAt(j) != '=') continue;
                String key = line.substring(0, j).trim();
                String value = Config.trimmed(line.substring(j + 1));
                table.put(key, value);
                continue block0;
            }
        }
        return table;
    }

    private Hashtable<String, Hashtable<String, Vector<String>>> parseRealmField(Vector<String> v, int start, int end) {
        Hashtable<String, Hashtable<String, Vector<String>>> table = new Hashtable<String, Hashtable<String, Vector<String>>>();
        block0: for (int i = start; i < end; ++i) {
            String line = v.elementAt(i).trim();
            if (!line.endsWith("{")) continue;
            String key = "";
            for (int j = 0; j < line.length(); ++j) {
                if (line.charAt(j) != '=') continue;
                key = line.substring(0, j).trim();
                break;
            }
            for (int k = i + 1; k < end; ++k) {
                boolean found = false;
                line = v.elementAt(k).trim();
                for (int l = 0; l < line.length(); ++l) {
                    if (line.charAt(l) != '}') continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                Hashtable<String, Vector<String>> temp = this.parseRealmFieldEx(v, i + 1, k);
                table.put(key, temp);
                i = k;
                found = false;
                continue block0;
            }
        }
        return table;
    }

    private Hashtable<String, Vector<String>> parseRealmFieldEx(Vector<String> v, int start, int end) {
        Hashtable<String, Vector<String>> table = new Hashtable<String, Vector<String>>();
        Vector<String> keyVector = new Vector<String>();
        Vector<Object> nameVector = new Vector();
        String line = "";
        block0: for (int i = start; i < end; ++i) {
            line = v.elementAt(i);
            for (int j = 0; j < line.length(); ++j) {
                if (line.charAt(j) != '=') continue;
                String key = line.substring(0, j).trim();
                if (!this.exists(key, keyVector)) {
                    keyVector.addElement(key);
                    nameVector = new Vector();
                } else {
                    nameVector = table.get(key);
                }
                nameVector.addElement(Config.trimmed(line.substring(j + 1)));
                table.put(key, nameVector);
                continue block0;
            }
        }
        return table;
    }

    private boolean exists(String key, Vector<String> v) {
        boolean exists = false;
        for (int i = 0; i < v.size(); ++i) {
            if (!v.elementAt(i).equals(key)) continue;
            exists = true;
        }
        return exists;
    }

    public void listTable() {
        this.listTable(this.stanzaTable);
    }

    private void listTable(Hashtable<String, Object> table) {
        Vector v = new Vector();
        if (this.stanzaTable != null) {
            Enumeration<String> e = table.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Object object = table.get(key);
                if (table == this.stanzaTable) {
                    System.out.println("[" + key + "]");
                }
                if (object instanceof Hashtable) {
                    if (table != this.stanzaTable) {
                        System.out.println("\t" + key + " = {");
                    }
                    this.listTable((Hashtable)object);
                    if (table == this.stanzaTable) continue;
                    System.out.println("\t}");
                    continue;
                }
                if (object instanceof String) {
                    System.out.println("\t" + key + " = " + (String)table.get(key));
                    continue;
                }
                if (!(object instanceof Vector)) continue;
                v = (Vector)object;
                for (int i = 0; i < v.size(); ++i) {
                    System.out.println("\t" + key + " = " + (String)v.elementAt(i));
                }
            }
        } else {
            System.out.println("Configuration file not found.");
        }
    }

    public int[] defaultEtype(String enctypes) {
        int[] etype;
        String default_enctypes = this.getDefault(enctypes, "libdefaults");
        String delim = " ";
        if (default_enctypes == null) {
            if (DEBUG) {
                System.out.println("Using builtin default etypes for " + enctypes);
            }
            etype = EType.getBuiltInDefaults();
        } else {
            int i;
            for (int j = 0; j < default_enctypes.length(); ++j) {
                if (!default_enctypes.substring(j, j + 1).equals(",")) continue;
                delim = ",";
                break;
            }
            StringTokenizer st = new StringTokenizer(default_enctypes, delim);
            int len = st.countTokens();
            ArrayList<Integer> ls = new ArrayList<Integer>(len);
            for (i = 0; i < len; ++i) {
                int type = this.getType(st.nextToken());
                if (type == -1 || !EType.isSupported(type)) continue;
                ls.add(type);
            }
            if (ls.isEmpty()) {
                if (DEBUG) {
                    System.out.println("no supported default etypes for " + enctypes);
                }
                return null;
            }
            etype = new int[ls.size()];
            for (i = 0; i < etype.length; ++i) {
                etype[i] = (Integer)ls.get(i);
            }
        }
        if (DEBUG) {
            System.out.print("default etypes for " + enctypes + ":");
            for (int i = 0; i < etype.length; ++i) {
                System.out.print(" " + etype[i]);
            }
            System.out.println(".");
        }
        return etype;
    }

    public int getType(String input) {
        int result = -1;
        if (input == null) {
            return result;
        }
        if (input.startsWith("d") || input.startsWith("D")) {
            if (input.equalsIgnoreCase("des-cbc-crc")) {
                result = 1;
            } else if (input.equalsIgnoreCase("des-cbc-md5")) {
                result = 3;
            } else if (input.equalsIgnoreCase("des-mac")) {
                result = 4;
            } else if (input.equalsIgnoreCase("des-mac-k")) {
                result = 5;
            } else if (input.equalsIgnoreCase("des-cbc-md4")) {
                result = 2;
            } else if (input.equalsIgnoreCase("des3-cbc-sha1") || input.equalsIgnoreCase("des3-hmac-sha1") || input.equalsIgnoreCase("des3-cbc-sha1-kd") || input.equalsIgnoreCase("des3-cbc-hmac-sha1-kd")) {
                result = 16;
            }
        } else if (input.startsWith("a") || input.startsWith("A")) {
            if (input.equalsIgnoreCase("aes128-cts") || input.equalsIgnoreCase("aes128-cts-hmac-sha1-96")) {
                result = 17;
            } else if (input.equalsIgnoreCase("aes256-cts") || input.equalsIgnoreCase("aes256-cts-hmac-sha1-96")) {
                result = 18;
            } else if (input.equalsIgnoreCase("arcfour-hmac") || input.equalsIgnoreCase("arcfour-hmac-md5")) {
                result = 23;
            }
        } else if (input.equalsIgnoreCase("rc4-hmac")) {
            result = 23;
        } else if (input.equalsIgnoreCase("CRC32")) {
            result = 1;
        } else if (input.startsWith("r") || input.startsWith("R")) {
            if (input.equalsIgnoreCase("rsa-md5")) {
                result = 7;
            } else if (input.equalsIgnoreCase("rsa-md5-des")) {
                result = 8;
            }
        } else if (input.equalsIgnoreCase("hmac-sha1-des3-kd")) {
            result = 12;
        } else if (input.equalsIgnoreCase("hmac-sha1-96-aes128")) {
            result = 15;
        } else if (input.equalsIgnoreCase("hmac-sha1-96-aes256")) {
            result = 16;
        } else if (input.equalsIgnoreCase("hmac-md5-rc4") || input.equalsIgnoreCase("hmac-md5-arcfour") || input.equalsIgnoreCase("hmac-md5-enc")) {
            result = -138;
        } else if (input.equalsIgnoreCase("NULL")) {
            result = 0;
        }
        return result;
    }

    public void resetDefaultRealm(String realm) {
        if (DEBUG) {
            System.out.println(">>> Config try resetting default kdc " + realm);
        }
    }

    public boolean useAddresses() {
        boolean useAddr = false;
        String value = this.getDefault("no_addresses", "libdefaults");
        boolean bl = useAddr = value != null && value.equalsIgnoreCase("false");
        if (!useAddr) {
            value = this.getDefault("noaddresses", "libdefaults");
            useAddr = value != null && value.equalsIgnoreCase("false");
        }
        return useAddr;
    }

    private boolean useDNS(String name, boolean defaultValue) {
        Boolean value = this.getDefaultBooleanObject(name, "libdefaults");
        if (value != null) {
            return value;
        }
        value = this.getDefaultBooleanObject("dns_fallback", "libdefaults");
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean useDNS_KDC() {
        return this.useDNS("dns_lookup_kdc", true);
    }

    public boolean useDNS_Realm() {
        return this.useDNS("dns_lookup_realm", false);
    }

    public String getDefaultRealm() throws KrbException {
        if (this.defaultRealm != null) {
            return this.defaultRealm;
        }
        KrbException cause = null;
        String realm = this.getDefault("default_realm", "libdefaults");
        if (realm == null && this.useDNS_Realm()) {
            try {
                realm = this.getRealmFromDNS();
            }
            catch (KrbException ke) {
                cause = ke;
            }
        }
        if (realm == null) {
            realm = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String osname = System.getProperty("os.name");
                    if (osname.startsWith("Windows")) {
                        return System.getenv("USERDNSDOMAIN");
                    }
                    return null;
                }
            });
        }
        if (realm == null) {
            KrbException ke = new KrbException("Cannot locate default realm");
            if (cause != null) {
                ke.initCause(cause);
            }
            throw ke;
        }
        return realm;
    }

    public String getKDCList(String realm) throws KrbException {
        if (realm == null) {
            realm = this.getDefaultRealm();
        }
        if (realm.equalsIgnoreCase(this.defaultRealm)) {
            return this.defaultKDC;
        }
        KrbException cause = null;
        String kdcs = this.getDefault("kdc", realm);
        if (kdcs == null && this.useDNS_KDC()) {
            try {
                kdcs = this.getKDCFromDNS(realm);
            }
            catch (KrbException ke) {
                cause = ke;
            }
        }
        if (kdcs == null) {
            kdcs = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String osname = System.getProperty("os.name");
                    if (osname.startsWith("Windows")) {
                        String logonServer = System.getenv("LOGONSERVER");
                        if (logonServer != null && logonServer.startsWith("\\\\")) {
                            logonServer = logonServer.substring(2);
                        }
                        return logonServer;
                    }
                    return null;
                }
            });
        }
        if (kdcs == null) {
            if (this.defaultKDC != null) {
                return this.defaultKDC;
            }
            KrbException ke = new KrbException("Cannot locate KDC");
            if (cause != null) {
                ke.initCause(cause);
            }
            throw ke;
        }
        return kdcs;
    }

    private String getRealmFromDNS() throws KrbException {
        String realm = null;
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            KrbException ke = new KrbException(60, "Unable to locate Kerberos realm: " + e.getMessage());
            ke.initCause(e);
            throw ke;
        }
        String mapRealm = PrincipalName.mapHostToRealm(hostName);
        if (mapRealm == null) {
            String domain;
            List<String> srchlist = ResolverConfiguration.open().searchlist();
            Iterator<String> i$ = srchlist.iterator();
            while (i$.hasNext() && (realm = Config.checkRealm(domain = i$.next())) == null) {
            }
        } else {
            realm = Config.checkRealm(mapRealm);
        }
        if (realm == null) {
            throw new KrbException(60, "Unable to locate Kerberos realm");
        }
        return realm;
    }

    private static String checkRealm(String mapRealm) {
        if (DEBUG) {
            System.out.println("getRealmFromDNS: trying " + mapRealm);
        }
        String[] records = null;
        String newRealm = mapRealm;
        while (records == null && newRealm != null) {
            records = KrbServiceLocator.getKerberosService(newRealm);
            newRealm = Realm.parseRealmComponent(newRealm);
        }
        if (records != null) {
            for (int i = 0; i < records.length; ++i) {
                if (!records[i].equalsIgnoreCase(mapRealm)) continue;
                return records[i];
            }
        }
        return null;
    }

    private String getKDCFromDNS(String realm) throws KrbException {
        String kdcs = "";
        String[] srvs = null;
        if (DEBUG) {
            System.out.println("getKDCFromDNS using UDP");
        }
        if ((srvs = KrbServiceLocator.getKerberosService(realm, "_udp")) == null) {
            if (DEBUG) {
                System.out.println("getKDCFromDNS using TCP");
            }
            srvs = KrbServiceLocator.getKerberosService(realm, "_tcp");
        }
        if (srvs == null) {
            throw new KrbException(60, "Unable to locate KDC for realm " + realm);
        }
        if (srvs.length == 0) {
            return null;
        }
        for (int i = 0; i < srvs.length; ++i) {
            kdcs = kdcs + srvs[i].trim() + " ";
        }
        if ((kdcs = kdcs.trim()).equals("")) {
            return null;
        }
        return kdcs;
    }

    private boolean fileExists(String name) {
        return AccessController.doPrivileged(new FileExistsAction(name));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Config.toStringInternal("", this.stanzaTable, sb);
        return sb.toString();
    }

    private static void toStringInternal(String prefix, Object obj, StringBuffer sb) {
        if (obj instanceof String) {
            sb.append(obj).append('\n');
        } else if (obj instanceof Hashtable) {
            Hashtable tab = (Hashtable)obj;
            sb.append("{\n");
            for (Object o : tab.keySet()) {
                sb.append(prefix).append("    ").append(o).append(" = ");
                Config.toStringInternal(prefix + "    ", tab.get(o), sb);
            }
            sb.append(prefix).append("}\n");
        } else if (obj instanceof Vector) {
            Vector v = (Vector)obj;
            sb.append("[");
            boolean first = true;
            for (Object o : v.toArray()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(o);
                first = false;
            }
            sb.append("]\n");
        }
    }

    static class FileExistsAction
    implements PrivilegedAction<Boolean> {
        private String fileName;

        public FileExistsAction(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public Boolean run() {
            return new File(this.fileName).exists();
        }
    }
}

