/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.cliparams;

import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.processors.cliparams.ArgumentCliParamProcessor;
import amazon.fws.clicommando.processors.cliparams.ArgumentsCliParamProcessor;
import amazon.fws.clicommando.processors.cliparams.CliParamProcessor;
import amazon.fws.clicommando.processors.cliparams.EscapingMapCliParamProcessor;
import amazon.fws.clicommando.processors.cliparams.MapCliParamProcessor;
import amazon.fws.clicommando.processors.cliparams.MultipleCliParamProcessor;
import amazon.fws.clicommando.processors.cliparams.SimpleCliParamProcessor;
import amazon.fws.clicommando.processors.cliparams.SwitchCliParamProcessor;

public class CliParamProcessorFactory {
    public static CliParamProcessor create(ParamConfig pc, String[] commandLineArgs) {
        CliParamProcessor cliParamProcessor = null;
        if (pc == null) {
            throw new ConfigurationErrorException(" Null argument for ParamConfig");
        }
        switch (pc.getType()) {
            case ARGUMENT: {
                cliParamProcessor = new ArgumentCliParamProcessor(pc, commandLineArgs);
                break;
            }
            case ARGUMENTS_LIST: {
                cliParamProcessor = new ArgumentsCliParamProcessor(pc, commandLineArgs);
                break;
            }
            case MULTIPLE: {
                cliParamProcessor = new MultipleCliParamProcessor(pc, commandLineArgs);
                break;
            }
            case SIMPLE: {
                cliParamProcessor = new SimpleCliParamProcessor(pc, commandLineArgs);
                break;
            }
            case SWITCH: {
                cliParamProcessor = new SwitchCliParamProcessor(pc, commandLineArgs);
                break;
            }
            case MAP: {
                cliParamProcessor = new MapCliParamProcessor(pc, commandLineArgs);
                break;
            }
            case ESCAPED_MAP: {
                cliParamProcessor = new EscapingMapCliParamProcessor(pc, commandLineArgs);
                break;
            }
            default: {
                throw new ConfigurationErrorException("No implementation for: " + pc.getType().name());
            }
        }
        return cliParamProcessor;
    }
}

