/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.config.MapConfig;
import amazon.fws.clicommando.config.MapKeyConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.util.HelpUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapValidatorCommandProcessor
implements CommandProcessor {
    List<String> missingEntries = new Vector<String>();
    List<String> illegalEntries = new Vector<String>();

    @Override
    public Command process(Command process) throws CliCommandoException {
        CommandConfig commandConfig = process.getCurrentCommandConfig();
        this.checkParameters(commandConfig.getArgumentsSortedByIndex());
        this.checkParameters(commandConfig.getParamsSortedByOptions());
        return process;
    }

    private void checkParameters(Collection<ParamConfig> parameters) {
        for (ParamConfig param : parameters) {
            if (param.getType() == ParamConfig.Type.MAP || param.getType() == ParamConfig.Type.ESCAPED_MAP) {
                List<Map<String, String>> valuesMaps = param.getValuesMap();
                for (Map<String, String> valuesMap : valuesMaps) {
                    MapConfig mapConfig = param.getMapConfig();
                    this.checkMissingEntries(valuesMap, mapConfig.getKeys());
                    this.checkIllegalEntries(valuesMap, mapConfig.getKeys());
                }
            }
            if (this.illegalEntries.size() != 0) {
                throw new BadInputException(ErrorMessages.ErrorCode.ILLEGAL_MAP_KEYS, HelpUtils.printLongOrShortValueOption("", param), this.createErrorInfo(this.illegalEntries));
            }
            if (this.missingEntries.size() == 0) continue;
            throw new BadInputException(ErrorMessages.ErrorCode.MISSING_MAP_KEYS, HelpUtils.printLongOrShortValueOption("", param), this.createErrorInfo(this.missingEntries));
        }
    }

    private void checkIllegalEntries(Map<String, String> valuesMap, Map<String, MapKeyConfig> keys) {
        if (keys == null || keys.size() == 0 || keys.get("*") != null) {
            return;
        }
        for (String key : valuesMap.keySet()) {
            if (keys.get(key) != null) continue;
            this.illegalEntries.add(key);
        }
    }

    private void checkMissingEntries(Map<String, String> valuesMap, Map<String, MapKeyConfig> keys) {
        if (keys == null || keys.size() == 0) {
            return;
        }
        for (MapKeyConfig key : keys.values()) {
            if (!key.isRequired() || valuesMap != null && valuesMap.containsKey(key.getName())) continue;
            this.missingEntries.add(key.getName());
        }
    }

    private String createErrorInfo(List<String> arguments) {
        StringBuilder sb = new StringBuilder();
        for (String val : arguments) {
            if (val == null) continue;
            sb.append(val + " ");
        }
        return sb.toString();
    }
}

