/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.IdentityHashMap;
import java.util.Set;

class ApplicationShutdownHooks {
    private static IdentityHashMap<Thread, Thread> hooks;

    private ApplicationShutdownHooks() {
    }

    static synchronized void add(Thread hook) {
        if (hooks == null) {
            throw new IllegalStateException("Shutdown in progress");
        }
        if (hook.isAlive()) {
            throw new IllegalArgumentException("Hook already running");
        }
        if (hooks.containsKey(hook)) {
            throw new IllegalArgumentException("Hook previously registered");
        }
        hooks.put(hook, hook);
    }

    static synchronized boolean remove(Thread hook) {
        if (hooks == null) {
            throw new IllegalStateException("Shutdown in progress");
        }
        if (hook == null) {
            throw new NullPointerException();
        }
        return hooks.remove(hook) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runHooks() {
        Class<ApplicationShutdownHooks> clazz = ApplicationShutdownHooks.class;
        synchronized (ApplicationShutdownHooks.class) {
            Set<Thread> threads = hooks.keySet();
            hooks = null;
            // ** MonitorExit[var1] (shouldn't be in output)
            for (Thread hook : threads) {
                hook.start();
            }
            for (Thread hook : threads) {
                try {
                    hook.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
    }

    static {
        try {
            Shutdown.add(1, false, new Runnable(){

                @Override
                public void run() {
                    ApplicationShutdownHooks.runHooks();
                }
            });
            hooks = new IdentityHashMap();
        }
        catch (IllegalStateException e) {
            hooks = null;
        }
    }
}

