/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectFloatBufferRU;
import java.nio.FloatBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectFloatBufferU
extends FloatBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(float[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectFloatBufferU(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.address = db.address() + (long)off;
        this.att = db;
    }

    @Override
    public FloatBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = pos << 2;
        assert (off >= 0);
        return new DirectFloatBufferU(this, -1, 0, rem, rem, off);
    }

    @Override
    public FloatBuffer duplicate() {
        return new DirectFloatBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return new DirectFloatBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return this.address;
    }

    private long ix(int i) {
        return this.address + ((long)i << 2);
    }

    @Override
    public float get() {
        return unsafe.getFloat(this.ix(this.nextGetIndex()));
    }

    @Override
    public float get(int i) {
        return unsafe.getFloat(this.ix(this.checkIndex(i)));
    }

    @Override
    public FloatBuffer get(float[] dst, int offset, int length) {
        if ((long)length << 2 > 6L) {
            int rem;
            DirectFloatBufferU.checkBounds(offset, length, dst.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToIntArray(this.ix(pos), dst, (long)offset << 2, (long)length << 2);
            } else {
                Bits.copyToArray(this.ix(pos), dst, arrayBaseOffset, (long)offset << 2, (long)length << 2);
            }
            this.position(pos + length);
        } else {
            super.get(dst, offset, length);
        }
        return this;
    }

    @Override
    public FloatBuffer put(float x) {
        unsafe.putFloat(this.ix(this.nextPutIndex()), x);
        return this;
    }

    @Override
    public FloatBuffer put(int i, float x) {
        unsafe.putFloat(this.ix(this.checkIndex(i)), x);
        return this;
    }

    @Override
    public FloatBuffer put(FloatBuffer src) {
        if (src instanceof DirectFloatBufferU) {
            int rem;
            if (src == this) {
                throw new IllegalArgumentException();
            }
            DirectFloatBufferU sb = (DirectFloatBufferU)src;
            int spos = sb.position();
            int slim = sb.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (srem > rem) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(sb.ix(spos), this.ix(pos), (long)srem << 2);
            sb.position(spos + srem);
            this.position(pos + srem);
        } else if (src.hb != null) {
            int spos = src.position();
            int slim = src.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            this.put(src.hb, src.offset + spos, srem);
            src.position(spos + srem);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public FloatBuffer put(float[] src, int offset, int length) {
        if ((long)length << 2 > 6L) {
            int rem;
            DirectFloatBufferU.checkBounds(offset, length, src.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromIntArray(src, (long)offset << 2, this.ix(pos), (long)length << 2);
            } else {
                Bits.copyFromArray(src, arrayBaseOffset, (long)offset << 2, this.ix(pos), (long)length << 2);
            }
            this.position(pos + length);
        } else {
            super.put(src, offset, length);
        }
        return this;
    }

    @Override
    public FloatBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        unsafe.copyMemory(this.ix(pos), this.ix(0), (long)rem << 2);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

