/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.plaf.synth;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.plaf.synth.SynthStyle;

public class StyleAssociation {
    private SynthStyle _style;
    private Pattern _pattern;
    private Matcher _matcher;
    private int _id;

    public static StyleAssociation createStyleAssociation(String text, SynthStyle style) throws PatternSyntaxException {
        return StyleAssociation.createStyleAssociation(text, style, 0);
    }

    public static StyleAssociation createStyleAssociation(String text, SynthStyle style, int id) throws PatternSyntaxException {
        return new StyleAssociation(text, style, id);
    }

    private StyleAssociation(String text, SynthStyle style, int id) throws PatternSyntaxException {
        this._style = style;
        this._pattern = Pattern.compile(text);
        this._id = id;
    }

    public int getID() {
        return this._id;
    }

    public synchronized boolean matches(CharSequence path) {
        if (this._matcher == null) {
            this._matcher = this._pattern.matcher(path);
        } else {
            this._matcher.reset(path);
        }
        return this._matcher.matches();
    }

    public String getText() {
        return this._pattern.pattern();
    }

    public SynthStyle getStyle() {
        return this._style;
    }
}

